/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.module.agricraft;

import com.infinityraider.agricraft.api.v1.AgriApi;
import com.infinityraider.agricraft.api.v1.crop.IAgriCrop;
import com.infinityraider.agricraft.api.v1.fertilizer.IAgriFertilizer;
import com.infinityraider.agricraft.api.v1.plant.IAgriPlant;
import com.infinityraider.agricraft.api.v1.seed.AgriSeed;
import com.infinityraider.agricraft.api.v1.soil.IAgriSoil;
import com.infinityraider.agricraft.api.v1.util.MethodResult;
import java.util.Optional;
import java.util.Random;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class SimulatedAgriCrop
implements IAgriCrop {
    private final TileEntity tile;
    private final AgriSeed seed;
    private final Optional<IAgriSoil> soil;

    public SimulatedAgriCrop(TileEntity tile, AgriSeed seed, ItemStack soilStack) {
        this.tile = tile;
        this.seed = seed;
        this.soil = AgriApi.getSoilRegistry().get(soilStack);
    }

    public BlockPos getCropPos() {
        return this.tile.func_174877_v();
    }

    public World getCropWorld() {
        return this.tile.func_145831_w();
    }

    public int getGrowthStage() {
        return this.seed.getPlant().getGrowthStages() - 1;
    }

    public boolean setGrowthStage(int stage) {
        return false;
    }

    public boolean isCrossCrop() {
        return false;
    }

    public boolean setCrossCrop(boolean crossCrop) {
        return false;
    }

    public boolean isFertile(@Nullable IAgriPlant plant) {
        return true;
    }

    public boolean isMature() {
        return true;
    }

    public Optional<IAgriSoil> getSoil() {
        return this.soil;
    }

    public MethodResult onGrowthTick() {
        return MethodResult.PASS;
    }

    public MethodResult onApplyCrops(@Nullable EntityPlayer player) {
        return MethodResult.PASS;
    }

    public MethodResult onApplySeeds(AgriSeed seed, @Nullable EntityPlayer player) {
        return MethodResult.PASS;
    }

    public MethodResult onBroken(Consumer<ItemStack> dropCollector, @Nullable EntityPlayer player) {
        return MethodResult.PASS;
    }

    public boolean acceptsFertilizer(@Nullable IAgriFertilizer fertilizer) {
        return false;
    }

    public MethodResult onApplyFertilizer(@Nullable IAgriFertilizer fertilizer, Random rand) {
        return MethodResult.PASS;
    }

    public MethodResult onHarvest(Consumer<ItemStack> dropCollector, @Nullable EntityPlayer player) {
        return MethodResult.PASS;
    }

    public boolean onRaked(Consumer<ItemStack> dropCollector, @Nullable EntityPlayer player) {
        return false;
    }

    public boolean acceptsSeed(@Nullable AgriSeed seed) {
        return false;
    }

    public boolean setSeed(@Nullable AgriSeed seed) {
        return false;
    }

    public boolean hasSeed() {
        return true;
    }

    @Nullable
    public AgriSeed getSeed() {
        return this.seed;
    }
}

