/*
 * Decompiled with CFR 0.152.
 */
package xyz.phanta.clochepp.module;

import blusunrize.immersiveengineering.api.tool.BelljarHandler;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraftforge.fml.common.Loader;
import xyz.phanta.clochepp.ClochePP;
import xyz.phanta.clochepp.CppConfig;
import xyz.phanta.clochepp.component.ComponentManager;
import xyz.phanta.clochepp.module.ClocheModule;
import xyz.phanta.clochepp.moduleapi.ClocheRegistrar;

public class ModuleSwitchboard {
    private static final Set<String> disabledModules = Sets.newHashSet((Object[])CppConfig.disabledModules);
    private final List<LoadedModule> loadedModules = new ArrayList<LoadedModule>();
    private final ComponentManager components = new ComponentManager();

    public void offerModuleCandidate(String className, String name, String id, @Nullable List<String> deps) {
        if (disabledModules.contains(name)) {
            ClochePP.LOGGER.info("Ignoring module {} ({}), since it's disabled in the config.", (Object)name, (Object)id);
            return;
        }
        ArrayList<String> missingDeps = new ArrayList<String>();
        if (deps != null) {
            for (String dep : deps) {
                if (Loader.isModLoaded((String)dep)) continue;
                missingDeps.add(dep);
            }
        }
        if (!missingDeps.isEmpty()) {
            ClochePP.LOGGER.info("Ignoring module {} ({}), since dep(s) {} are not met.", (Object)name, (Object)id, (Object)String.join((CharSequence)", ", missingDeps));
        } else {
            try {
                this.loadedModules.add(new LoadedModule(name, id, (ClocheModule)Class.forName(className).newInstance()));
                ClochePP.LOGGER.info("Loaded module {} ({}).", (Object)name, (Object)id);
            }
            catch (Exception e) {
                ClochePP.LOGGER.error("Encountered {} while loading module {} ({})!", (Object)e.getClass().getName(), (Object)name, (Object)id);
                ClochePP.LOGGER.error((Object)e);
            }
        }
    }

    public void preInit() {
        this.performModuleAction(m -> m.instance.init(), "initializing", "Initialized");
    }

    public void preInitClient() {
        this.performModuleAction(m -> m.instance.initClient(), "client-initializing", "Client-initialized");
    }

    public void init() {
        this.performModuleAction(m -> m.instance.registerComponents((c, d) -> this.components.getOrPut(m.name, c, d)), "registering components for", "Registered components for");
    }

    public void postInit() {
        BellJarHandlerWrapper registrar = new BellJarHandlerWrapper();
        this.performModuleAction(m -> m.instance.register(registrar), "registering data for", "Registered data for");
    }

    private void performModuleAction(Consumer<LoadedModule> action, String nameProg, String namePast) {
        for (LoadedModule module : this.loadedModules) {
            try {
                action.accept(module);
                ClochePP.LOGGER.debug("{} module {}.", (Object)namePast, (Object)module);
            }
            catch (Exception e) {
                ClochePP.LOGGER.error("Encountered {} while {} module {}!", (Object)e.getClass().getSimpleName(), (Object)nameProg, (Object)module);
                ClochePP.LOGGER.error("Stack trace:", (Throwable)e);
            }
        }
    }

    private static class BellJarHandlerWrapper
    implements ClocheRegistrar {
        private BellJarHandlerWrapper() {
        }

        @Override
        public void registerPlantHandler(BelljarHandler.IPlantHandler handler) {
            BelljarHandler.registerHandler((BelljarHandler.IPlantHandler)handler);
        }

        @Override
        public void registerFertilizerItemHandler(BelljarHandler.ItemFertilizerHandler handler) {
            BelljarHandler.registerItemFertilizer((BelljarHandler.ItemFertilizerHandler)handler);
        }

        @Override
        public void registerFertilizerFluidHandler(BelljarHandler.FluidFertilizerHandler handler) {
            BelljarHandler.registerFluidFertilizer((BelljarHandler.FluidFertilizerHandler)handler);
        }
    }

    private static class LoadedModule {
        final String name;
        final String id;
        final ClocheModule instance;

        LoadedModule(String name, String id, ClocheModule instance) {
            this.name = name;
            this.id = id;
            this.instance = instance;
        }

        public String toString() {
            return this.name + " (" + this.id + ")";
        }
    }
}

