/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.crafting;

import java.util.List;
import mod.chiselsandbits.api.IBitAccess;
import mod.chiselsandbits.api.ItemType;
import mod.chiselsandbits.api.StateCount;
import mod.chiselsandbits.chiseledblock.BlockBitInfo;
import mod.chiselsandbits.chiseledblock.ItemBlockChiseled;
import mod.chiselsandbits.chiseledblock.data.BitIterator;
import mod.chiselsandbits.chiseledblock.data.IntegerBox;
import mod.chiselsandbits.chiseledblock.data.VoxelBlob;
import mod.chiselsandbits.core.ChiselsAndBits;
import mod.chiselsandbits.core.api.BitAccess;
import mod.chiselsandbits.crafting.CustomRecipe;
import mod.chiselsandbits.helpers.ModUtil;
import mod.chiselsandbits.items.ItemBitSaw;
import mod.chiselsandbits.items.ItemChiseledBit;
import net.minecraft.block.state.IBlockState;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeHooks;

public class BitSawCrafting
extends CustomRecipe {
    public BitSawCrafting(ResourceLocation name) {
        super(name);
    }

    private SawCraft getSawCraft(InventoryCrafting inv) {
        SawCraft r = new SawCraft();
        for (int x = 0; x < inv.func_174922_i(); ++x) {
            for (int y = 0; y < inv.func_174923_h(); ++y) {
                ItemStack is = inv.func_70463_b(x, y);
                if (ModUtil.isEmpty(is)) continue;
                if (is.func_77973_b() instanceof ItemBitSaw) {
                    if (r.sawPosX != -1) {
                        return null;
                    }
                    r.sawPosX = x;
                    r.sawPosY = y;
                    continue;
                }
                if (is.func_77973_b() instanceof ItemBlockChiseled) {
                    if (r.blockPosX != -1) {
                        return null;
                    }
                    r.chisledBlock = is;
                    r.blockPosX = x;
                    r.blockPosY = y;
                    continue;
                }
                if (is != null && is.func_77973_b() instanceof ItemBlock) {
                    ItemBlock blkItem = (ItemBlock)is.func_77973_b();
                    IBlockState state = blkItem.func_179223_d().func_176223_P();
                    if (!BlockBitInfo.supportsBlock(state)) {
                        return null;
                    }
                    if (r.blockPosX != -1) {
                        return null;
                    }
                    r.chisledBlock = is;
                    r.blockPosX = x;
                    r.blockPosY = y;
                    continue;
                }
                return null;
            }
        }
        if (r.sawPosX == -1 || r.blockPosX == -1) {
            return null;
        }
        return r;
    }

    public boolean func_77569_a(InventoryCrafting inv, World worldIn) {
        return this.getSawCraft(inv) != null;
    }

    public ItemStack func_77572_b(InventoryCrafting inv) {
        SawCraft sc = this.getSawCraft(inv);
        if (sc == null) {
            return ModUtil.getEmptyStack();
        }
        IBitAccess contents = ChiselsAndBits.getApi().createBitItem(sc.chisledBlock);
        if (contents == null) {
            return ModUtil.getEmptyStack();
        }
        VoxelBlob blob = ((BitAccess)contents).getNativeBlob();
        VoxelBlob a = new VoxelBlob();
        VoxelBlob b = new VoxelBlob();
        int sawOffsetX = sc.sawPosX - sc.blockPosX;
        int sawOffsetY = sc.sawPosY - sc.blockPosY;
        EnumFacing.Axis direction = null;
        direction = sawOffsetY == 0 ? EnumFacing.Axis.X : (sawOffsetX == 0 ? EnumFacing.Axis.Y : EnumFacing.Axis.Z);
        int split_pos = 7;
        IntegerBox box = blob.getBounds();
        int scale = 0;
        switch (direction) {
            case X: {
                split_pos = MathHelper.func_76125_a((int)((box.maxX + box.minX) / 2), (int)0, (int)15);
                scale = (box.maxX - box.minX) / 2;
                break;
            }
            case Y: {
                split_pos = MathHelper.func_76125_a((int)((box.maxY + box.minY) / 2), (int)0, (int)15);
                scale = (box.maxY - box.minY) / 2;
                break;
            }
            case Z: {
                split_pos = MathHelper.func_76125_a((int)((box.maxZ + box.minZ) / 2), (int)0, (int)15);
                scale = (box.maxZ - box.minZ) / 2;
            }
        }
        int split_pos_plus_one = MathHelper.func_76125_a((int)(split_pos + 1), (int)0, (int)15);
        BitIterator bi = new BitIterator();
        while (bi.hasNext()) {
            int state = bi.getNext(blob);
            if (state == 0) continue;
            switch (direction) {
                case X: {
                    if (bi.x > split_pos) {
                        a.set(scale - (bi.x - split_pos_plus_one), bi.y - box.minY, bi.z - box.minZ, state);
                        break;
                    }
                    b.set(bi.x - box.minX, bi.y - box.minY, bi.z - box.minZ, state);
                    break;
                }
                case Y: {
                    if (bi.y > split_pos) {
                        a.set(bi.x - box.minX, scale - (bi.y - split_pos_plus_one), bi.z - box.minZ, state);
                        break;
                    }
                    b.set(bi.x - box.minX, bi.y - box.minY, bi.z - box.minZ, state);
                    break;
                }
                case Z: {
                    if (bi.z > split_pos) {
                        a.set(bi.x - box.minX, bi.y - box.minY, scale - (bi.z - split_pos_plus_one), state);
                        break;
                    }
                    b.set(bi.x - box.minX, bi.y - box.minY, bi.z - box.minZ, state);
                }
            }
        }
        if (a.equals(b)) {
            List<StateCount> refs = a.getStateCounts();
            if (refs.size() == 2) {
                ItemStack stack;
                boolean good = false;
                int outState = -1;
                for (StateCount tr : refs) {
                    if (tr.stateId != 0 && tr.quantity == 1) {
                        outState = tr.stateId;
                        continue;
                    }
                    if (tr.stateId != 0 || tr.quantity != 4095) continue;
                    good = true;
                }
                if (good && outState != -1 && (stack = ItemChiseledBit.createStack(outState, 2, false)) != null) {
                    return stack;
                }
            }
            blob.fill(a);
            ItemStack out = contents.getBitsAsItem(null, ItemType.CHISLED_BLOCK, false);
            if (out != null) {
                ModUtil.setStackSize(out, 2);
                return out;
            }
        }
        return ModUtil.getEmptyStack();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height > 3;
    }

    public ItemStack func_77571_b() {
        return ModUtil.getEmptyStack();
    }

    public NonNullList<ItemStack> func_179532_b(InventoryCrafting inv) {
        NonNullList aitemstack = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        for (int i = 0; i < aitemstack.size(); ++i) {
            ItemStack itemstack = inv.func_70301_a(i);
            aitemstack.set(i, (Object)ForgeHooks.getContainerItem((ItemStack)itemstack));
        }
        return aitemstack;
    }

    private static class SawCraft {
        int sawPosX = -1;
        int blockPosX = -1;
        int sawPosY = -1;
        int blockPosY = -1;
        ItemStack chisledBlock = null;

        private SawCraft() {
        }
    }
}

