/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.inventory;

import buildcraft.api.core.IStackFilter;
import buildcraft.lib.inventory.AbstractInvItemTransactor;
import buildcraft.lib.misc.StackUtil;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public final class ItemHandlerWrapper
extends AbstractInvItemTransactor {
    private final IItemHandler wrapped;

    public ItemHandlerWrapper(IItemHandler handler) {
        this.wrapped = handler;
    }

    @Override
    @Nonnull
    protected ItemStack insert(int slot, @Nonnull ItemStack stack, boolean simulate) {
        return this.wrapped.insertItem(slot, stack, simulate);
    }

    @Override
    @Nonnull
    protected ItemStack extract(int slot, IStackFilter filter, int min, int max, boolean simulate) {
        if (min <= 0) {
            min = 1;
        }
        if (max < min) {
            return StackUtil.EMPTY;
        }
        ItemStack current = this.wrapped.getStackInSlot(slot);
        if (current.func_190926_b() || current.func_190916_E() < min) {
            return StackUtil.EMPTY;
        }
        if (filter.matches(ItemHandlerWrapper.asValid(current))) {
            return this.wrapped.extractItem(slot, max, simulate);
        }
        return StackUtil.EMPTY;
    }

    @Override
    protected int getSlots() {
        return this.wrapped.getSlots();
    }

    @Override
    protected boolean isEmpty(int slot) {
        return this.wrapped.getStackInSlot(slot).func_190926_b();
    }
}

