/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.builders.container;

import buildcraft.api.filler.IFillerPattern;
import buildcraft.builders.filler.FillerType;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.IPayloadWriter;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.statement.FullStatement;
import java.io.IOException;
import java.util.stream.IntStream;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public interface IContainerFilling {
    public EntityPlayer getPlayer();

    public void sendMessage(int var1, IPayloadWriter var2);

    public FullStatement<IFillerPattern> getPatternStatementClient();

    public FullStatement<IFillerPattern> getPatternStatement();

    public boolean isInverted();

    public void setInverted(boolean var1);

    default public boolean isLocked() {
        return false;
    }

    public void valuesChanged();

    default public void init() {
        if (!this.getPlayer().field_70170_p.field_72995_K) {
            MessageUtil.doDelayedServer(this::sendData);
        }
    }

    default public void sendData() {
        this.sendMessage(ContainerBC_Neptune.NET_DATA, buffer -> {
            (this.getPlayer().field_70170_p.field_72995_K ? this.getPatternStatementClient() : this.getPatternStatement()).writeToBuffer(buffer);
            buffer.writeBoolean(this.isInverted());
        });
    }

    default public void onStatementChange() {
        this.sendData();
    }

    default public void sendInverted(boolean value) {
        this.setInverted(value);
        this.sendData();
    }

    default public void readMessage(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        if (side == Side.SERVER) {
            if (id == ContainerBC_Neptune.NET_DATA) {
                if (this.isLocked()) {
                    new FullStatement<IFillerPattern>(FillerType.INSTANCE, 4, (a, b) -> {}).readFromBuffer(buffer);
                } else {
                    this.getPatternStatement().readFromBuffer(buffer);
                }
                this.setInverted(buffer.readBoolean());
                this.valuesChanged();
                this.sendData();
            }
        } else if (side == Side.CLIENT && id == ContainerBC_Neptune.NET_DATA) {
            this.getPatternStatement().readFromBuffer(buffer);
            this.setInverted(buffer.readBoolean());
            this.getPatternStatementClient().set((IFillerPattern)this.getPatternStatement().get());
            IntStream.range(0, 4).forEach(i -> this.getPatternStatementClient().getParamRef(i).set(this.getPatternStatement().getParamRef(i).get()));
            this.valuesChanged();
        }
    }
}

