/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.core.mixin.avaritiaddons;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import com.cleanroommc.bogosorter.compat.InfinitySlotWrapper;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wanion.avaritiaddons.block.chest.infinity.ContainerInfinityChest;

@Mixin(value={ContainerInfinityChest.class})
public abstract class ContainerInfinityChestMixin {
    @Shadow
    @Nonnull
    public abstract ItemStack func_82846_b(@NotNull EntityPlayer var1, int var2);

    @Inject(method={"slotClick"}, at={@At(value="HEAD")}, cancellable=true)
    public void onSlotClick(int slotId, int dragType, ClickType clickTypeIn, EntityPlayer player, CallbackInfoReturnable<ItemStack> cir) {
        if (slotId < 0) {
            return;
        }
        Container container = (Container)this;
        ISlot slot = BogoSortAPI.getSlot(container, slotId);
        if (slot instanceof InfinitySlotWrapper && clickTypeIn == ClickType.QUICK_MOVE) {
            this.func_82846_b(player, slotId);
            cir.setReturnValue((Object)ItemStack.field_190927_a);
        }
    }

    @Inject(method={"transferStackInSlot"}, at={@At(value="HEAD")}, cancellable=true)
    public void transferItem(EntityPlayer entityPlayer, int slotNumber, CallbackInfoReturnable<ItemStack> cir) {
        SlotGroup otherSlots;
        Container container = (Container)this;
        ISlot slot = BogoSortAPI.getSlot(container, slotNumber);
        if (slot.bogo$getStack().func_190926_b()) {
            cir.setReturnValue((Object)ItemStack.field_190927_a);
            return;
        }
        ItemStack stack = slot.bogo$getStack();
        ItemStack toInsert = stack.func_77946_l();
        int amount = Math.min(stack.func_190916_E(), stack.func_77976_d());
        toInsert.func_190920_e(amount);
        GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
        SlotGroup slots = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
        SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
        if (otherSlots == null || slots == otherSlots) {
            cir.setReturnValue((Object)ItemStack.field_190927_a);
            return;
        }
        toInsert = BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert);
        stack.func_190918_g(amount - toInsert.func_190916_E());
        slot.bogo$putStack(stack.func_190926_b() ? ItemStack.field_190927_a : stack);
        cir.setReturnValue((Object)toInsert);
    }
}

