/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.config;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.BogoSorter;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.HotbarSwap;
import com.cleanroommc.bogosorter.common.config.PlayerConfig;
import com.cleanroommc.bogosorter.common.config.Serializer;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import com.cleanroommc.modularui.utils.JsonHelper;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BogoSorterConfig {
    public static final List<SortRule<ItemStack>> sortRules = new ArrayList<SortRule<ItemStack>>();
    public static final List<NbtSortRule> nbtSortRules = new ArrayList<NbtSortRule>();
    public static final Object2IntOpenHashMap<String> ORE_PREFIXES = new Object2IntOpenHashMap();
    public static final List<String> ORE_PREFIXES_LIST = new ArrayList<String>();
    public static int buttonColor = -1;

    @SideOnly(value=Side.CLIENT)
    public static void save(JsonObject json) {
        JsonObject ruleJson;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        JsonObject general = new JsonObject();
        general.addProperty("enableAutoRefill", Boolean.valueOf(playerConfig.enableAutoRefill));
        general.addProperty("refillDmgThreshold", (Number)playerConfig.autoRefillDamageThreshold);
        general.addProperty("enableHotbarSwap", Boolean.valueOf(HotbarSwap.isEnabled()));
        general.addProperty("sortSound", SortHandler.sortSound.func_187503_a().toString());
        general.addProperty("buttonColor", "#" + Integer.toHexString(buttonColor));
        general.addProperty("_comment", "By setting the chance below to 0 you agree to have no humor and that you are boring.");
        json.add("General", (JsonElement)general);
        JsonArray jsonRules = new JsonArray();
        for (SortRule<ItemStack> sortRule : sortRules) {
            if (sortRule == BogoSortAPI.EMPTY_ITEM_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", sortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(sortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("ItemSortRules", (JsonElement)jsonRules);
        jsonRules = new JsonArray();
        for (NbtSortRule nbtSortRule : nbtSortRules) {
            if (nbtSortRule == BogoSortAPI.EMPTY_NBT_SORT_RULE) continue;
            ruleJson = new JsonObject();
            ruleJson.addProperty("name", nbtSortRule.getKey());
            ruleJson.addProperty("inverted", Boolean.valueOf(nbtSortRule.isInverted()));
            jsonRules.add((JsonElement)ruleJson);
        }
        json.add("NbtSortRules", (JsonElement)jsonRules);
    }

    @SideOnly(value=Side.CLIENT)
    public static void load(JsonObject json) {
        NbtSortRule rule;
        String key;
        boolean inverted;
        JsonArray sortRules;
        PlayerConfig playerConfig = PlayerConfig.getClient();
        if (json.has("General")) {
            JsonObject general = json.getAsJsonObject("General");
            playerConfig.enableAutoRefill = JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableAutoRefill"});
            playerConfig.autoRefillDamageThreshold = (short)JsonHelper.getInt((JsonObject)general, (int)1, (String[])new String[]{"refillDmgThreshold"});
            HotbarSwap.setEnabled(JsonHelper.getBoolean((JsonObject)general, (boolean)true, (String[])new String[]{"enableHotbarSwap"}));
            String sortSound = JsonHelper.getString((JsonObject)general, (String)"ui.button.click", (String[])new String[]{"sortSound"});
            SortHandler.sortSound = (SoundEvent)SoundEvent.field_187505_a.func_82594_a((Object)new ResourceLocation(sortSound));
            if (SortHandler.sortSound == null) {
                SortHandler.sortSound = SoundEvents.field_187909_gi;
            }
            buttonColor = JsonHelper.getColor((JsonObject)general, (int)-1, (String[])new String[]{"buttonColor"});
        }
        BogoSorterConfig.sortRules.clear();
        if (json.has("ItemSortRules")) {
            sortRules = json.getAsJsonArray("ItemSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString((JsonObject)jsonElement.getAsJsonObject(), (String)"", (String[])new String[]{"key", "name"});
                    inverted = JsonHelper.getBoolean((JsonObject)jsonElement.getAsJsonObject(), (boolean)false, (String[])new String[]{"inverted", "ascending", "asc"});
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getItemSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorter.LOGGER.error("Could not find item sort rule with key '{}'.", (Object)key);
                    continue;
                }
                rule.setInverted(inverted);
                BogoSorterConfig.sortRules.add(rule);
            }
        }
        nbtSortRules.clear();
        if (json.has("NbtSortRules")) {
            sortRules = json.getAsJsonArray("NbtSortRules");
            for (JsonElement jsonElement : sortRules) {
                inverted = false;
                if (jsonElement.isJsonObject()) {
                    key = JsonHelper.getString((JsonObject)jsonElement.getAsJsonObject(), (String)"", (String[])new String[]{"key", "name"});
                    inverted = JsonHelper.getBoolean((JsonObject)jsonElement.getAsJsonObject(), (boolean)false, (String[])new String[]{"inverted", "ascending", "asc"});
                } else {
                    key = jsonElement.getAsString();
                }
                rule = BogoSortAPI.INSTANCE.getNbtSortRule(key);
                if (rule.isEmpty()) {
                    BogoSorter.LOGGER.error("Could not find nbt sort rule with key '{}'.", (Object)key);
                    continue;
                }
                rule.setInverted(inverted);
                nbtSortRules.add(rule);
            }
        }
    }

    public static void saveOrePrefixes(JsonObject json) {
        json.addProperty("_comment", "Setting this to true will recreate this entire file on next start");
        json.addProperty("reload", Boolean.valueOf(false));
        JsonArray orePrefixes = new JsonArray();
        json.add("orePrefixes", (JsonElement)orePrefixes);
        for (String orePrefix : ORE_PREFIXES_LIST) {
            orePrefixes.add(orePrefix);
        }
    }

    public static void loadOrePrefixes(JsonObject json) {
        if (json.has("reload") && json.get("reload").getAsBoolean()) {
            Serializer.saveOrePrefixes();
            return;
        }
        if (json.has("orePrefixes")) {
            ORE_PREFIXES.clear();
            ORE_PREFIXES_LIST.clear();
            int i = 0;
            for (JsonElement jsonElement : json.getAsJsonArray("orePrefixes")) {
                if (!jsonElement.isJsonPrimitive()) continue;
                String orePrefix = jsonElement.getAsString();
                ORE_PREFIXES.put((Object)orePrefix, i++);
                ORE_PREFIXES_LIST.add(orePrefix);
            }
        }
    }

    public static void loadDefaultRules() {
        String[] itemRules = new String[]{"mod", "material", "ore_prefix", "id", "meta", "nbt_has", "nbt_rules"};
        String[] nbtRules = new String[]{"enchantment", "enchantment_book", "potion", "gt_circ_config", "gt_item_damage"};
        sortRules.addAll(Arrays.stream(itemRules).map(BogoSortAPI.INSTANCE::getItemSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_ITEM_SORT_RULE).collect(Collectors.toList()));
        nbtSortRules.addAll(Arrays.stream(nbtRules).map(BogoSortAPI.INSTANCE::getNbtSortRule).filter(rule -> rule != BogoSortAPI.EMPTY_NBT_SORT_RULE).collect(Collectors.toList()));
    }
}

