/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.ISlot;
import com.cleanroommc.bogosorter.common.network.CShortcut;
import com.cleanroommc.bogosorter.common.network.NetworkHandler;
import com.cleanroommc.bogosorter.common.sort.GuiSortingContext;
import com.cleanroommc.bogosorter.common.sort.SlotGroup;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;

public class ShortcutHandler {
    @SideOnly(value=Side.CLIENT)
    public static boolean moveSingleItem(GuiContainer guiContainer, boolean emptySlot) {
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null || slot.func_75211_c().func_190926_b()) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(emptySlot ? CShortcut.Type.MOVE_SINGLE_EMPTY : CShortcut.Type.MOVE_SINGLE, slot.field_75222_d));
        return true;
    }

    public static void moveSingleItem(EntityPlayer player, Container container, ISlot slot, boolean emptySlot) {
        ShortcutHandler.moveItemStack(player, container, slot, emptySlot, 1);
    }

    public static void moveItemStack(EntityPlayer player, Container container, ISlot slot, boolean emptySlot, int amount) {
        if (slot == null || slot.bogo$getStack().func_190926_b()) {
            return;
        }
        ItemStack stack = slot.bogo$getStack();
        amount = Math.min(amount, stack.func_77976_d());
        ItemStack toInsert = stack.func_77946_l();
        toInsert.func_190920_e(amount);
        if (BogoSortAPI.isValidSortable(container)) {
            SlotGroup otherSlots;
            GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
            SlotGroup slots = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
            SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
            if (otherSlots == null || slots == otherSlots) {
                return;
            }
            toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert, true) : BogoSortAPI.insert(container, otherSlots.getSlots(), toInsert);
        } else {
            ArrayList<ISlot> otherSlots = new ArrayList<ISlot>();
            boolean isPlayer = BogoSortAPI.isPlayerSlot(slot);
            for (Slot slot1 : container.field_75151_b) {
                if (isPlayer == BogoSortAPI.isPlayerSlot(slot1)) continue;
                otherSlots.add(BogoSortAPI.INSTANCE.getSlot(slot1));
            }
            ItemStack itemStack = toInsert = emptySlot ? BogoSortAPI.insert(container, otherSlots, toInsert, true) : BogoSortAPI.insert(container, otherSlots, toInsert);
        }
        if (toInsert.func_190926_b()) {
            toInsert = stack.func_77946_l();
            toInsert.func_190918_g(amount);
            slot.bogo$putStack(toInsert);
            slot.bogo$onSlotChanged(stack, toInsert);
            toInsert = stack.func_77946_l();
            toInsert.func_190920_e(amount);
            slot.bogo$onTake(player, toInsert);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean moveAllItems(GuiContainer guiContainer, boolean sameItemOnly) {
        Container container = guiContainer.field_147002_h;
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return false;
        }
        ISlot iSlot = BogoSortAPI.INSTANCE.getSlot(slot);
        if (sameItemOnly && iSlot.bogo$getStack().func_190926_b()) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(sameItemOnly ? CShortcut.Type.MOVE_ALL_SAME : CShortcut.Type.MOVE_ALL, iSlot.bogo$getSlotNumber()));
        return true;
    }

    public static void moveAllItems(EntityPlayer player, Container container, ISlot slot, boolean sameItemOnly) {
        SlotGroup otherSlots;
        if (slot == null || !BogoSortAPI.isValidSortable(container)) {
            return;
        }
        ItemStack stack = slot.bogo$getStack().func_77946_l();
        if (sameItemOnly && stack.func_190926_b()) {
            return;
        }
        GuiSortingContext sortingContext = GuiSortingContext.getOrCreate(container);
        SlotGroup slots = sortingContext.getSlotGroup(slot.bogo$getSlotNumber());
        SlotGroup slotGroup = otherSlots = BogoSortAPI.isPlayerSlot(slot) ? sortingContext.getNonPlayerSlotGroup() : sortingContext.getPlayerSlotGroup();
        if (slots == null || otherSlots == null || slots == otherSlots) {
            return;
        }
        for (ISlot slot1 : slots.getSlots()) {
            ItemStack stackInSlot = slot1.bogo$getStack();
            ItemStack copy = stackInSlot.func_77946_l();
            if (stackInSlot.func_190926_b() || sameItemOnly && !stackInSlot.func_77969_a(stack)) continue;
            ItemStack remainder = BogoSortAPI.insert(container, otherSlots.getSlots(), copy);
            int inserted = stackInSlot.func_190916_E() - remainder.func_190916_E();
            if (inserted <= 0) continue;
            slot1.bogo$putStack(remainder.func_77946_l());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean dropItems(GuiContainer guiContainer, boolean onlySameType) {
        Slot slot = guiContainer.getSlotUnderMouse();
        if (slot == null || slot.func_75211_c().func_190926_b()) {
            return false;
        }
        if (!BogoSortAPI.isPlayerSlot(slot) && !BogoSortAPI.isValidSortable(guiContainer.field_147002_h)) {
            return false;
        }
        NetworkHandler.sendToServer(new CShortcut(onlySameType ? CShortcut.Type.DROP_ALL_SAME : CShortcut.Type.DROP_ALL, slot.field_75222_d));
        return true;
    }

    public static void dropItems(EntityPlayer player, Container container, ISlot slot, boolean onlySameType) {
        ItemStack stack = slot.bogo$getStack();
        if (onlySameType && stack.func_190926_b()) {
            return;
        }
        SlotGroup slots = GuiSortingContext.getOrCreate(container).getSlotGroup(slot.bogo$getSlotNumber());
        if (slots == null) {
            return;
        }
        for (ISlot slot1 : slots.getSlots()) {
            ItemStack stackInSlot = slot1.bogo$getStack();
            if (stackInSlot.func_190926_b() || onlySameType && !stackInSlot.func_77969_a(stack)) continue;
            slot1.bogo$putStack(ItemStack.field_190927_a);
            player.func_71019_a(stackInSlot, true);
        }
    }

    public static ItemStack insertToSlots(List<ISlot> slots, ItemStack stack, boolean emptyOnly) {
        for (ISlot slot : slots) {
            stack = ShortcutHandler.insert(slot, stack, emptyOnly);
            if (!stack.func_190926_b()) continue;
            return stack;
        }
        return stack;
    }

    public static ItemStack insert(ISlot slot, ItemStack stack, boolean emptyOnly) {
        ItemStack stackInSlot = slot.bogo$getStack();
        if (emptyOnly) {
            if (!stackInSlot.func_190926_b() || !slot.bogo$isItemValid(stack)) {
                return stack;
            }
            int amount = Math.min(stack.func_190916_E(), slot.bogo$getItemStackLimit(stack));
            if (amount <= 0) {
                return stack;
            }
            ItemStack newStack = stack.func_77946_l();
            newStack.func_190920_e(amount);
            stack.func_190918_g(amount);
            slot.bogo$putStack(newStack);
            return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        }
        if (!stackInSlot.func_190926_b() && ItemHandlerHelper.canItemStacksStack((ItemStack)stackInSlot, (ItemStack)stack)) {
            int amount = Math.min(slot.bogo$getItemStackLimit(stackInSlot), Math.min(stack.func_190916_E(), slot.bogo$getMaxStackSize(stack) - stackInSlot.func_190916_E()));
            if (amount <= 0) {
                return stack;
            }
            stack.func_190918_g(amount);
            stackInSlot.func_190917_f(amount);
            slot.bogo$putStack(stackInSlot);
            return stack.func_190926_b() ? ItemStack.field_190927_a : stack;
        }
        return stack;
    }
}

