/*
 * Decompiled with CFR 0.152.
 */
package epicsquid.blockcraftery.block;

import epicsquid.blockcraftery.block.IEditableBlock;
import epicsquid.blockcraftery.model.BakedModelEditableCube;
import epicsquid.blockcraftery.tile.TileEditableBlock;
import epicsquid.mysticallib.block.BlockTEBase;
import epicsquid.mysticallib.model.block.BakedModelBlock;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.property.ExtendedBlockState;
import net.minecraftforge.common.property.IExtendedBlockState;
import net.minecraftforge.common.property.IUnlistedProperty;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class BlockEditableCube
extends BlockTEBase
implements IEditableBlock {
    public static final PropertyBool FULLCUBE = PropertyBool.func_177716_a((String)"fullcube");
    public static final PropertyBool OPAQUECUBE = PropertyBool.func_177716_a((String)"opaquecube");
    public static final PropertyBool LIGHT = PropertyBool.func_177716_a((String)"light");
    public static final UnlistedPropertyState STATEPROP = new UnlistedPropertyState();

    public BlockEditableCube(@Nonnull Material mat, @Nonnull SoundType type, float hardness, @Nonnull String name, @Nonnull Class<? extends TileEntity> teClass) {
        super(mat, type, hardness, name, teClass);
        this.setModelCustom(true);
        this.func_149713_g(0);
        this.setOpacity(false);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FULLCUBE, (Comparable)Boolean.valueOf(true)).func_177226_a((IProperty)OPAQUECUBE, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf(false)));
    }

    @SideOnly(value=Side.CLIENT)
    public boolean canRenderInLayer(@Nonnull IBlockState state, @Nonnull BlockRenderLayer layer) {
        return true;
    }

    public boolean func_149662_c(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)OPAQUECUBE);
    }

    public boolean func_149686_d(@Nonnull IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)FULLCUBE) == false;
    }

    public int getLightValue(IBlockState state, IBlockAccess world, BlockPos pos) {
        return (Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 15 : 0;
    }

    public boolean isLadder(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EntityLivingBase entity) {
        return true;
    }

    @Nonnull
    public BlockFaceShape func_193383_a(@Nonnull IBlockAccess blockAccess, @Nonnull IBlockState blockState, @Nonnull BlockPos pos, @Nonnull EnumFacing facing) {
        return BlockFaceShape.SOLID;
    }

    public boolean func_176225_a(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        IBlockState s = world.func_180495_p(pos.func_177972_a(side));
        if (s.func_177230_c() == this) {
            TileEntity t = world.func_175625_s(pos);
            TileEntity t2 = world.func_175625_s(pos.func_177972_a(side));
            if (t instanceof TileEditableBlock && t2 instanceof TileEditableBlock && ((TileEditableBlock)t).state.func_177230_c() == ((TileEditableBlock)t2).state.func_177230_c() && ((TileEditableBlock)t).state.func_177230_c() != Blocks.field_150350_a) {
                return false;
            }
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean doesSideBlockRendering(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos, @Nonnull EnumFacing side) {
        TileEntity t = world.func_175625_s(pos);
        if (t instanceof TileEditableBlock) {
            return ((TileEditableBlock)t).state.func_177230_c().doesSideBlockRendering(((TileEditableBlock)t).state, world, pos, side);
        }
        return true;
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        IProperty[] listedProperties = new IProperty[]{FULLCUBE, OPAQUECUBE, LIGHT};
        IUnlistedProperty[] unlistedProperties = new IUnlistedProperty[]{STATEPROP};
        return new ExtendedBlockState((Block)this, listedProperties, unlistedProperties);
    }

    @Nonnull
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf(meta << 2 == 1)).func_177226_a((IProperty)OPAQUECUBE, (Comparable)Boolean.valueOf(meta << 1 == 1)).func_177226_a((IProperty)LIGHT, (Comparable)Boolean.valueOf(meta == 1));
    }

    public int func_176201_c(@Nonnull IBlockState state) {
        return ((Boolean)state.func_177229_b((IProperty)LIGHT) != false ? 1 : 0) >> 2 + ((Boolean)state.func_177229_b((IProperty)OPAQUECUBE) != false ? 1 : 0) >> 1 + ((Boolean)state.func_177229_b((IProperty)FULLCUBE) != false ? 1 : 0);
    }

    @Nonnull
    public IBlockState getExtendedState(@Nonnull IBlockState state, @Nonnull IBlockAccess world, @Nonnull BlockPos pos) {
        TileEntity t = world.func_175625_s(pos);
        IBlockState actual = this.func_176221_a(state, world, pos);
        if (t instanceof TileEditableBlock && actual instanceof IExtendedBlockState) {
            IBlockState tileState = ((TileEditableBlock)t).state;
            IBlockState placeState = tileState.func_177230_c().func_176221_a(tileState, world, pos);
            return ((IExtendedBlockState)actual).withProperty((IUnlistedProperty)STATEPROP, (Object)placeState);
        }
        return state;
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        if (this.getParentState() != null) {
            return super.getLightOpacity(this.getParentState(), world, pos);
        }
        return super.getLightOpacity(state, world, pos);
    }

    @Override
    @Nonnull
    public IUnlistedProperty<IBlockState> getStateProperty() {
        return STATEPROP;
    }

    @Nonnull
    protected Class<? extends BakedModelBlock> getModelClass() {
        return BakedModelEditableCube.class;
    }

    public static class UnlistedPropertyState
    implements IUnlistedProperty<IBlockState> {
        @Nonnull
        public String getName() {
            return "stateprop";
        }

        public boolean isValid(@Nonnull IBlockState value) {
            return true;
        }

        @Nonnull
        public Class<IBlockState> getType() {
            return IBlockState.class;
        }

        @Nonnull
        public String valueToString(@Nonnull IBlockState value) {
            return value.toString();
        }
    }
}

