/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.integration.jei.genepool;

import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.genepool.GenepoolLogic;
import forestry.core.fluids.Fluids;
import java.awt.Color;
import java.util.ArrayList;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class GenepoolRecipeWrapper
implements IRecipeWrapper {
    private static final ItemStack ENZYME = GeneticsItems.Enzyme.get(1);
    private final ItemStack input;
    private final FluidStack dnaOutput;
    private final FluidStack ethanolInput;

    public GenepoolRecipeWrapper(ItemStack input) {
        this.input = input;
        int dnaAmount = GenepoolLogic.getDNAAmount(input);
        this.dnaOutput = GeneticLiquid.RawDNA.get(dnaAmount);
        this.ethanolInput = Fluids.BIO_ETHANOL.getFluid(Math.round((float)dnaAmount * 1.2f));
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        inputs.add(ENZYME);
        inputs.add(this.input);
        ingredients.setInputs(ItemStack.class, inputs);
        ingredients.setInput(FluidStack.class, (Object)this.ethanolInput);
        ingredients.setOutput(FluidStack.class, (Object)this.dnaOutput);
    }

    @SideOnly(value=Side.CLIENT)
    public void drawInfo(Minecraft minecraft, int recipeWidth, int recipeHeight, int mouseX, int mouseY) {
        float usedEnzyme = 0.25f;
        String usedString = String.format("%.2f", Float.valueOf(usedEnzyme));
        minecraft.field_71466_p.func_78276_b(usedString, 22, 20, Color.gray.getRGB());
    }
}

