/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines.designer;

import binnie.core.util.I18N;
import binnie.design.DesignHelper;
import binnie.design.EnumDesign;
import binnie.design.api.IDesign;
import binnie.design.api.IDesignMaterial;
import binnie.design.api.IDesignSystem;
import binnie.design.api.IDesignerType;
import binnie.design.blocks.BlockDesign;
import binnie.extratrees.carpentry.DesignSystem;
import binnie.extratrees.modules.ModuleCarpentry;
import net.minecraft.item.ItemStack;

public enum DesignerType implements IDesignerType
{
    Woodworker("woodworker"),
    Panelworker("panelworker"),
    GlassWorker("glassworker");

    private final String name;

    private DesignerType(String name) {
        this.name = name;
    }

    @Override
    public IDesignSystem getSystem() {
        switch (this) {
            case GlassWorker: {
                return DesignSystem.Glass;
            }
        }
        return DesignSystem.Wood;
    }

    @Override
    public ItemStack getBlock(IDesignMaterial type1, IDesignMaterial type2, IDesign design) {
        int stackSize = 2;
        if (design == EnumDesign.Blank) {
            type2 = type1;
            stackSize = 1;
        }
        ItemStack stack = DesignHelper.getItemStack(this.getBlock(), type1, type2, design);
        stack.func_190920_e(stackSize);
        return stack;
    }

    private BlockDesign getBlock() {
        switch (this) {
            case GlassWorker: {
                return ModuleCarpentry.blockStained;
            }
            case Panelworker: {
                return ModuleCarpentry.blockPanel;
            }
        }
        return ModuleCarpentry.blockCarpentry;
    }

    @Override
    public ItemStack getDisplayStack(IDesign design) {
        return this.getBlock(this.getSystem().getDefaultMaterial(), this.getSystem().getDefaultMaterial2(), design);
    }

    @Override
    public String getMaterialTooltip() {
        switch (this) {
            case GlassWorker: {
                return I18N.localise("extratrees.machine.designer.material.glass");
            }
            case Panelworker: {
                return I18N.localise("extratrees.machine.designer.material.panel");
            }
            case Woodworker: {
                return I18N.localise("extratrees.machine.designer.material.wood");
            }
        }
        return "";
    }

    @Override
    public String getName() {
        return this.name;
    }
}

