/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.gen;

import binnie.extratrees.gen.BinnieWorldGenTree;
import forestry.api.world.ITreeGenData;

public class WorldGenFir {

    public static class BalsamFir
    extends BinnieWorldGenTree {
        public BalsamFir(ITreeGenData tree) {
            super(tree, 6, 2);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 2;
            float bottom = 1.0f;
            float width = (float)this.height / this.randBetween(2.0f, 2.5f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - 1.0f;
            while (leafSpawn > 1.0f) {
                float radius = 1.0f - (leafSpawn - 1.0f) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }
    }

    public static class SilverFir
    extends BinnieWorldGenTree {
        public SilverFir(ITreeGenData tree) {
            super(tree, 7, 3);
        }

        @Override
        protected void generateLeaves() {
            float leafSpawn = this.height + 2;
            float bottom = this.randBetween(2, 3);
            float width = (float)this.height / this.randBetween(2.5f, 3.0f);
            if (width > 7.0f) {
                width = 7.0f;
            }
            float coneHeight = leafSpawn - bottom;
            while (leafSpawn > bottom) {
                float radius = 1.0f - (leafSpawn - bottom) / coneHeight;
                float f = leafSpawn;
                leafSpawn = f - 1.0f;
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), radius *= width, 1, this.leaf, false);
            }
            float f = leafSpawn;
            leafSpawn = f - 1.0f;
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, f, 0.0f), 0.7f * width, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), 0.4f * width, 1, this.leaf, false);
        }
    }

    public static class DouglasFir
    extends BinnieWorldGenTree {
        public DouglasFir(ITreeGenData tree) {
            super(tree, 7, 3);
        }

        @Override
        protected void generateLeaves() {
            int leafSpawn = this.height + 1;
            int patchyBottom = (int)((float)this.height / 2.5f);
            int bottom = 3 + this.rand.nextInt(2);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), this.girth, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), this.girth + 2, 1, this.leaf, false);
            while (leafSpawn > patchyBottom) {
                if (this.rand.nextFloat() < 0.45f) {
                    this.generateCylinder(new BinnieWorldGenTree.Vector((this.girth - 1) * (this.rand.nextBoolean() ? -1 : 1), leafSpawn, (this.girth - 1) * (this.rand.nextBoolean() ? -1 : 1)), (float)this.girth + 0.75f, 1, this.leaf, false);
                }
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 2.9f, 1, this.leaf, false);
            }
            while (leafSpawn > bottom) {
                this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), (float)this.girth + 2.3f - (float)this.rand.nextInt(2), 1, this.leaf, false);
            }
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn--, 0.0f), this.girth + 1, 1, this.leaf, false);
            this.generateCylinder(new BinnieWorldGenTree.Vector(0.0f, leafSpawn, 0.0f), (float)this.girth - 0.2f, 1, this.leaf, false);
        }
    }
}

