/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.gui.minecraft;

import binnie.core.BinnieCore;
import binnie.core.gui.minecraft.CustomSlot;
import binnie.core.gui.minecraft.IWindowAffectsShiftClick;
import binnie.core.gui.minecraft.InventoryType;
import binnie.core.gui.minecraft.Window;
import binnie.core.gui.minecraft.WindowInventory;
import binnie.core.gui.minecraft.control.ControlSlot;
import binnie.core.gui.minecraft.control.EnumHighlighting;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.errors.ErrorState;
import binnie.core.machines.errors.IErrorStateSource;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.machines.power.ProcessInfo;
import binnie.core.machines.power.TankInfo;
import binnie.core.machines.transfer.TransferRequest;
import binnie.core.machines.transfer.TransferResult;
import binnie.core.network.packet.MessageContainerUpdate;
import com.google.common.base.Preconditions;
import com.google.common.collect.Sets;
import com.mojang.authlib.GameProfile;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.InvWrapper;

public class ContainerCraftGUI
extends Container {
    private final Set<EntityPlayer> crafters = Sets.newConcurrentHashSet();
    private final Window window;
    private final Map<String, NBTTagCompound> syncedNBT = new HashMap<String, NBTTagCompound>();
    private final Map<String, NBTTagCompound> sentNBT = new HashMap<String, NBTTagCompound>();
    private final Map<Integer, TankInfo> syncedTanks = new HashMap<Integer, TankInfo>();
    private PowerInfo syncedPower = new PowerInfo();
    private ProcessInfo syncedProcess = new ProcessInfo();
    private int errorType = 0;
    @Nullable
    private ErrorState error = null;
    private int mousedOverSlotNumber = -1;

    public ContainerCraftGUI(Window window) {
        GameProfile user;
        this.window = window;
        IMachine machine = Machine.getMachine(window.getInventory());
        if (this.getSide() == Side.SERVER && machine != null && (user = machine.getOwner()) != null) {
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74778_a("username", user.getName());
            this.sendNBTToClient("username", nbt);
        }
        this.func_75142_b();
    }

    private Side getSide() {
        return this.window.isServer() ? Side.SERVER : Side.CLIENT;
    }

    public void func_75134_a(EntityPlayer playerIn) {
        this.crafters.remove(playerIn);
        super.func_75134_a(playerIn);
        WindowInventory inventory = this.window.getWindowInventory();
        for (int i = 0; i < inventory.func_70302_i_(); ++i) {
            TransferRequest transferRequest;
            TransferResult transferResult;
            ItemStack stack;
            if (!inventory.dispenseOnClose(i) || (stack = inventory.func_70301_a(i)).func_190926_b() || !(transferResult = (transferRequest = new TransferRequest(stack, (IInventory)playerIn.field_71071_by)).transfer(playerIn, true)).isSuccess()) continue;
            for (ItemStack result : transferResult.getRemaining()) {
                playerIn.func_71019_a(result, false);
            }
        }
    }

    public ItemStack func_184996_a(int slotNum, int dragType, ClickType clickType, EntityPlayer player) {
        Slot slot = this.func_75139_a(slotNum);
        if (slot instanceof CustomSlot && ((CustomSlot)slot).handleClick()) {
            ((CustomSlot)slot).onSlotClick(this, dragType, clickType, player);
            return player.field_71071_by.func_70445_o();
        }
        return super.func_184996_a(slotNum, dragType, clickType, player);
    }

    public void sendNBTToClient(String key, NBTTagCompound nbt) {
        this.syncedNBT.put(key, nbt);
    }

    public boolean func_75145_c(EntityPlayer entityPlayer) {
        IInventory inventory;
        if (entityPlayer instanceof EntityPlayerMP) {
            this.crafters.add(entityPlayer);
            this.sentNBT.clear();
        }
        return (inventory = this.window.getInventory()) == null || inventory.func_70300_a(entityPlayer);
    }

    public final ItemStack func_82846_b(EntityPlayer player, int slotID) {
        return this.shiftClick(player, slotID);
    }

    private ItemStack shiftClick(EntityPlayer player, int slotnumber) {
        NonNullList<ItemStack> results;
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        TransferResult transferResult = request.transfer(player, true);
        if (transferResult.isSuccess() && (results = transferResult.getRemaining()).size() >= 1) {
            ItemStack itemstack = (ItemStack)results.get(results.size() - 1);
            Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
            shiftClickedSlot.func_75215_d(itemstack);
            shiftClickedSlot.func_75218_e();
        }
        return ItemStack.field_190927_a;
    }

    private TransferRequest getShiftClickRequest(EntityPlayer player, int slotnumber) {
        TransferRequest request;
        WindowInventory fromPlayer;
        ItemStack shiftClickedStack;
        Slot shiftClickedSlot = (Slot)this.field_75151_b.get(slotnumber);
        ItemStack itemstack = ItemStack.field_190927_a;
        if (shiftClickedSlot.func_75216_d() && !(shiftClickedStack = shiftClickedSlot.func_75211_c()).func_190926_b()) {
            itemstack = shiftClickedStack.func_77946_l();
        }
        InventoryPlayer playerInventory = player.field_71071_by;
        IInventory containerInventory = this.window.getInventory();
        WindowInventory windowInventory = this.window.getWindowInventory();
        WindowInventory windowInventory2 = fromPlayer = containerInventory == null ? windowInventory : containerInventory;
        if (shiftClickedSlot.field_75224_c == playerInventory) {
            request = new TransferRequest(itemstack, fromPlayer).setOrigin(shiftClickedSlot.field_75224_c);
        } else {
            int[] target = new int[36];
            for (int i = 0; i < 36; ++i) {
                target[i] = i;
            }
            request = new TransferRequest(itemstack, (IInventory)playerInventory).setOrigin(shiftClickedSlot.field_75224_c).setTargetSlots(target);
        }
        if (this.window instanceof IWindowAffectsShiftClick) {
            ((IWindowAffectsShiftClick)((Object)this.window)).alterRequest(request);
        }
        return request;
    }

    public final void tankClick(EntityPlayer player, int slotID) {
        NonNullList<ItemStack> results;
        IInventory inventory = this.window.getInventory();
        if (inventory == null) {
            return;
        }
        ItemStack heldItem = player.field_71071_by.func_70445_o();
        if (heldItem.func_190926_b()) {
            return;
        }
        TransferRequest transferRequest = new TransferRequest(heldItem = heldItem.func_77946_l(), inventory).setTargetTanks(slotID);
        TransferResult transferResult = transferRequest.transfer(player, true);
        if (transferResult.isSuccess() && (results = transferResult.getRemaining()).size() > 0) {
            ItemStack heldItemResult = (ItemStack)results.remove(results.size() - 1);
            player.field_71071_by.func_70437_b(heldItemResult);
            if (player instanceof EntityPlayerMP) {
                ((EntityPlayerMP)player).func_71113_k();
            }
            if (results.size() > 0) {
                InvWrapper itemHandler = new InvWrapper(inventory);
                for (ItemStack remaining : results) {
                    ItemHandlerHelper.insertItemStacked((IItemHandler)itemHandler, (ItemStack)remaining, (boolean)false);
                }
            }
        }
    }

    public boolean handleNBTServer(EntityPlayer player, String name, NBTTagCompound action) {
        if (name.equals("tank-click")) {
            this.tankClick(player, action.func_74771_c("id"));
        }
        if (name.equals("slot-reg")) {
            byte type = action.func_74771_c("t");
            short index = action.func_74765_d("i");
            short slotNumber = action.func_74765_d("n");
            this.createServerSlot(InventoryType.values()[type % 4], index, slotNumber);
            for (IContainerListener listener : this.field_75149_d) {
                listener.func_71110_a((Container)this, this.func_75138_a());
            }
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean handleNBTClient(EntityPlayer player, String name, NBTTagCompound action) {
        if (name.contains("tank-update")) {
            this.onTankUpdate(action);
        } else if (name.equals("power-update")) {
            this.onPowerUpdate(action);
        } else if (name.equals("process-update")) {
            this.onProcessUpdate(action);
        } else if (name.equals("error-update")) {
            this.onErrorUpdate(action);
        } else if (name.equals("mouse-over-slot")) {
            this.onMouseOverSlot(player, action);
        } else if (name.equals("shift-click-info")) {
            this.onRecieveShiftClickHighlights(action);
        }
        return false;
    }

    public void func_75142_b() {
        try {
            INetwork.SendGuiNBT machineSync;
            super.func_75142_b();
            if (this.crafters.size() == 0) {
                return;
            }
            this.sendTankChanges();
            IPoweredMachine powered = Machine.getInterface(IPoweredMachine.class, this.window.getInventory());
            IErrorStateSource error = Machine.getInterface(IErrorStateSource.class, this.window.getInventory());
            IProcess process = Machine.getInterface(IProcess.class, this.window.getInventory());
            if (powered != null && this.window.isServer()) {
                this.syncedNBT.put("power-update", this.createPowerNBT(powered.getPowerInfo()));
            }
            if (process != null && this.window.isServer()) {
                this.syncedNBT.put("process-update", this.createProcessNBT(process.getInfo()));
            }
            if (error != null && this.window.isServer()) {
                this.syncedNBT.put("error-update", this.createErrorNBT(error));
            }
            if ((machineSync = Machine.getInterface(INetwork.SendGuiNBT.class, this.window.getInventory())) != null) {
                machineSync.sendGuiNBTToClient(this.syncedNBT);
            }
            this.sendChangesToPlayers();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void sendTankChanges() {
        ITankMachine tanks = Machine.getInterface(ITankMachine.class, this.window.getInventory());
        if (tanks != null && this.window.isServer()) {
            for (int i = 0; i < tanks.getTankInfos().length; ++i) {
                TankInfo tank = tanks.getTankInfos()[i];
                if (this.getTankInfo(i).equals(tank)) continue;
                this.syncedNBT.put("tank-update-" + i, this.createTankNBT(i, tank));
                this.syncedTanks.put(i, tank);
            }
        }
    }

    private void sendChangesToPlayers() {
        HashMap<String, NBTTagCompound> sentThisTime = new HashMap<String, NBTTagCompound>();
        for (Map.Entry<String, NBTTagCompound> nbt : this.syncedNBT.entrySet()) {
            nbt.getValue().func_74778_a("type", nbt.getKey());
            boolean shouldSend = true;
            NBTTagCompound lastSent = this.sentNBT.get(nbt.getKey());
            if (lastSent != null) {
                boolean bl = shouldSend = !lastSent.equals((Object)nbt.getValue());
            }
            if (!shouldSend) continue;
            this.crafters.stream().filter(Objects::nonNull).forEach(entityPlayer -> BinnieCore.getBinnieProxy().sendToPlayer(new MessageContainerUpdate((NBTTagCompound)nbt.getValue()), (EntityPlayer)entityPlayer));
            sentThisTime.put(nbt.getKey(), nbt.getValue());
        }
        this.sentNBT.putAll(sentThisTime);
        this.syncedNBT.clear();
    }

    private NBTTagCompound createErrorNBT(IErrorStateSource error) {
        NBTTagCompound nbt = new NBTTagCompound();
        ErrorState state = null;
        if (error.canWork() != null) {
            nbt.func_74774_a("type", (byte)0);
            state = error.canWork();
        } else if (error.canProgress() != null) {
            nbt.func_74774_a("type", (byte)1);
            state = error.canProgress();
        }
        if (state != null) {
            state.writeToNBT(nbt);
        }
        return nbt;
    }

    public NBTTagCompound createPowerNBT(PowerInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createProcessNBT(ProcessInfo powerInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        powerInfo.writeToNBT(nbt);
        return nbt;
    }

    public NBTTagCompound createTankNBT(int tank, TankInfo tankInfo) {
        NBTTagCompound nbt = new NBTTagCompound();
        tankInfo.writeToNBT(nbt);
        nbt.func_74774_a("tank", (byte)tank);
        return nbt;
    }

    public void onTankUpdate(NBTTagCompound nbt) {
        byte tankID = nbt.func_74771_c("tank");
        TankInfo tank = new TankInfo();
        tank.readFromNBT(nbt);
        this.syncedTanks.put(Integer.valueOf(tankID), tank);
    }

    public void onProcessUpdate(NBTTagCompound nbt) {
        this.syncedProcess = new ProcessInfo();
        this.syncedProcess.readFromNBT(nbt);
    }

    public void onPowerUpdate(NBTTagCompound nbt) {
        this.syncedPower = new PowerInfo();
        this.syncedPower.readFromNBT(nbt);
    }

    public PowerInfo getPowerInfo() {
        return this.syncedPower;
    }

    public ProcessInfo getProcessInfo() {
        return this.syncedProcess;
    }

    public TankInfo getTankInfo(int tank) {
        return this.syncedTanks.containsKey(tank) ? this.syncedTanks.get(tank) : new TankInfo();
    }

    public void onErrorUpdate(NBTTagCompound nbt) {
        this.errorType = nbt.func_74771_c("type");
        this.error = nbt.func_74764_b("name") ? new ErrorState(nbt) : null;
    }

    @Nullable
    public ErrorState getErrorState() {
        return this.error;
    }

    public int getErrorType() {
        return this.errorType;
    }

    public CustomSlot[] getCustomSlots() {
        ArrayList<CustomSlot> slots = new ArrayList<CustomSlot>();
        for (Object object : this.field_75151_b) {
            if (!(object instanceof CustomSlot)) continue;
            slots.add((CustomSlot)((Object)object));
        }
        return slots.toArray(new CustomSlot[0]);
    }

    @SideOnly(value=Side.CLIENT)
    public void setMouseOverSlot(Slot slot) {
        if (slot.field_75222_d != this.mousedOverSlotNumber) {
            this.mousedOverSlotNumber = slot.field_75222_d;
            ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74777_a("slot", (short)slot.field_75222_d);
            this.window.sendClientAction("mouse-over-slot", nbt);
        }
    }

    private void onMouseOverSlot(EntityPlayer player, NBTTagCompound data) {
        short slotnumber = data.func_74765_d("slot");
        TransferRequest request = this.getShiftClickRequest(player, slotnumber);
        request.transfer(player, false);
        NBTTagCompound nbt = new NBTTagCompound();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (TransferRequest.TransferSlot tslot : request.getInsertedSlots()) {
            CustomSlot slot = this.getSlot(tslot.getInventory(), tslot.getId());
            if (slot == null) continue;
            slots.add(slot.field_75222_d);
        }
        int[] array = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            array[i] = (Integer)slots.get(i);
        }
        nbt.func_74783_a("slots", array);
        nbt.func_74777_a("origin", slotnumber);
        this.syncedNBT.put("shift-click-info", nbt);
    }

    @SideOnly(value=Side.CLIENT)
    private void onRecieveShiftClickHighlights(NBTTagCompound data) {
        ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).clear();
        for (int slotnumber : data.func_74759_k("slots")) {
            ControlSlot.highlighting.get((Object)EnumHighlighting.SHIFT_CLICK).add(slotnumber);
        }
    }

    @Nullable
    private CustomSlot getSlot(@Nullable IInventory inventory, int id) {
        if (inventory != null) {
            for (Object o : this.field_75151_b) {
                CustomSlot slot = (CustomSlot)((Object)o);
                if (slot.field_75224_c != inventory || slot.getSlotIndex() != id) continue;
                return slot;
            }
        }
        return null;
    }

    public void receiveNBTServer(EntityPlayer player, NBTTagCompound action) {
        String name = action.func_74779_i("type");
        if (this.handleNBTServer(player, name, action)) {
            return;
        }
        this.window.receiveGuiNBTOnServer(player, name, action);
        INetwork.ReceiveGuiNBT machine = Machine.getInterface(INetwork.ReceiveGuiNBT.class, this.window.getInventory());
        if (machine != null) {
            machine.receiveGuiNBTOnServer(player, name, action);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void receiveNBTClient(EntityPlayer player, NBTTagCompound action) {
        String name = action.func_74779_i("type");
        if (this.handleNBTClient(player, name, action)) {
            return;
        }
        this.window.receiveGuiNBTOnClient(player, name, action);
        INetwork.ReceiveGuiNBT machine = Machine.getInterface(INetwork.ReceiveGuiNBT.class, this.window.getInventory());
        if (machine != null) {
            machine.receiveGuiNBTOnClient(player, name, action);
        }
    }

    protected IInventory getInventory(InventoryType type) {
        switch (type) {
            case MACHINE: {
                IInventory inventory = this.window.getInventory();
                Preconditions.checkState((inventory != null ? 1 : 0) != 0, (String)"Window has no machine inventory: %s", (Object)this.window);
                return inventory;
            }
            case PLAYER: {
                return this.window.getPlayer().field_71071_by;
            }
            case WINDOW: {
                return this.window.getWindowInventory();
            }
        }
        throw new IllegalArgumentException("Unknown type: " + (Object)((Object)type));
    }

    public Slot createClientSlot(InventoryType type, int index) {
        IInventory inventory = this.getInventory(type);
        CustomSlot slot = this.getSlot(inventory, index);
        if (slot == null) {
            slot = new CustomSlot(inventory, index);
            this.func_75146_a(slot);
        }
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("t", (byte)type.ordinal());
        nbt.func_74777_a("i", (short)index);
        nbt.func_74777_a("n", (short)slot.field_75222_d);
        this.window.sendClientAction("slot-reg", nbt);
        return slot;
    }

    @Nullable
    private Slot createServerSlot(InventoryType type, int index, int slotNumber) {
        IInventory inventory = this.getInventory(type);
        if (this.field_75151_b.size() > slotNumber && this.field_75151_b.get(slotNumber) != null) {
            return null;
        }
        CustomSlot slot = new CustomSlot(inventory, index);
        slot.field_75222_d = slotNumber;
        if (this.field_75151_b.size() > slotNumber) {
            this.field_75151_b.set(slotNumber, slot);
            this.field_75153_a.set(slotNumber, (Object)ItemStack.field_190927_a);
        } else {
            this.field_75151_b.add(slot);
            this.field_75153_a.add((Object)ItemStack.field_190927_a);
        }
        return slot;
    }
}

