/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.ritual;

import com.bewitchment.Util;
import com.bewitchment.api.registry.Ritual;
import com.bewitchment.common.block.tile.entity.TileEntityGlyph;
import com.bewitchment.common.item.ItemTaglock;
import com.bewitchment.common.item.ItemWaystone;
import com.bewitchment.registry.ModObjects;
import java.util.Collections;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemStackHandler;

public class RitualTeleport
extends Ritual {
    public RitualTeleport() {
        super(new ResourceLocation("bewitchment", "teleport"), Collections.singletonList(Util.get(ModObjects.waystone, ModObjects.taglock)), null, null, false, 5, 450, 20, 3, -1, -1);
    }

    @Override
    public String getPreconditionMessage() {
        return "ritual.precondition.invalid_location";
    }

    @Override
    public boolean isValid(World world, BlockPos pos, EntityPlayer caster, ItemStackHandler inventory) {
        if (world.func_175625_s(pos) instanceof TileEntityGlyph) {
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() instanceof ItemWaystone) {
                    return stack.func_77942_o() && stack.func_77978_p().func_74764_b("location") && stack.func_77978_p().func_74764_b("dimension");
                }
                if (!(stack.func_77973_b() instanceof ItemTaglock) || !stack.func_77942_o()) continue;
                for (Entity entity : world.field_72996_f) {
                    if (!entity.getPersistentID().equals(UUID.fromString(stack.func_77978_p().func_74779_i("boundId")))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public void onFinished(World world, BlockPos altarPos, BlockPos effectivePos, EntityPlayer caster, ItemStackHandler inventory) {
        world.func_184133_a(null, effectivePos, SoundEvents.field_187604_bf, SoundCategory.BLOCKS, 0.7f, 0.7f);
        BlockPos pos0 = null;
        int dimension = 0;
        if (world.func_175625_s(effectivePos) instanceof TileEntityGlyph) {
            block0: for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_77973_b() instanceof ItemWaystone) {
                    pos0 = BlockPos.func_177969_a((long)stack.func_77978_p().func_74763_f("location"));
                    dimension = stack.func_77978_p().func_74762_e("dimension");
                    stack.func_77972_a(1, (EntityLivingBase)caster);
                    break;
                }
                if (!(stack.func_77973_b() instanceof ItemTaglock)) continue;
                for (Entity entity : world.field_72996_f) {
                    if (!entity.getPersistentID().equals(UUID.fromString(stack.func_77978_p().func_74779_i("boundId")))) continue;
                    pos0 = entity.func_180425_c();
                    dimension = entity.field_71093_bK;
                    stack.func_190918_g(1);
                    continue block0;
                }
            }
        }
        if (pos0 == null || dimension != world.field_73011_w.getDimension()) {
            return;
        }
        for (Entity entity : world.func_72872_a(Entity.class, new AxisAlignedBB(effectivePos).func_186662_g(3.0))) {
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
            if (entity instanceof EntityPlayer) {
                Util.teleportPlayer((EntityPlayer)entity, (double)pos0.func_177958_n() + 0.5, pos0.func_177956_o(), (double)pos0.func_177952_p() + 0.5);
            } else {
                entity.func_70634_a((double)pos0.func_177958_n() + 0.5, (double)pos0.func_177956_o(), (double)pos0.func_177952_p() + 0.5);
            }
            world.func_184133_a(null, entity.func_180425_c(), SoundEvents.field_187534_aX, SoundCategory.PLAYERS, 1.0f, 1.0f);
        }
    }
}

