/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.common.network;

import com.bewitchment.Bewitchment;
import com.bewitchment.common.world.BiomeChangingUtils;
import io.netty.buffer.ByteBuf;
import java.util.HashSet;
import net.minecraft.client.Minecraft;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketChangeBiome
implements IMessage {
    BlockPos[] positions;
    Biome biome;

    public PacketChangeBiome(World world, BlockPos pos) {
        this(world.getBiomeForCoordsBody(pos), pos);
    }

    public PacketChangeBiome(Biome biome, BlockPos ... positions) {
        this.positions = positions;
        this.biome = biome;
    }

    public PacketChangeBiome() {
    }

    public void fromBytes(ByteBuf buf) {
        this.biome = Biome.func_150568_d((int)buf.readByte());
        int length = buf.readShort();
        this.positions = new BlockPos[length];
        for (int i = 0; i < length; ++i) {
            this.positions[i] = BlockPos.func_177969_a((long)buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte(Biome.func_185362_a((Biome)this.biome));
        buf.writeShort(this.positions.length);
        for (BlockPos position : this.positions) {
            buf.writeLong(position.func_177986_g());
        }
    }

    public static class Handler
    implements IMessageHandler<PacketChangeBiome, IMessage> {
        public IMessage onMessage(PacketChangeBiome message, MessageContext ctx) {
            Minecraft.func_71410_x().func_152344_a(() -> {
                World world = Bewitchment.proxy.getPlayer((MessageContext)ctx).field_70170_p;
                BiomeChangingUtils.setMultiBiome(world, message.biome, message.positions);
                HashSet<ChunkPos> finishedPos = new HashSet<ChunkPos>();
                for (BlockPos pos : message.positions) {
                    if (!finishedPos.add(new ChunkPos(pos))) continue;
                    int chunkX = pos.func_177958_n() >> 4;
                    int chunkZ = pos.func_177952_p() >> 4;
                    world.func_147458_c(chunkX << 4, 0, chunkZ << 4, (chunkX << 4) + 15, 256, (chunkZ << 4) + 15);
                }
            });
            return null;
        }
    }
}

