/*
 * Decompiled with CFR 0.152.
 */
package com.bewitchment.client.integration.jei.category;

import com.bewitchment.api.registry.Incense;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.IDrawable;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextComponentTranslation;

public class IncenseCategory
implements IRecipeCategory<Wrapper> {
    public static final String UID = "jei.incense";
    private final IDrawable bg;

    public IncenseCategory(IGuiHelper helper) {
        this.bg = helper.drawableBuilder(new ResourceLocation("bewitchment", "textures/gui/jei_brazier.png"), 0, 0, 72, 57).setTextureSize(72, 57).build();
    }

    public String getUid() {
        return UID;
    }

    public String getTitle() {
        return I18n.func_135052_a((String)UID, (Object[])new Object[0]);
    }

    public String getModName() {
        return "Bewitchment";
    }

    public IDrawable getBackground() {
        return this.bg;
    }

    public void setRecipe(IRecipeLayout recipeLayout, Wrapper recipeWrapper, IIngredients ingredients) {
        for (int i = 0; i < recipeWrapper.input.size(); ++i) {
            recipeLayout.getItemStacks().init(i, true, i % 4 * 18, i / 4 * 18);
            recipeLayout.getItemStacks().set(i, Arrays.asList(((Ingredient)recipeWrapper.input.get(i)).func_193365_a()));
        }
    }

    public static class Wrapper
    implements IRecipeWrapper {
        private final List<Ingredient> input;
        private final String name;

        public Wrapper(Incense incense) {
            this.input = incense.input;
            this.name = new TextComponentTranslation("incense." + incense.getRegistryName().toString().replace(":", "."), new Object[0]).func_150254_d();
        }

        public void getIngredients(IIngredients ingredients) {
            ArrayList<List<ItemStack>> lists = new ArrayList<List<ItemStack>>();
            for (Ingredient ing : this.input) {
                lists.add(Arrays.asList(ing.func_193365_a()));
            }
            ingredients.setInputLists(VanillaTypes.ITEM, lists);
        }

        public void drawInfo(Minecraft minecraft, int width, int height, int mouseX, int mouseY) {
            FontRenderer font = minecraft.field_71466_p;
            font.func_78276_b(this.name, (width - font.func_78256_a(this.name)) / 2, 47, 0);
        }
    }
}

