/*
 * Decompiled with CFR 0.152.
 */
package appeng.me;

import appeng.api.exceptions.ExistingConnectionException;
import appeng.api.exceptions.FailedConnectionException;
import appeng.api.exceptions.NullNodeConnectionException;
import appeng.api.exceptions.SecurityConnectionException;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGridConnection;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkChannelsChanged;
import appeng.api.networking.pathing.IPathingGrid;
import appeng.api.util.AEPartLocation;
import appeng.api.util.DimensionalCoord;
import appeng.api.util.IReadOnlyCollection;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.features.AEFeature;
import appeng.me.GridException;
import appeng.me.GridNode;
import appeng.me.GridPropagator;
import appeng.me.pathfinding.IPathItem;
import appeng.util.Platform;
import appeng.util.ReadOnlyCollection;
import java.util.Arrays;
import java.util.EnumSet;

public class GridConnection
implements IGridConnection,
IPathItem {
    private static final String EXISTING_CONNECTION_MESSAGE = "Connection between node [machine=%s, %s] and [machine=%s, %s] on [%s] already exists.";
    private static final MENetworkChannelsChanged EVENT = new MENetworkChannelsChanged();
    private int usedChannels = 0;
    private int lastUsedChannels = 0;
    private Object visitorIterationNumber = null;
    private GridNode sideA;
    private AEPartLocation fromAtoB;
    private GridNode sideB;

    private GridConnection(GridNode aNode, GridNode bNode, AEPartLocation fromAtoB) {
        this.sideA = aNode;
        this.fromAtoB = fromAtoB;
        this.sideB = bNode;
    }

    private boolean isNetworkABetter(GridNode a, GridNode b) {
        return a.getMyGrid().getPriority() > b.getMyGrid().getPriority() || a.getMyGrid().size() > b.getMyGrid().size();
    }

    @Override
    public IGridNode getOtherSide(IGridNode gridNode) {
        if (gridNode == this.sideA) {
            return this.sideB;
        }
        if (gridNode == this.sideB) {
            return this.sideA;
        }
        throw new GridException("Invalid Side of Connection");
    }

    @Override
    public AEPartLocation getDirection(IGridNode side) {
        if (this.fromAtoB == AEPartLocation.INTERNAL) {
            return this.fromAtoB;
        }
        if (this.sideA == side) {
            return this.fromAtoB;
        }
        return this.fromAtoB.getOpposite();
    }

    @Override
    public void destroy() {
        IPathingGrid p = (IPathingGrid)this.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        this.sideA.removeConnection(this);
        this.sideB.removeConnection(this);
        this.sideA.validateGrid();
        this.sideB.validateGrid();
    }

    @Override
    public IGridNode a() {
        return this.sideA;
    }

    @Override
    public IGridNode b() {
        return this.sideB;
    }

    @Override
    public boolean hasDirection() {
        return this.fromAtoB != AEPartLocation.INTERNAL;
    }

    @Override
    public int getUsedChannels() {
        return this.usedChannels;
    }

    @Override
    public IPathItem getControllerRoute() {
        if (this.sideA.getFlags().contains((Object)GridFlags.CANNOT_CARRY)) {
            return null;
        }
        return this.sideA;
    }

    @Override
    public void setControllerRoute(IPathItem fast, boolean zeroOut) {
        if (zeroOut) {
            this.lastUsedChannels = 0;
        }
        if (this.sideB == fast) {
            GridNode tmp = this.sideA;
            this.sideA = this.sideB;
            this.sideB = tmp;
            this.fromAtoB = this.fromAtoB.getOpposite();
        }
    }

    @Override
    public boolean canSupportMoreChannels() {
        return this.getLastUsedChannels() < AEConfig.instance().getDenseChannelCapacity();
    }

    @Override
    public IReadOnlyCollection<IPathItem> getPossibleOptions() {
        return new ReadOnlyCollection<IPathItem>(Arrays.asList((IPathItem)((Object)this.a()), (IPathItem)((Object)this.b())));
    }

    @Override
    public void incrementChannelCount(int usedChannels) {
        this.lastUsedChannels += usedChannels;
    }

    @Override
    public EnumSet<GridFlags> getFlags() {
        return EnumSet.noneOf(GridFlags.class);
    }

    @Override
    public void finalizeChannels() {
        if (this.getUsedChannels() != this.getLastUsedChannels()) {
            this.usedChannels = this.lastUsedChannels;
            if (this.sideA.getInternalGrid() != null) {
                this.sideA.getInternalGrid().postEventTo(this.sideA, EVENT);
            }
            if (this.sideB.getInternalGrid() != null) {
                this.sideB.getInternalGrid().postEventTo(this.sideB, EVENT);
            }
        }
    }

    private int getLastUsedChannels() {
        return this.lastUsedChannels;
    }

    Object getVisitorIterationNumber() {
        return this.visitorIterationNumber;
    }

    void setVisitorIterationNumber(Object visitorIterationNumber) {
        this.visitorIterationNumber = visitorIterationNumber;
    }

    public static GridConnection create(IGridNode aNode, IGridNode bNode, AEPartLocation fromAtoB) throws FailedConnectionException {
        GridPropagator gp;
        if (aNode == null || bNode == null) {
            throw new NullNodeConnectionException();
        }
        GridNode a = (GridNode)aNode;
        GridNode b = (GridNode)bNode;
        if (a.hasConnection(b) || b.hasConnection(a)) {
            String aMachineClass = a.getGridBlock().getMachine().getClass().getSimpleName();
            String bMachineClass = b.getGridBlock().getMachine().getClass().getSimpleName();
            String aCoordinates = a.getGridBlock().getLocation().toString();
            String bCoordinates = b.getGridBlock().getLocation().toString();
            throw new ExistingConnectionException(String.format(EXISTING_CONNECTION_MESSAGE, new Object[]{aMachineClass, aCoordinates, bMachineClass, bCoordinates, fromAtoB}));
        }
        if (!Platform.securityCheck(a, b)) {
            if (AEConfig.instance().isFeatureEnabled(AEFeature.LOG_SECURITY_AUDITS)) {
                DimensionalCoord aCoordinates = a.getGridBlock().getLocation();
                DimensionalCoord bCoordinates = b.getGridBlock().getLocation();
                AELog.info("Security audit 1 failed at [%s] belonging to player [id=%d]", aCoordinates.toString(), a.getPlayerID());
                AELog.info("Security audit 2 failed at [%s] belonging to player [id=%d]", bCoordinates.toString(), b.getPlayerID());
            }
            throw new SecurityConnectionException();
        }
        GridConnection connection = new GridConnection(a, b, fromAtoB);
        if (a.getMyGrid() == null) {
            b.setGrid(a.getInternalGrid());
        } else if (a.getMyGrid() == null) {
            gp = new GridPropagator(b.getInternalGrid());
            aNode.beginVisit(gp);
        } else if (b.getMyGrid() == null) {
            gp = new GridPropagator(a.getInternalGrid());
            bNode.beginVisit(gp);
        } else if (connection.isNetworkABetter(a, b)) {
            gp = new GridPropagator(a.getInternalGrid());
            b.beginVisit(gp);
        } else {
            gp = new GridPropagator(b.getInternalGrid());
            a.beginVisit(gp);
        }
        IPathingGrid p = (IPathingGrid)connection.sideA.getInternalGrid().getCache(IPathingGrid.class);
        p.repath();
        connection.sideA.addConnection(connection);
        connection.sideB.addConnection(connection);
        return connection;
    }
}

