/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei;

import appeng.api.AEApi;
import appeng.api.config.CondenserOutput;
import appeng.api.definitions.IDefinitions;
import appeng.api.definitions.IItemDefinition;
import appeng.api.definitions.IMaterials;
import appeng.api.features.IGrinderRecipe;
import appeng.api.features.IInscriberRecipe;
import appeng.client.gui.AEGuiHandler;
import appeng.container.implementations.ContainerCraftingTerm;
import appeng.container.implementations.ContainerExpandedProcessingPatternTerm;
import appeng.container.implementations.ContainerPatternTerm;
import appeng.container.implementations.ContainerWirelessCraftingTerminal;
import appeng.container.implementations.ContainerWirelessPatternTerminal;
import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.core.localization.GuiText;
import appeng.integration.Integrations;
import appeng.integration.modules.jei.CondenserCategory;
import appeng.integration.modules.jei.CondenserOutputHandler;
import appeng.integration.modules.jei.FacadeRegistryPlugin;
import appeng.integration.modules.jei.GrinderRecipeCategory;
import appeng.integration.modules.jei.GrinderRecipeHandler;
import appeng.integration.modules.jei.InscriberRecipeCategory;
import appeng.integration.modules.jei.InscriberRecipeHandler;
import appeng.integration.modules.jei.JEIModule;
import appeng.integration.modules.jei.JeiRuntimeAdapter;
import appeng.integration.modules.jei.RecipeTransferHandler;
import appeng.items.parts.ItemFacade;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Optional;
import mezz.jei.api.IJeiRuntime;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.IModRegistry;
import mezz.jei.api.ISubtypeRegistry;
import mezz.jei.api.gui.IAdvancedGuiHandler;
import mezz.jei.api.gui.IGhostIngredientHandler;
import mezz.jei.api.recipe.IRecipeCategory;
import mezz.jei.api.recipe.IRecipeCategoryRegistration;
import mezz.jei.api.recipe.IRecipeRegistryPlugin;
import mezz.jei.api.recipe.IRecipeWrapperFactory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

@mezz.jei.api.JEIPlugin
public class JEIPlugin
implements IModPlugin {
    public static IJeiRuntime runtime;
    public static AEGuiHandler aeGuiHandler;

    public void registerItemSubtypes(ISubtypeRegistry subtypeRegistry) {
        Optional<Item> maybeFacade = AEApi.instance().definitions().items().facade().maybeItem();
        maybeFacade.ifPresent(xva$0 -> subtypeRegistry.useNbtForSubtypes(new Item[]{xva$0}));
    }

    public void registerCategories(IRecipeCategoryRegistration registry) {
        registry.addRecipeCategories(new IRecipeCategory[]{new GrinderRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new CondenserCategory(registry.getJeiHelpers().getGuiHelper())});
        registry.addRecipeCategories(new IRecipeCategory[]{new InscriberRecipeCategory(registry.getJeiHelpers().getGuiHelper())});
    }

    public void register(IModRegistry registry) {
        IDefinitions definitions = AEApi.instance().definitions();
        this.registerFacadeRecipe(definitions, registry);
        this.registerInscriberRecipes(definitions, registry);
        this.registerCondenserRecipes(definitions, registry);
        this.registerGrinderRecipes(definitions, registry);
        this.registerDescriptions(definitions, registry);
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerCraftingTerm>(ContainerCraftingTerm.class), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerWirelessCraftingTerminal>(ContainerWirelessCraftingTerminal.class), "minecraft.crafting");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerPatternTerm>(ContainerPatternTerm.class), "universal recipe transfer handler");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerExpandedProcessingPatternTerm>(ContainerExpandedProcessingPatternTerm.class), "universal recipe transfer handler");
        registry.getRecipeTransferRegistry().addRecipeTransferHandler(new RecipeTransferHandler<ContainerWirelessPatternTerminal>(ContainerWirelessPatternTerminal.class), "universal recipe transfer handler");
        aeGuiHandler = new AEGuiHandler();
        registry.addAdvancedGuiHandlers(new IAdvancedGuiHandler[]{aeGuiHandler});
        registry.addGhostIngredientHandler(aeGuiHandler.getGuiContainerClass(), (IGhostIngredientHandler)aeGuiHandler);
    }

    private void registerDescriptions(IDefinitions definitions, IModRegistry registry) {
        IMaterials materials = definitions.materials();
        String message = AEConfig.instance().isFeatureEnabled(AEFeature.CERTUS_QUARTZ_WORLD_GEN) ? GuiText.ChargedQuartz.getLocal() + "\n\n" + GuiText.ChargedQuartzFind.getLocal() : GuiText.ChargedQuartzFind.getLocal();
        this.addDescription(registry, materials.certusQuartzCrystalCharged(), message);
        if (AEConfig.instance().isFeatureEnabled(AEFeature.METEORITE_WORLD_GEN)) {
            this.addDescription(registry, materials.logicProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
            this.addDescription(registry, materials.calcProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
            this.addDescription(registry, materials.engProcessorPress(), GuiText.inWorldCraftingPresses.getLocal());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_FLUIX)) {
            this.addDescription(registry, materials.fluixCrystal(), GuiText.inWorldFluix.getLocal());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_SINGULARITY)) {
            this.addDescription(registry, materials.qESingularity(), GuiText.inWorldSingularity.getLocal());
        }
        if (AEConfig.instance().isFeatureEnabled(AEFeature.IN_WORLD_PURIFICATION)) {
            this.addDescription(registry, materials.purifiedCertusQuartzCrystal(), GuiText.inWorldPurificationCertus.getLocal());
            this.addDescription(registry, materials.purifiedNetherQuartzCrystal(), GuiText.inWorldPurificationNether.getLocal());
            this.addDescription(registry, materials.purifiedFluixCrystal(), GuiText.inWorldPurificationFluix.getLocal());
        }
    }

    private void addDescription(IModRegistry registry, IItemDefinition itemDefinition, String message) {
        itemDefinition.maybeStack(1).ifPresent(itemStack -> registry.addIngredientInfo(itemStack, ItemStack.class, new String[]{message}));
    }

    private void registerGrinderRecipes(IDefinitions definitions, IModRegistry registry) {
        ItemStack grindstone = definitions.blocks().grindstone().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (grindstone.func_190926_b()) {
            return;
        }
        registry.handleRecipes(IGrinderRecipe.class, (IRecipeWrapperFactory)new GrinderRecipeHandler(), "appliedenergistics2.grinder");
        registry.addRecipes((Collection)Lists.newArrayList(AEApi.instance().registries().grinder().getRecipes()), "appliedenergistics2.grinder");
        registry.addRecipeCatalyst((Object)grindstone, new String[]{"appliedenergistics2.grinder"});
    }

    private void registerCondenserRecipes(IDefinitions definitions, IModRegistry registry) {
        ItemStack singularity;
        ItemStack condenser = definitions.blocks().condenser().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (condenser.func_190926_b()) {
            return;
        }
        ItemStack matterBall = definitions.materials().matterBall().maybeStack(1).orElse(ItemStack.field_190927_a);
        if (!matterBall.func_190926_b()) {
            registry.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.MATTER_BALLS)), "appliedenergistics2.condenser");
        }
        if (!(singularity = definitions.materials().singularity().maybeStack(1).orElse(ItemStack.field_190927_a)).func_190926_b()) {
            registry.addRecipes((Collection)ImmutableList.of((Object)((Object)CondenserOutput.SINGULARITY)), "appliedenergistics2.condenser");
        }
        if (!matterBall.func_190926_b() || !singularity.func_190926_b()) {
            registry.addRecipeCatalyst((Object)condenser, new String[]{"appliedenergistics2.condenser"});
            registry.handleRecipes(CondenserOutput.class, (IRecipeWrapperFactory)new CondenserOutputHandler(registry.getJeiHelpers().getGuiHelper(), matterBall, singularity), "appliedenergistics2.condenser");
        }
    }

    private void registerInscriberRecipes(IDefinitions definitions, IModRegistry registry) {
        registry.handleRecipes(IInscriberRecipe.class, (IRecipeWrapperFactory)new InscriberRecipeHandler(), "appliedenergistics2.inscriber");
        definitions.blocks().inscriber().maybeStack(1).ifPresent(inscriber -> registry.addRecipeCatalyst(inscriber, new String[]{"appliedenergistics2.inscriber"}));
        ArrayList<IInscriberRecipe> inscriberRecipes = new ArrayList<IInscriberRecipe>(AEApi.instance().registries().inscriber().getRecipes());
        registry.addRecipes(inscriberRecipes, "appliedenergistics2.inscriber");
    }

    private void registerFacadeRecipe(IDefinitions definitions, IModRegistry registry) {
        Optional<Item> itemFacade = definitions.items().facade().maybeItem();
        Optional<ItemStack> cableAnchor = definitions.parts().cableAnchor().maybeStack(1);
        if (itemFacade.isPresent() && cableAnchor.isPresent() && AEConfig.instance().isFeatureEnabled(AEFeature.ENABLE_FACADE_CRAFTING)) {
            registry.addRecipeRegistryPlugin((IRecipeRegistryPlugin)new FacadeRegistryPlugin((ItemFacade)itemFacade.get(), cableAnchor.get()));
        }
    }

    public void onRuntimeAvailable(IJeiRuntime jeiRuntime) {
        JEIModule jeiModule = (JEIModule)Integrations.jei();
        jeiModule.setJei(new JeiRuntimeAdapter(jeiRuntime));
        runtime = jeiRuntime;
    }
}

