/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.block.networking.BlockCableBus;
import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.items.tools.ToolNetworkTool;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class PacketClick
extends AppEngPacket {
    private final int x;
    private final int y;
    private final int z;
    private EnumFacing side;
    private final float hitX;
    private final float hitY;
    private final float hitZ;
    private EnumHand hand;
    private final boolean leftClick;

    public PacketClick(ByteBuf stream) {
        this.x = stream.readInt();
        this.y = stream.readInt();
        this.z = stream.readInt();
        byte side = stream.readByte();
        this.side = side != -1 ? EnumFacing.values()[side] : null;
        this.hitX = stream.readFloat();
        this.hitY = stream.readFloat();
        this.hitZ = stream.readFloat();
        this.hand = EnumHand.values()[stream.readByte()];
        this.leftClick = stream.readBoolean();
    }

    public PacketClick(BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand) {
        this(pos, side, hitX, hitY, hitZ, hand, false);
    }

    public PacketClick(BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, EnumHand hand, boolean leftClick) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.x = pos.func_177958_n();
        data.writeInt(this.x);
        this.y = pos.func_177956_o();
        data.writeInt(this.y);
        this.z = pos.func_177952_p();
        data.writeInt(this.z);
        if (side == null) {
            data.writeByte(-1);
        } else {
            data.writeByte(side.ordinal());
        }
        this.hitX = hitX;
        data.writeFloat(this.hitX);
        this.hitY = hitY;
        data.writeFloat(this.hitY);
        this.hitZ = hitZ;
        data.writeFloat(this.hitZ);
        data.writeByte(hand.ordinal());
        this.leftClick = leftClick;
        data.writeBoolean(this.leftClick);
        this.configureWrite(data);
    }

    @Override
    public void serverPacketData(INetworkInfo manager, AppEngPacket packet, EntityPlayer player) {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        if (this.leftClick) {
            Block block = player.field_70170_p.func_180495_p(pos).func_177230_c();
            if (block instanceof BlockCableBus) {
                ((BlockCableBus)block).onBlockClickPacket(player.field_70170_p, pos, player, this.hand, new Vec3d((double)this.hitX, (double)this.hitY, (double)this.hitZ));
            }
        } else {
            Item item;
            ItemStack is = player.field_71071_by.func_70448_g();
            if (!is.func_190926_b() && (item = is.func_77973_b()) instanceof ToolNetworkTool) {
                ToolNetworkTool tnt = (ToolNetworkTool)item;
                tnt.serverSideToolLogic(is, player, this.hand, player.field_70170_p, pos, this.side, this.hitX, this.hitY, this.hitZ);
            }
        }
    }
}

