/*
 * Decompiled with CFR 0.152.
 */
package appeng.container.implementations;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.definitions.IDefinitions;
import appeng.api.implementations.guiobjects.IGuiItemObject;
import appeng.api.networking.security.IActionHost;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.channels.IItemStorageChannel;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.storage.data.IItemList;
import appeng.container.ContainerNull;
import appeng.container.guisync.GuiSync;
import appeng.container.implementations.ContainerMEMonitorable;
import appeng.container.slot.AppEngSlot;
import appeng.container.slot.IOptionalSlotHost;
import appeng.container.slot.OptionalSlotFake;
import appeng.container.slot.SlotFake;
import appeng.container.slot.SlotFakeCraftingMatrix;
import appeng.container.slot.SlotPatternTerm;
import appeng.container.slot.SlotPlayerHotBar;
import appeng.container.slot.SlotPlayerInv;
import appeng.container.slot.SlotRestrictedInput;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.helpers.IContainerCraftingPacket;
import appeng.helpers.ItemStackHelper;
import appeng.items.storage.ItemViewCell;
import appeng.me.helpers.MachineSource;
import appeng.parts.reporting.AbstractPartEncoder;
import appeng.tile.inventory.AppEngInternalInventory;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.AdaptorItemHandler;
import appeng.util.inv.IAEAppEngInventory;
import appeng.util.inv.InvOperation;
import appeng.util.inv.WrapperCursorItemHandler;
import appeng.util.item.AEItemStack;
import java.util.ArrayList;
import java.util.Optional;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryCraftResult;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.inventory.Slot;
import net.minecraft.inventory.SlotCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.PlayerInvWrapper;

public abstract class ContainerPatternEncoder
extends ContainerMEMonitorable
implements IAEAppEngInventory,
IOptionalSlotHost,
IContainerCraftingPacket {
    protected AbstractPartEncoder patternTerminal = null;
    protected IGuiItemObject iGuiItemObject = null;
    final AppEngInternalInventory cOut = new AppEngInternalInventory(null, 1);
    protected IItemHandler crafting;
    protected SlotPatternTerm craftSlot;
    protected SlotRestrictedInput patternSlotIN;
    protected SlotRestrictedInput patternSlotOUT;
    protected IRecipe currentRecipe;
    protected SlotFakeCraftingMatrix[] craftingSlots;
    protected OptionalSlotFake[] outputSlots;
    @GuiSync(value=97)
    public boolean craftingMode = true;
    @GuiSync(value=96)
    public boolean substitute = false;

    protected ContainerPatternEncoder(InventoryPlayer ip, ITerminalHost monitorable, boolean bindInventory) {
        super(ip, monitorable, bindInventory);
        this.patternTerminal = (AbstractPartEncoder)monitorable;
    }

    protected ContainerPatternEncoder(InventoryPlayer ip, ITerminalHost monitorable, IGuiItemObject iGuiItemObject, boolean bindInventory) {
        super(ip, monitorable, iGuiItemObject, bindInventory);
        if (monitorable instanceof AbstractPartEncoder) {
            this.patternTerminal = (AbstractPartEncoder)monitorable;
        }
        this.iGuiItemObject = iGuiItemObject;
    }

    @Override
    public ItemStack func_82846_b(EntityPlayer p, int idx) {
        if (Platform.isClient()) {
            return ItemStack.field_190927_a;
        }
        if (this.field_75151_b.get(idx) instanceof SlotPlayerInv || this.field_75151_b.get(idx) instanceof SlotPlayerHotBar) {
            AppEngSlot clickSlot = (AppEngSlot)((Object)this.field_75151_b.get(idx));
            ItemStack itemStack = clickSlot.func_75211_c();
            if (AEApi.instance().definitions().materials().blankPattern().isSameAs(itemStack)) {
                IItemHandler patternInv = this.getPart().getInventoryByName("pattern");
                ItemStack remainder = patternInv.insertItem(0, itemStack, false);
                clickSlot.func_75215_d(remainder);
            }
        }
        return super.func_82846_b(p, idx);
    }

    public AbstractPartEncoder getPart() {
        return this.patternTerminal;
    }

    @Override
    public abstract boolean isSlotEnabled(int var1);

    @Override
    public IItemHandler getInventoryByName(String name) {
        if (name.equals("player")) {
            return new PlayerInvWrapper(this.getInventoryPlayer());
        }
        if (this.getPart() != null) {
            return this.getPart().getInventoryByName(name);
        }
        return null;
    }

    @Override
    public boolean useRealItems() {
        return false;
    }

    @Override
    public void saveChanges() {
    }

    @Override
    public void onChangeInventory(IItemHandler inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
        if (inv == this.crafting) {
            this.fixCraftingRecipes();
        }
    }

    void fixCraftingRecipes() {
        if (this.isCraftingMode()) {
            for (int x = 0; x < this.crafting.getSlots(); ++x) {
                ItemStack is = this.crafting.getStackInSlot(x);
                if (is.func_190926_b()) continue;
                is.func_190920_e(1);
            }
        }
    }

    public void func_75141_a(int slotID, ItemStack stack) {
        super.func_75141_a(slotID, stack);
        this.getAndUpdateOutput();
    }

    protected void updateOrderOfOutputSlots() {
        if (!this.isCraftingMode()) {
            if (this.craftSlot != null) {
                this.craftSlot.field_75223_e = -9000;
            }
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = this.outputSlots[y].getX();
            }
        } else {
            if (this.craftSlot != null) {
                this.craftSlot.field_75223_e = this.craftSlot.getX();
            }
            for (int y = 0; y < 3; ++y) {
                this.outputSlots[y].field_75223_e = -9000;
            }
        }
    }

    @Override
    public void onSlotChange(Slot s) {
        if (s == this.patternSlotOUT && Platform.isServer()) {
            for (IContainerListener listener : this.field_75149_d) {
                for (Slot slot : this.field_75151_b) {
                    if (!(slot instanceof OptionalSlotFake) && !(slot instanceof SlotFakeCraftingMatrix)) continue;
                    listener.func_71111_a((Container)this, slot.field_75222_d, slot.func_75211_c());
                }
                if (!(listener instanceof EntityPlayerMP)) continue;
                ((EntityPlayerMP)listener).field_71137_h = false;
            }
            this.func_75142_b();
        }
        if (s == this.craftSlot && Platform.isClient()) {
            this.getAndUpdateOutput();
        }
    }

    public void encodeAndMoveToInventory() {
        this.encode();
        ItemStack output = this.patternSlotOUT.func_75211_c();
        if (!output.func_190926_b()) {
            if (!this.getPlayerInv().func_70441_a(output)) {
                this.getPlayerInv().field_70458_d.func_71019_a(output, false);
            }
            this.patternSlotOUT.func_75215_d(ItemStack.field_190927_a);
        }
    }

    public void encode() {
        ItemStack output = this.patternSlotOUT.func_75211_c();
        ItemStack[] in = this.getInputs();
        ItemStack[] out = this.getOutputs();
        if (in == null || out == null) {
            return;
        }
        if (!output.func_190926_b() && !this.isPattern(output)) {
            return;
        }
        if (output.func_190926_b()) {
            Optional<ItemStack> maybePattern;
            output = this.patternSlotIN.func_75211_c();
            if (output.func_190926_b() || !this.isPattern(output)) {
                return;
            }
            output.func_190920_e(output.func_190916_E() - 1);
            if (output.func_190916_E() == 0) {
                this.patternSlotIN.func_75215_d(ItemStack.field_190927_a);
            }
            if ((maybePattern = AEApi.instance().definitions().items().encodedPattern().maybeStack(1)).isPresent()) {
                output = maybePattern.get();
            }
        }
        NBTTagCompound encodedValue = new NBTTagCompound();
        NBTTagList tagIn = new NBTTagList();
        NBTTagList tagOut = new NBTTagList();
        for (ItemStack i : in) {
            tagIn.func_74742_a(this.createItemTag(i));
        }
        for (ItemStack i : out) {
            tagOut.func_74742_a(this.createItemTag(i));
        }
        encodedValue.func_74782_a("in", (NBTBase)tagIn);
        encodedValue.func_74782_a("out", (NBTBase)tagOut);
        encodedValue.func_74757_a("crafting", this.isCraftingMode());
        encodedValue.func_74757_a("substitute", this.isSubstitute());
        output.func_77982_d(encodedValue);
        this.patternSlotOUT.func_75215_d(output);
    }

    public void multiply(int multiple) {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean canMultiplyInputs = true;
        boolean canMultiplyOutputs = true;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() * multiple >= 1) continue;
            canMultiplyInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() * multiple >= 1) continue;
            canMultiplyOutputs = false;
        }
        if (canMultiplyInputs && canMultiplyOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.craftingSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() * multiple);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() * multiple);
            }
        }
    }

    public void divide(int divide) {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean canDivideInputs = true;
        boolean canDivideOutputs = true;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() % divide == 0) continue;
            canDivideInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() % divide == 0) continue;
            canDivideOutputs = false;
        }
        if (canDivideInputs && canDivideOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.craftingSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() / divide);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() / divide);
            }
        }
    }

    public void increase(int increase) {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean canIncreaseInputs = true;
        boolean canIncreaseOutputs = true;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() + increase >= 1) continue;
            canIncreaseInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() + increase >= 1) continue;
            canIncreaseOutputs = false;
        }
        if (canIncreaseInputs && canIncreaseOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.craftingSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() + increase);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() + increase);
            }
        }
    }

    public void decrease(int decrease) {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean canDecreaseInputs = true;
        boolean canDecreaseOutputs = true;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b() || input[x].func_190916_E() - decrease >= 1) continue;
            canDecreaseInputs = false;
        }
        for (OptionalSlotFake optionalSlotFake : this.outputSlots) {
            ItemStack out = optionalSlotFake.func_75211_c();
            if (out.func_190926_b() || out.func_190916_E() - decrease >= 1) continue;
            canDecreaseOutputs = false;
        }
        if (canDecreaseInputs && canDecreaseOutputs) {
            ItemStack stack;
            for (SlotFake slotFake : this.craftingSlots) {
                stack = slotFake.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFake.func_75211_c().func_190920_e(stack.func_190916_E() - decrease);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() - decrease);
            }
        }
    }

    public void maximizeCount() {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean canGrowInputs = true;
        boolean canGrowOutputs = true;
        int maxInputStackGrowth = 0;
        int maxOutputStackGrowth = 0;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (!input[x].func_190926_b() && input[x].func_77976_d() - input[x].func_190916_E() > maxInputStackGrowth) {
                maxInputStackGrowth = input[x].func_77976_d() - input[x].func_190916_E();
            }
            if (input[x].func_190926_b() || input[x].func_190916_E() + maxInputStackGrowth <= input[x].func_77976_d()) continue;
            canGrowInputs = false;
        }
        for (OptionalSlotFake outputSlot : this.outputSlots) {
            ItemStack itemStack = outputSlot.func_75211_c();
            maxOutputStackGrowth = itemStack.func_77976_d() - itemStack.func_190916_E();
            if (itemStack.func_190926_b() || itemStack.func_190916_E() + maxOutputStackGrowth <= itemStack.func_77976_d()) continue;
            canGrowOutputs = false;
        }
        if (canGrowInputs && canGrowOutputs) {
            ItemStack stack;
            int maxStackGrowth = Math.min(maxInputStackGrowth, maxOutputStackGrowth);
            for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
                stack = slotFakeCraftingMatrix.func_75211_c();
                if (stack.func_190926_b()) continue;
                slotFakeCraftingMatrix.func_75211_c().func_190920_e(stack.func_190916_E() + maxStackGrowth);
            }
            for (SlotFake slotFake : this.outputSlots) {
                stack = ((OptionalSlotFake)slotFake).func_75211_c();
                if (stack.func_190926_b()) continue;
                ((OptionalSlotFake)slotFake).func_75211_c().func_190920_e(stack.func_190916_E() + maxStackGrowth);
            }
        }
    }

    protected ItemStack[] getInputs() {
        ItemStack[] input = new ItemStack[this.craftingSlots.length];
        boolean hasValue = false;
        for (int x = 0; x < this.craftingSlots.length; ++x) {
            input[x] = this.craftingSlots[x].func_75211_c();
            if (input[x].func_190926_b()) continue;
            hasValue = true;
        }
        if (hasValue) {
            return input;
        }
        return null;
    }

    protected ItemStack[] getOutputs() {
        if (this.isCraftingMode()) {
            ItemStack out = this.getAndUpdateOutput();
            if (!out.func_190926_b() && out.func_190916_E() > 0) {
                return new ItemStack[]{out};
            }
        } else {
            ArrayList<ItemStack> list = new ArrayList<ItemStack>(this.outputSlots.length);
            boolean hasValue = false;
            for (OptionalSlotFake outputSlot : this.outputSlots) {
                ItemStack out = outputSlot.func_75211_c();
                if (out.func_190926_b() || out.func_190916_E() <= 0) continue;
                list.add(out);
                hasValue = true;
            }
            if (hasValue) {
                return list.toArray(new ItemStack[0]);
            }
        }
        return null;
    }

    protected ItemStack getAndUpdateOutput() {
        World world = this.getPlayerInv().field_70458_d.field_70170_p;
        InventoryCrafting ic = new InventoryCrafting((Container)this, 3, 3);
        for (int x = 0; x < ic.func_70302_i_(); ++x) {
            ic.func_70299_a(x, this.crafting.getStackInSlot(x));
        }
        if (this.currentRecipe == null || !this.currentRecipe.func_77569_a(ic, world)) {
            this.currentRecipe = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)world);
        }
        ItemStack is = this.currentRecipe == null ? ItemStack.field_190927_a : this.currentRecipe.func_77572_b(ic);
        this.cOut.setStackInSlot(0, is);
        return is;
    }

    public boolean isCraftingMode() {
        return this.craftingMode;
    }

    public void setCraftingMode(boolean craftingMode) {
        NBTTagCompound nbtTagCompound;
        this.craftingMode = craftingMode;
        if (this.getPart() != null) {
            this.getPart().setCraftingRecipe(craftingMode);
        } else if (this.iGuiItemObject != null && (nbtTagCompound = this.iGuiItemObject.getItemStack().func_77978_p()) != null) {
            nbtTagCompound.func_74757_a("isCraftingMode", craftingMode);
            this.updateOrderOfOutputSlots();
        }
        if (craftingMode) {
            this.fixCraftingRecipes();
        }
    }

    boolean isSubstitute() {
        return this.substitute;
    }

    public void setSubstitute(boolean substitute) {
        NBTTagCompound nbtTagCompound;
        this.substitute = substitute;
        if (this.getPart() != null) {
            this.getPart().setSubstitution(substitute);
        } else if (this.iGuiItemObject != null && (nbtTagCompound = this.iGuiItemObject.getItemStack().func_77978_p()) != null) {
            nbtTagCompound.func_74757_a("isSubstitute", substitute);
        }
    }

    @Override
    public void func_75142_b() {
        super.func_75142_b();
        if (Platform.isServer()) {
            if (this.getPart() != null) {
                if (this.isCraftingMode() != this.getPart().isCraftingRecipe()) {
                    this.setCraftingMode(this.getPart().isCraftingRecipe());
                    this.updateOrderOfOutputSlots();
                }
                this.substitute = this.getPart().isSubstitution();
            } else if (this.iGuiItemObject != null) {
                NBTTagCompound nbtTagCompound = this.iGuiItemObject.getItemStack().func_77978_p();
                if (nbtTagCompound != null) {
                    if (nbtTagCompound.func_74764_b("isCraftingMode")) {
                        boolean crafting = nbtTagCompound.func_74767_n("isCraftingMode");
                        if (this.isCraftingMode() != crafting) {
                            this.setCraftingMode(crafting);
                            this.updateOrderOfOutputSlots();
                        }
                    } else {
                        nbtTagCompound.func_74757_a("isCraftingMode", false);
                    }
                } else {
                    nbtTagCompound = new NBTTagCompound();
                    nbtTagCompound.func_74757_a("isCraftingMode", false);
                    this.iGuiItemObject.getItemStack().func_77982_d(nbtTagCompound);
                }
                nbtTagCompound = this.iGuiItemObject.getItemStack().func_77978_p();
                if (nbtTagCompound != null) {
                    if (nbtTagCompound.func_74764_b("isSubstitute")) {
                        boolean substitute = nbtTagCompound.func_74767_n("isSubstitute");
                        if (this.isSubstitute() != substitute) {
                            this.setSubstitute(substitute);
                        }
                    } else {
                        nbtTagCompound.func_74757_a("isSubstitute", false);
                    }
                } else {
                    nbtTagCompound = new NBTTagCompound();
                    nbtTagCompound.func_74757_a("isSubstitute", false);
                    this.iGuiItemObject.getItemStack().func_77982_d(nbtTagCompound);
                }
            }
        }
    }

    @Override
    public void onUpdate(String field, Object oldValue, Object newValue) {
        super.onUpdate(field, oldValue, newValue);
        if (field.equals("craftingMode")) {
            this.getAndUpdateOutput();
            this.updateOrderOfOutputSlots();
        }
    }

    boolean isPattern(ItemStack output) {
        if (output.func_190926_b()) {
            return false;
        }
        IDefinitions definitions = AEApi.instance().definitions();
        boolean isPattern = definitions.items().encodedPattern().isSameAs(output);
        return isPattern |= definitions.materials().blankPattern().isSameAs(output);
    }

    NBTBase createItemTag(ItemStack i) {
        NBTTagCompound c = new NBTTagCompound();
        if (!i.func_190926_b()) {
            ItemStackHelper.stackWriteToNBT(i, c);
        }
        return c;
    }

    public void clear() {
        for (SlotFakeCraftingMatrix slotFakeCraftingMatrix : this.craftingSlots) {
            slotFakeCraftingMatrix.func_75215_d(ItemStack.field_190927_a);
        }
        for (SlotFake slotFake : this.outputSlots) {
            slotFake.func_75215_d(ItemStack.field_190927_a);
        }
        this.func_75142_b();
        this.getAndUpdateOutput();
    }

    public void craftOrGetItem(PacketPatternSlot packetPatternSlot) {
        if (packetPatternSlot.slotItem != null && this.getCellInventory() != null) {
            IAEItemStack out = packetPatternSlot.slotItem.copy();
            InventoryAdaptor inv = new AdaptorItemHandler((IItemHandler)new WrapperCursorItemHandler(this.getPlayerInv().field_70458_d.field_71071_by));
            InventoryAdaptor playerInv = InventoryAdaptor.getAdaptor(this.getPlayerInv().field_70458_d);
            if (packetPatternSlot.shift) {
                inv = playerInv;
            }
            if (!inv.simulateAdd(out.createItemStack()).func_190926_b()) {
                return;
            }
            IAEItemStack extracted = Platform.poweredExtraction(this.getPowerSource(), this.getCellInventory(), out, this.getActionSource());
            EntityPlayer p = this.getPlayerInv().field_70458_d;
            if (extracted != null) {
                inv.addItems(extracted.createItemStack());
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
                return;
            }
            InventoryCrafting ic = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            InventoryCrafting real = new InventoryCrafting((Container)new ContainerNull(), 3, 3);
            for (int x = 0; x < 9; ++x) {
                ic.func_70299_a(x, packetPatternSlot.pattern[x] == null ? ItemStack.field_190927_a : packetPatternSlot.pattern[x].createItemStack());
            }
            IRecipe r = CraftingManager.func_192413_b((InventoryCrafting)ic, (World)p.field_70170_p);
            if (r == null) {
                return;
            }
            IMEMonitor<IAEItemStack> storage = null;
            if (this.getPart() != null) {
                storage = this.getPart().getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            } else if (this.iGuiItemObject != null) {
                storage = ((ITerminalHost)((Object)this.iGuiItemObject)).getInventory(AEApi.instance().storage().getStorageChannel(IItemStorageChannel.class));
            }
            IItemList<IAEItemStack> all = storage.getStorageList();
            ItemStack is = r.func_77572_b(ic);
            for (int x = 0; x < ic.func_70302_i_(); ++x) {
                if (ic.func_70301_a(x).func_190926_b()) continue;
                ItemStack pulled = Platform.extractItemsByRecipe(this.getPowerSource(), this.getActionSource(), storage, p.field_70170_p, r, is, ic, ic.func_70301_a(x), x, all, Actionable.MODULATE, ItemViewCell.createFilter(this.getViewCells()));
                real.func_70299_a(x, pulled);
            }
            IRecipe rr = CraftingManager.func_192413_b((InventoryCrafting)real, (World)p.field_70170_p);
            if (rr == r && Platform.itemComparisons().isSameItem(rr.func_77572_b(real), is)) {
                InventoryCraftResult craftingResult = new InventoryCraftResult();
                craftingResult.func_193056_a(rr);
                SlotCrafting sc = new SlotCrafting(p, real, (IInventory)craftingResult, 0, 0, 0);
                sc.func_190901_a(p, is);
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = playerInv.addItems(real.func_70301_a(x));
                    if (failed.func_190926_b()) continue;
                    p.func_71019_a(failed, false);
                }
                inv.addItems(is);
                if (p instanceof EntityPlayerMP) {
                    this.updateHeld((EntityPlayerMP)p);
                }
                this.func_75142_b();
            } else {
                for (int x = 0; x < real.func_70302_i_(); ++x) {
                    ItemStack failed = real.func_70301_a(x);
                    if (failed.func_190926_b()) continue;
                    this.getCellInventory().injectItems(AEItemStack.fromItemStack(failed), Actionable.MODULATE, new MachineSource(this.getPart() != null ? this.getPart() : (IActionHost)((Object)this.iGuiItemObject)));
                }
            }
        }
    }
}

