/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.cablebus;

import java.util.Arrays;
import java.util.function.Function;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class SmartCableTextures {
    public static final ResourceLocation[] SMART_CHANNELS_TEXTURES = new ResourceLocation[]{new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_00"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_01"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_02"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_03"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_04"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_10"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_11"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_12"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_13"), new ResourceLocation("appliedenergistics2", "parts/cable/smart/channels_14")};
    private final TextureAtlasSprite[] textures = (TextureAtlasSprite[])Arrays.stream(SMART_CHANNELS_TEXTURES).map(bakedTextureGetter::apply).toArray(TextureAtlasSprite[]::new);
    public static final ResourceLocation[] DENSE_SMART_CHANNELS_TEXTURES = new ResourceLocation[]{new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_00"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_01"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_02"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_03"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_04"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_10"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_11"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_12"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_13"), new ResourceLocation("appliedenergistics2", "parts/cable/dense_smart/channels_14")};
    private final TextureAtlasSprite[] denseTextures = (TextureAtlasSprite[])Arrays.stream(DENSE_SMART_CHANNELS_TEXTURES).map(bakedTextureGetter::apply).toArray(TextureAtlasSprite[]::new);

    public SmartCableTextures(Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
    }

    public TextureAtlasSprite getOddTextureForChannels(int channels) {
        if (channels < 0) {
            return this.textures[0];
        }
        if (channels <= 4) {
            return this.textures[channels];
        }
        return this.textures[4];
    }

    public TextureAtlasSprite getOddTextureForDenseChannels(int channels) {
        if (channels < 0) {
            return this.denseTextures[0];
        }
        if (channels <= 4) {
            return this.denseTextures[channels];
        }
        return this.denseTextures[4];
    }

    public TextureAtlasSprite getEvenTextureForChannels(int channels) {
        if (channels < 5) {
            return this.textures[5];
        }
        if (channels <= 8) {
            return this.textures[1 + channels];
        }
        return this.textures[9];
    }

    public TextureAtlasSprite getEvenTextureForDenseChannels(int channels) {
        if (channels < 5) {
            return this.denseTextures[5];
        }
        if (channels <= 8) {
            return this.denseTextures[1 + channels];
        }
        return this.denseTextures[9];
    }
}

