/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.util;

import com.feed_the_beast.ftblib.lib.icon.Icon;
import com.feed_the_beast.ftblib.lib.math.MathUtils;
import com.feed_the_beast.ftblib.lib.util.misc.NameMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;

public enum EnumBarrelModel implements IStringSerializable
{
    BARREL("barrel", Block.field_185505_j),
    CRATE("crate", Block.field_185505_j),
    BLOCK_WINDOW("block_window", Block.field_185505_j),
    BLOCK_BORDERS("block_borders", Block.field_185505_j),
    COVER("cover", new AxisAlignedBB(0.0, 0.875, 0.0, 1.0, 1.0, 1.0)),
    PANEL("panel", new AxisAlignedBB(0.0, 0.75, 0.0, 1.0, 1.0, 1.0)),
    SLAB("slab", new AxisAlignedBB(0.0, 0.5, 0.0, 1.0, 1.0, 1.0)),
    BLOCK("block", Block.field_185505_j);

    public static final NameMap<EnumBarrelModel> NAME_MAP;
    public static final Collection<ResourceLocation> ALL_MODEL_LOCATIONS;
    private final String name;
    private final String translationKey;
    private final AxisAlignedBB[] boxes;
    private final ResourceLocation baseModel;
    private ResourceLocation cutoutModel;
    public Icon icon;
    public float textDistance;
    public float iconDistance;

    public static EnumBarrelModel getFromNBTName(String id) {
        if (id.isEmpty()) {
            return BARREL;
        }
        int i = id.indexOf(58);
        if (i != -1) {
            id = id.substring(i + 1);
        }
        return (EnumBarrelModel)((Object)NAME_MAP.get(id));
    }

    private EnumBarrelModel(String n2, AxisAlignedBB box) {
        this.name = n2;
        this.translationKey = "yabba.yabba_model." + this.name;
        this.boxes = MathUtils.getRotatedBoxes((AxisAlignedBB)box);
        this.baseModel = new ResourceLocation("yabba", "block/barrel/" + this.name);
        this.textDistance = -0.08f;
        this.iconDistance = 0.64f;
        this.icon = Icon.EMPTY;
    }

    public String func_176610_l() {
        return this.name;
    }

    public String getNBTName() {
        return this.isDefault() ? "" : this.func_176610_l();
    }

    public String getTranslationKey() {
        return this.translationKey;
    }

    public AxisAlignedBB getAABB(EnumFacing facing) {
        return this.boxes[facing.func_176745_a()];
    }

    public ResourceLocation getBaseModel() {
        return this.baseModel;
    }

    @Nullable
    public ResourceLocation getCutoutModel() {
        return this.cutoutModel;
    }

    public boolean isDefault() {
        return this == BARREL;
    }

    static {
        NAME_MAP = NameMap.create((Object)((Object)BARREL), (Object[])EnumBarrelModel.values());
        EnumBarrelModel.BARREL.cutoutModel = new ResourceLocation("yabba", "block/barrel/barrel_cutout");
        EnumBarrelModel.BLOCK_WINDOW.cutoutModel = new ResourceLocation("yabba", "block/barrel/block_window_cutout");
        EnumBarrelModel.BLOCK_BORDERS.cutoutModel = new ResourceLocation("yabba", "block/barrel/block_borders_cutout");
        ArrayList<ResourceLocation> list = new ArrayList<ResourceLocation>(NAME_MAP.size() + 3);
        for (EnumBarrelModel model : NAME_MAP) {
            list.add(model.getBaseModel());
            if (model.getCutoutModel() == null) continue;
            list.add(model.getCutoutModel());
        }
        ALL_MODEL_LOCATIONS = Collections.unmodifiableList(list);
        EnumBarrelModel.COVER.textDistance = 13.92f;
        EnumBarrelModel.COVER.iconDistance = 13.84f;
        EnumBarrelModel.PANEL.textDistance = 11.92f;
        EnumBarrelModel.PANEL.iconDistance = 11.84f;
        EnumBarrelModel.SLAB.textDistance = 7.92f;
        EnumBarrelModel.SLAB.iconDistance = 7.82f;
        EnumBarrelModel.BLOCK.iconDistance = -0.08f;
    }
}

