/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.tile;

import com.feed_the_beast.ftblib.lib.util.InvUtils;
import com.latmod.yabba.YabbaConfig;
import com.latmod.yabba.YabbaItems;
import com.latmod.yabba.api.BarrelContentType;
import com.latmod.yabba.api.UpgradeData;
import com.latmod.yabba.block.Tier;
import com.latmod.yabba.item.upgrade.ItemUpgradeRedstone;
import com.latmod.yabba.item.upgrade.ItemUpgradeTier;
import com.latmod.yabba.tile.Barrel;
import com.latmod.yabba.tile.BarrelContent;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTPrimitive;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class ItemBarrel
extends BarrelContent
implements IItemHandler {
    public ItemStack type = ItemStack.field_190927_a;
    public int count = 0;
    private String cachedItemName;
    private String cachedcount;

    public ItemBarrel(Barrel b) {
        super(b);
    }

    @Override
    public BarrelContentType getType() {
        return BarrelContentType.ITEM;
    }

    @Override
    public boolean isEmpty() {
        return this.type.func_190926_b();
    }

    @Override
    public void writeData(NBTTagCompound nbt) {
        if (this.count > 0) {
            nbt.func_74768_a("Count", this.count);
        }
        if (!this.type.func_190926_b()) {
            this.type.func_190920_e(1);
            nbt.func_74782_a("Item", (NBTBase)this.type.serializeNBT());
        }
    }

    @Override
    public void readData(NBTTagCompound nbt) {
        this.count = nbt.func_74762_e("Count");
        ItemStack itemStack = this.type = nbt.func_74764_b("Item") ? new ItemStack(nbt.func_74775_l("Item")) : ItemStack.field_190927_a;
        if (this.type.func_190926_b()) {
            this.type = ItemStack.field_190927_a;
        }
    }

    @Override
    @Nullable
    public NBTBase writeContentData() {
        if (this.count > Short.MAX_VALUE) {
            return new NBTTagInt(this.count);
        }
        if (this.count > 127) {
            return new NBTTagShort((short)this.count);
        }
        return new NBTTagByte((byte)this.count);
    }

    @Override
    public void readContentData(@Nullable NBTBase nbt) {
        this.count = nbt instanceof NBTPrimitive ? ((NBTPrimitive)nbt).func_150287_d() : 0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
    }

    @Override
    @Nullable
    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        return (T)(capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY ? this : null);
    }

    public int getSlots() {
        return 2;
    }

    public ItemStack getStackInSlot(int slot) {
        if (slot == 0 || this.count <= 0) {
            return ItemStack.field_190927_a;
        }
        this.type.func_190920_e(this.barrel.isCreative() ? 1000000000 : this.count);
        return this.type;
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        if (slot != 0) {
            return stack;
        }
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        boolean isItemValid = this.isItemValid(slot, stack);
        if (this.barrel.isCreative()) {
            return isItemValid ? ItemStack.field_190927_a : stack;
        }
        if (!isItemValid) {
            return stack;
        }
        int capacity = this.getMaxItems(stack);
        if (this.count >= capacity && !this.type.func_190926_b()) {
            return this.barrel.hasUpgrade(YabbaItems.UPGRADE_VOID) ? ItemStack.field_190927_a : stack;
        }
        int size = Math.min(stack.func_190916_E(), capacity - this.count);
        if (size > 0 && !simulate) {
            if (this.type.func_190926_b()) {
                this.type = stack.func_77946_l();
                this.type.func_190920_e(size);
                this.count = size;
                this.barrel.block.markBarrelDirty(true);
            } else {
                this.count += size;
                this.barrel.block.markBarrelDirty(false);
            }
            if (this.count >= capacity && YabbaConfig.general.transform_star_to_creative && !this.barrel.isCreative() && this.barrel.getTier().tier >= Tier.STAR.tier) {
                int i;
                for (int i2 = 0; i2 < this.barrel.getUpgradeCount(); ++i2) {
                    if (!(this.barrel.getUpgrade(i2) instanceof ItemUpgradeTier.TierUpgradeData)) continue;
                    this.barrel.setUpgrade(i2, null);
                }
                ItemStack upgradeStack = new ItemStack(YabbaItems.UPGRADE_CREATIVE);
                UpgradeData data = (UpgradeData)upgradeStack.getCapability(UpgradeData.CAPABILITY, null);
                if (data != null && (i = this.barrel.findFreeUpgradeSlot()) != -1) {
                    this.barrel.setLocked(false);
                    this.onCreativeChange();
                    this.barrel.setUpgrade(i, data);
                    this.barrel.block.markBarrelDirty(true);
                }
            }
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.func_190916_E() - size));
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount <= 0 || slot == 0 || this.count <= 0 || this.type.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (this.barrel.isCreative()) {
            return ItemHandlerHelper.copyStackWithSize((ItemStack)this.type, (int)Math.min(amount, this.type.func_77976_d()));
        }
        ItemStack stack = ItemHandlerHelper.copyStackWithSize((ItemStack)this.type, (int)Math.min(Math.min(amount, this.count), this.type.func_77976_d()));
        if (!simulate) {
            this.count -= stack.func_190916_E();
            if (this.count <= 0 && !this.barrel.isLocked()) {
                this.type = ItemStack.field_190927_a;
                this.barrel.block.markBarrelDirty(true);
            } else {
                this.barrel.block.markBarrelDirty(false);
            }
        }
        return stack;
    }

    public int getSlotLimit(int slot) {
        return 2000000000;
    }

    public int getMaxItems(ItemStack stack) {
        if (this.barrel.getTier().infiniteCapacity()) {
            return 2000000000;
        }
        return this.barrel.getTier().maxItemStacks * (stack.func_190926_b() ? 64 : stack.func_77976_d());
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (slot != 0) {
            return false;
        }
        if (this.type.func_190926_b()) {
            return !YabbaConfig.general.isItemBlacklistedInput(stack.func_77973_b());
        }
        if (YabbaConfig.general.isItemBlacklistedInput(stack.func_77973_b()) || this.type.func_77973_b() != stack.func_77973_b() || this.type.func_77960_j() != stack.func_77960_j() || this.type.func_77952_i() != stack.func_77952_i()) {
            return false;
        }
        return Objects.equals(InvUtils.nullIfEmpty((NBTTagCompound)this.type.func_77978_p()), InvUtils.nullIfEmpty((NBTTagCompound)stack.func_77978_p())) && this.type.areCapsCompatible(stack);
    }

    public int getFreeSpace() {
        return this.getMaxItems(this.type) - this.count;
    }

    @Override
    public String getItemDisplayName() {
        if (this.cachedItemName == null) {
            this.cachedItemName = this.type.func_190926_b() ? "" : TextFormatting.BOLD + TextFormatting.func_110646_a((String)this.type.func_82833_r());
        }
        return this.cachedItemName;
    }

    @Override
    public String getItemDisplayCount(boolean sneaking, boolean creative, boolean infinite) {
        if (creative) {
            return "INF";
        }
        if (sneaking) {
            return infinite ? Integer.toString(this.count) : this.count + " / " + this.getMaxItems(this.type);
        }
        if (this.cachedcount == null) {
            int max;
            int n = max = this.type.func_190926_b() ? 64 : this.type.func_77976_d();
            if (max == 1 || this.count <= max) {
                this.cachedcount = Integer.toString(this.count);
            } else {
                this.cachedcount = this.count / max + "x" + max;
                int extra = this.count % max;
                if (extra != 0) {
                    this.cachedcount = this.cachedcount + "+" + extra;
                }
            }
        }
        return this.cachedcount;
    }

    @Override
    public void clearCache() {
        this.cachedItemName = null;
        this.cachedcount = null;
    }

    @Override
    public void addItem(EntityPlayerMP player, EnumHand hand) {
        ItemStack heldItem = player.func_184586_b(hand);
        int c = heldItem.func_190916_E();
        heldItem.func_190920_e(this.insertItem(0, heldItem, false).func_190916_E());
        if (c != heldItem.func_190916_E()) {
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    @Override
    public void addAllItems(EntityPlayerMP player, EnumHand hand) {
        if (this.type.func_190926_b()) {
            return;
        }
        boolean updateInv = false;
        for (int i = 0; i < player.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack0 = (ItemStack)player.field_71071_by.field_70462_a.get(i);
            ItemStack is = this.insertItem(0, stack0, false);
            if (is == (stack0 = (ItemStack)player.field_71071_by.field_70462_a.get(i))) continue;
            stack0.func_190920_e(is.func_190916_E());
            if (!stack0.func_190926_b()) continue;
            player.field_71071_by.field_70462_a.set(i, (Object)ItemStack.field_190927_a);
            updateInv = true;
        }
        if (updateInv) {
            player.field_71071_by.func_70296_d();
            if (player.field_71070_bA != null) {
                player.field_71070_bA.func_75142_b();
            }
        }
    }

    @Override
    public void removeItem(EntityPlayerMP player, boolean removeStack) {
        int size;
        ItemStack stack;
        if (!this.type.func_190926_b() && this.count == 0 && !this.barrel.isLocked()) {
            this.type = ItemStack.field_190927_a;
            this.count = 0;
            this.barrel.block.markBarrelDirty(true);
            return;
        }
        if (!this.type.func_190926_b() && this.count > 0 && !(stack = this.extractItem(1, size = removeStack ? this.type.func_77976_d() : 1, false)).func_190926_b()) {
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)stack, (int)player.field_71071_by.field_70461_c);
        }
    }

    @Override
    public void onCreativeChange() {
        this.count = 1;
    }

    @Override
    public boolean isValidForCreativeUpgrade() {
        return !YabbaConfig.general.isItemBlacklistedCreative(this.type.func_77973_b());
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(List<String> tooltip, ITooltipFlag flag) {
        if (!this.type.func_190926_b()) {
            tooltip.add(I18n.func_135052_a((String)"lang.yabba.item", (Object[])new Object[]{TextFormatting.YELLOW + this.type.func_82833_r()}));
        }
        tooltip.add(I18n.func_135052_a((String)"yabba.tier", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)this.barrel.getTier().getLangKey(), (Object[])new Object[0]));
        if (this.barrel.isLocked()) {
            tooltip.add(I18n.func_135052_a((String)"barrel_config.locked", (Object[])new Object[0]));
        }
        if (!this.barrel.isCreative()) {
            if (this.barrel.getTier().infiniteCapacity()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_inf", (Object[])new Object[]{this.count}));
            } else if (!this.type.func_190926_b()) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count", (Object[])new Object[]{this.count, this.getMaxItems(this.type)}));
            } else {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.item_count_max", (Object[])new Object[]{this.barrel.getTier().maxItemStacks}));
            }
        }
        boolean firstUpgrade = true;
        for (int i = 0; i < this.barrel.getUpgradeCount(); ++i) {
            UpgradeData upgradeData = this.barrel.getUpgrade(i);
            if (upgradeData == null) continue;
            if (firstUpgrade) {
                tooltip.add(I18n.func_135052_a((String)"lang.yabba.upgrades", (Object[])new Object[0]));
                firstUpgrade = false;
            }
            tooltip.add("> " + TextFormatting.YELLOW + upgradeData.stack.func_82833_r());
        }
    }

    @Override
    public int redstoneOutput() {
        UpgradeData data = this.barrel.getUpgradeData(YabbaItems.UPGRADE_REDSTONE_OUT);
        if (data != null) {
            return ((ItemUpgradeRedstone.RedstoneUpgradeData)data).redstoneOutput(this.count);
        }
        return -1;
    }
}

