/*
 * Decompiled with CFR 0.152.
 */
package com.latmod.yabba.gui;

import com.feed_the_beast.ftblib.lib.gui.Button;
import com.feed_the_beast.ftblib.lib.gui.GuiBase;
import com.feed_the_beast.ftblib.lib.gui.Panel;
import com.feed_the_beast.ftblib.lib.gui.PanelScrollBar;
import com.feed_the_beast.ftblib.lib.gui.TextBox;
import com.feed_the_beast.ftblib.lib.gui.Theme;
import com.feed_the_beast.ftblib.lib.gui.Widget;
import com.feed_the_beast.ftblib.lib.gui.WidgetType;
import com.feed_the_beast.ftblib.lib.icon.Color4I;
import com.feed_the_beast.ftblib.lib.util.BlockUtils;
import com.feed_the_beast.ftblib.lib.util.misc.MouseButton;
import com.latmod.yabba.api.BarrelSkin;
import com.latmod.yabba.client.YabbaClient;
import com.latmod.yabba.net.MessageSelectSkin;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.util.text.TextFormatting;

public class GuiSelectSkin
extends GuiBase {
    private final TextBox searchBar;
    private final Panel skinsPanel;
    private final PanelScrollBar scrollBar;
    private final List<Skin> allSkins = new ArrayList<Skin>();

    public GuiSelectSkin() {
        this.setSize(213, 152);
        this.searchBar = new TextBox((Panel)this){

            public void onTextChanged() {
                GuiSelectSkin.this.skinsPanel.refreshWidgets();
            }
        };
        this.searchBar.setPosAndSize(8, 8, 194, 14);
        this.skinsPanel = new Panel((Panel)this){

            public void addWidgets() {
                GuiSelectSkin.this.scrollBar.setValue(0);
                String search = GuiSelectSkin.this.searchBar.getText();
                if (search.isEmpty()) {
                    for (Skin s : GuiSelectSkin.this.allSkins) {
                        this.add((Widget)s);
                    }
                } else {
                    String searchBar1 = search.replace(" ", "").toLowerCase();
                    for (Skin skin : GuiSelectSkin.this.allSkins) {
                        if (skin.searchText.isEmpty() || !skin.searchText.contains(searchBar1)) continue;
                        this.add((Widget)skin);
                    }
                }
            }

            public void alignWidgets() {
                for (int i = 0; i < this.widgets.size(); ++i) {
                    ((Widget)this.widgets.get(i)).setPos(1 + i % 8 * 21, 1 + i / 8 * 21);
                }
                GuiSelectSkin.this.scrollBar.setMaxValue(this.widgets.isEmpty() ? 0 : ((Widget)this.widgets.get((int)(this.widgets.size() - 1))).posY + 21);
            }

            public void drawBackground(Theme theme, int x, int y, int w, int h) {
                theme.drawPanelBackground(x, y, w, h);
            }
        };
        this.skinsPanel.setPosAndSize(9, 29, 169, 113);
        this.scrollBar = new PanelScrollBar((Panel)this, this.skinsPanel);
        this.scrollBar.setCanAlwaysScroll(true);
        this.scrollBar.setCanAlwaysScrollPlane(true);
        this.scrollBar.setPosAndSize(186, 28, 18, 115);
        this.scrollBar.setScrollStep(21);
        for (BarrelSkin s : YabbaClient.ALL_SKINS) {
            this.allSkins.add(new Skin(this.skinsPanel, s));
        }
    }

    public void addWidgets() {
        this.add((Widget)this.searchBar);
        this.add((Widget)this.skinsPanel);
        this.add((Widget)this.scrollBar);
    }

    public void alignWidgets() {
        this.skinsPanel.alignWidgets();
    }

    private class Skin
    extends Button {
        private final BarrelSkin skin;
        private final String searchText;

        private Skin(Panel panel, BarrelSkin s) {
            super(panel);
            this.setSize(20, 20);
            this.skin = s;
            String t = s.toString();
            this.setTitle(t);
            this.searchText = t.replace(" ", "").toLowerCase();
        }

        public void onClicked(MouseButton button) {
            if (this.skin != null) {
                new MessageSelectSkin(this.skin.id).sendToServer();
                this.getGui().closeGui();
            }
        }

        public void addMouseOverText(List<String> list) {
            super.addMouseOverText(list);
            if (Minecraft.func_71410_x().field_71474_y.field_82882_x) {
                String s;
                list.add(TextFormatting.DARK_GRAY + this.skin.id);
                if (this.skin.state != BlockUtils.AIR_STATE && !(s = BlockUtils.getNameFromState((IBlockState)this.skin.state)).equals(this.skin.id)) {
                    list.add(TextFormatting.DARK_GRAY + s);
                }
            }
        }

        public void drawBackground(Theme theme, int x, int y, int w, int h) {
            (this.getWidgetType() == WidgetType.MOUSE_OVER ? Color4I.LIGHT_GREEN.withAlpha(70) : Color4I.BLACK.withAlpha(50)).draw(x, y, w, h);
        }

        public void drawIcon(Theme theme, int x, int y, int w, int h) {
            this.skin.icon.draw(x, y, w, h);
        }
    }
}

