/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca.client;

import de.teamlapen.vampirism_integrations.VampirismIntegrationsMod;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommand;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.client.ClientCommandHandler;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class OverlayAssignmentLoader {
    private static final String TAG = "OverlayAssignment";
    static Map<String, Pair<Integer, Integer>> assignments;
    private static File dumpAssignmentFile;

    public static void init(File configDir) {
        File assignmentFile = new File(configDir, "vampirism/mca_skin_overlay_assignment.txt");
        dumpAssignmentFile = new File(configDir, "vampirism/mca_skin_overlay_assignment_dump.txt");
        try {
            assignments = OverlayAssignmentLoader.loadAssignments(new InputStreamReader(OverlayAssignmentLoader.class.getResourceAsStream("/mca/skin_overlay_assignment.txt")), "skin_overlay_assignment.txt");
        }
        catch (IOException e) {
            VampirismIntegrationsMod.log.bigWarning(TAG, "Could not read mca skin assignments", new Object[0]);
            VampirismIntegrationsMod.log.e(TAG, (Throwable)e, "Exception", new Object[0]);
        }
        if (assignmentFile.exists()) {
            try {
                Map<String, Pair<Integer, Integer>> override = OverlayAssignmentLoader.loadAssignments(new FileReader(assignmentFile), assignmentFile.getName());
                assignments.putAll(override);
                VampirismIntegrationsMod.log.i(TAG, "Successfully loaded additional assignment file", new Object[0]);
            }
            catch (IOException e) {
                VampirismIntegrationsMod.log.e(TAG, "Could not read mca skin assignments from config file %s", new Object[]{assignmentFile.getName()});
            }
        }
    }

    public static boolean save() {
        if (dumpAssignmentFile != null) {
            dumpAssignmentFile.getParentFile().mkdirs();
            try {
                return OverlayAssignmentLoader.writeBloodValues(new FileWriter(dumpAssignmentFile), assignments, "Generated - Not loaded - Copy to mca_skin_overlay_assignment.txt - MCA Texture -> Eye Fang Overlay assignment. Format: texture=eye,fang. Use -1 for fang or eye to disable");
            }
            catch (IOException e) {
                VampirismIntegrationsMod.log.e(TAG, (Throwable)e, "Failed to store mca skin assignments", new Object[0]);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Pair<Integer, Integer>> loadAssignments(Reader r, String file) throws IOException {
        HashMap<String, Pair<Integer, Integer>> map = new HashMap<String, Pair<Integer, Integer>>();
        BufferedReader br = null;
        try {
            String line;
            br = new BufferedReader(r);
            while ((line = br.readLine()) != null) {
                int fang;
                int eye;
                if (line.startsWith("#") || StringUtils.isBlank((CharSequence)line)) continue;
                String[] p = line.split("=");
                if (p.length != 2) {
                    VampirismIntegrationsMod.log.w(TAG, "Line %s  in %s is not formatted properly", new Object[]{line, file});
                    continue;
                }
                String[] p2 = p[1].split(",");
                try {
                    eye = Integer.parseInt(p2[0]);
                    fang = Integer.parseInt(p2[1]);
                }
                catch (NumberFormatException e) {
                    VampirismIntegrationsMod.log.w(TAG, "Line %s  in %s is not formatted properly", new Object[]{line, file});
                    continue;
                }
                map.put(p[0], (Pair<Integer, Integer>)Pair.of((Object)eye, (Object)fang));
            }
        }
        finally {
            if (br != null) {
                br.close();
            }
            r.close();
        }
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean writeBloodValues(Writer w, Map<String, Pair<Integer, Integer>> values, String comment) throws IOException {
        BufferedWriter bw = null;
        try {
            bw = new BufferedWriter(w);
            bw.write(35);
            bw.write(comment);
            bw.newLine();
            for (Map.Entry<String, Pair<Integer, Integer>> entry : values.entrySet()) {
                bw.write(entry.getKey());
                bw.write(61);
                Pair<Integer, Integer> v = entry.getValue();
                bw.write(String.valueOf(v.getLeft()));
                bw.write(44);
                bw.write(String.valueOf(v.getRight()));
                bw.newLine();
            }
            bw.flush();
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            VampirismIntegrationsMod.log.e(TAG, (Throwable)e, "Failed to write mca overlay assignments (%s)", new Object[]{comment});
        }
        finally {
            if (bw != null) {
                bw.close();
            }
            w.close();
        }
        return false;
    }

    public static void registerSaveCommand() {
        ClientCommandHandler.instance.func_71560_a((ICommand)new CommandBase(){

            public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
                if (OverlayAssignmentLoader.save()) {
                    sender.func_145747_a((ITextComponent)new TextComponentString("Successfully stored mca skin assignments to vampirism config directory"));
                }
            }

            public String func_71517_b() {
                return "vampirism-mca-save-assignment";
            }

            public String func_71518_a(ICommandSender sender) {
                return this.func_71517_b();
            }
        });
    }
}

