/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.mca;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.VampirismAPI;
import de.teamlapen.vampirism.api.entity.convertible.IConvertedCreature;
import de.teamlapen.vampirism.api.entity.convertible.IConvertingHandler;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.ai.EntityAIMoveIndoorsDay;
import de.teamlapen.vampirism.entity.ai.VampireAIBiteNearbyEntity;
import de.teamlapen.vampirism.entity.ai.VampireAIFleeSun;
import de.teamlapen.vampirism.entity.ai.VampireAIMoveToBiteable;
import de.teamlapen.vampirism.util.Helper;
import de.teamlapen.vampirism_integrations.mca.EntityVillagerVampirismMCA;
import java.util.Random;
import javax.annotation.Nonnull;
import mca.entity.EntityVillagerMCA;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.ai.EntityAIAttackMelee;
import net.minecraft.entity.ai.EntityAIAvoidEntity;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowGolem;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAIMoveIndoors;
import net.minecraft.entity.ai.EntityAIRestrictSun;
import net.minecraft.entity.ai.EntityAIVillagerMate;
import net.minecraft.init.MobEffects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class EntityConvertedVillagerMCA
extends EntityVillagerVampirismMCA
implements IConvertedCreature<EntityVillagerMCA> {
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean sundamageCache;
    private int bloodTimer = 0;

    public EntityConvertedVillagerMCA(World world) {
        super(world);
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 1) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 42));
                this.func_70690_d(new PotionEffect(MobEffects.field_76421_d, 42));
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient((IVampire)this, (EnumStrength)this.isGettingGarlicDamage(), (int)this.field_70173_aa);
            }
        }
        super.func_70636_d();
        ++this.bloodTimer;
    }

    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
        this.bloodTimer = -1200 - this.field_70146_Z.nextInt(1200);
    }

    public boolean doesResistGarlic(EnumStrength strength) {
        return false;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.field_75782_a.removeIf(entry -> entry.field_75733_a instanceof EntityAIMoveIndoors || entry.field_75733_a instanceof EntityAIVillagerMate || entry.field_75733_a instanceof EntityAIFollowGolem);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAIRestrictSun((EntityCreature)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIAvoidEntity((EntityCreature)this, EntityCreature.class, VampirismAPI.factionRegistry().getPredicate(this.getFaction(), true, true, false, false, (IFaction)VReference.HUNTER_FACTION), 10.0f, (double)0.45f, (double)0.55f));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMoveIndoorsDay((EntityCreature)this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new VampireAIFleeSun((EntityCreature)this, (double)0.6f, true));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIAttackMelee((EntityCreature)this, (double)0.6f, false));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new VampireAIBiteNearbyEntity((IVampireMob)this));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new VampireAIMoveToBiteable((IVampireMob)this, (double)0.55f));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
    }

    public void func_70037_a(NBTTagCompound nbt) {
        super.func_70037_a(nbt);
        this.bloodTimer = nbt.func_74764_b("vamp_converted_bloodtimer") ? nbt.func_74762_e("vamp_converted_bloodtimer") : 0;
    }

    @Nonnull
    public EnumStrength isGettingGarlicDamage(boolean forceRefresh) {
        if (forceRefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    public boolean isIgnoringSundamage() {
        return false;
    }

    public boolean useBlood(int amt, boolean allowPartial) {
        return false;
    }

    public IFaction getFaction() {
        return VReference.VAMPIRE_FACTION;
    }

    public boolean wantsBlood() {
        return this.bloodTimer > 0;
    }

    public void func_70014_b(NBTTagCompound nbt) {
        super.func_70014_b(nbt);
        nbt.func_74768_a("vamp_converted_bloodtimer", this.bloodTimer);
    }

    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public static class ConvertingHandler
    implements IConvertingHandler<EntityVillagerMCA> {
        public IConvertedCreature<EntityVillagerMCA> createFrom(EntityVillagerMCA entity) {
            NBTTagCompound nbt = new NBTTagCompound();
            entity.func_189511_e(nbt);
            EntityConvertedVillagerMCA converted = new EntityConvertedVillagerMCA(entity.field_70170_p);
            converted.func_70020_e(nbt);
            converted.func_184221_a(MathHelper.func_180182_a((Random)converted.field_70146_Z));
            return converted;
        }
    }
}

