/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.villages;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.entity.factions.IFaction;
import de.teamlapen.vampirism.api.entity.factions.IFactionEntity;
import de.teamlapen.vampirism.api.world.IVampirismVillage;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.world.villages.VampirismVillageDefaultImpl;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.village.Village;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;

public class VampirismVillage
implements IVampirismVillage {
    @CapabilityInject(value=IVampirismVillage.class)
    @Nonnull
    public static final Capability<IVampirismVillage> CAP = (Capability)UtilLib.getNull();
    @Nonnull
    private final Village village;
    private final List<VillageAggressor> villageAggressors = new ArrayList<VillageAggressor>();
    private IFaction controllingFaction;
    private boolean underAttack;
    @Nullable
    private BlockPos totemLocation;
    private int tickCounter;

    public static VampirismVillage get(Village v) {
        return (VampirismVillage)v.getCapability(CAP, null);
    }

    public static void registerCapability() {
        CapabilityManager.INSTANCE.register(IVampirismVillage.class, (Capability.IStorage)new Storage(), VampirismVillageDefaultImpl::new);
    }

    public static ICapabilityProvider createNewCapability(final @Nonnull Village village) {
        return new ICapabilitySerializable<NBTTagCompound>(){
            IVampirismVillage inst;
            {
                this.inst = new VampirismVillage(village);
            }

            public void deserializeNBT(NBTTagCompound nbt) {
                CAP.getStorage().readNBT(CAP, (Object)this.inst, null, (NBTBase)nbt);
            }

            @Nullable
            public <T> T getCapability(@Nonnull Capability<T> capability, @Nullable EnumFacing facing) {
                return (T)(CAP.equals(capability) ? CAP.cast((Object)this.inst) : null);
            }

            public boolean hasCapability(@Nonnull Capability<?> capability, @Nullable EnumFacing facing) {
                return CAP.equals(capability);
            }

            public NBTTagCompound serializeNBT() {
                return (NBTTagCompound)CAP.getStorage().writeNBT(CAP, (Object)this.inst, null);
            }
        };
    }

    public VampirismVillage(@Nonnull Village village) {
        this.village = village;
    }

    @Override
    @Nullable
    public IFaction getControllingFaction() {
        return this.controllingFaction;
    }

    @Override
    @Nonnull
    public Village getVillage() {
        return this.village;
    }

    @Nullable
    public BlockPos getTotemLocation() {
        return this.totemLocation;
    }

    public void registerTotem(BlockPos pos) {
        this.totemLocation = pos;
    }

    public void removeTotemAndReset(@Nonnull BlockPos pos) {
        if (pos.equals((Object)this.totemLocation)) {
            this.totemLocation = null;
            this.controllingFaction = null;
            this.underAttack = false;
        }
    }

    public void setUnderAttack(boolean attack) {
        this.underAttack = attack;
    }

    public void readFromNBT(NBTTagCompound nbt) {
    }

    @Override
    public void addOrRenewAggressor(@Nullable Entity entity) {
        IFactionEntity factionEntity = null;
        if (entity instanceof IFactionEntity) {
            factionEntity = (IFactionEntity)entity;
        } else if (entity instanceof EntityPlayer) {
            factionEntity = FactionPlayerHandler.get((EntityPlayer)entity).getCurrentFactionPlayer();
        }
        if (factionEntity == null || factionEntity.getFaction() == this.controllingFaction) {
            return;
        }
        for (VillageAggressor aggressor : this.villageAggressors) {
            if (!aggressor.factionEntity.equals(factionEntity)) continue;
            aggressor.aggressionTime = this.tickCounter;
            return;
        }
        this.villageAggressors.add(new VillageAggressor(factionEntity, this.tickCounter));
    }

    @Override
    @Nullable
    public IFactionEntity findNearestVillageAggressor(@Nonnull EntityLivingBase entity) {
        double d0 = Double.MAX_VALUE;
        VillageAggressor nearestAggressor = null;
        for (VillageAggressor aggressor : this.villageAggressors) {
            double d1 = aggressor.creature.func_70068_e((Entity)entity);
            if (!(d1 <= d0)) continue;
            nearestAggressor = aggressor;
            d0 = d1;
        }
        return nearestAggressor != null ? nearestAggressor.factionEntity : null;
    }

    public void setControllingFaction(IFaction faction) {
        if (faction != null && faction != this.controllingFaction) {
            this.villageAggressors.clear();
        }
        this.controllingFaction = faction;
    }

    public void tick(long worldTime) {
        IBlockState state;
        this.tickCounter = (int)worldTime;
        if (this.totemLocation != null && this.village.field_75586_a.func_82737_E() % 1024L == 0L && !(state = this.village.field_75586_a.func_180495_p(this.totemLocation)).func_177230_c().equals((Object)ModBlocks.totem_top)) {
            this.removeTotemAndReset(this.totemLocation);
        }
        if (worldTime % 20L == 14L) {
            this.removeDeadAndOldAggressors();
        }
    }

    private void removeDeadAndOldAggressors() {
        this.villageAggressors.removeIf(aggressorVampire -> !aggressorVampire.creature.func_70089_S() || Math.abs(this.tickCounter - aggressorVampire.aggressionTime) > 600);
    }

    public void writeToNBT(NBTTagCompound nbt) {
    }

    private class VillageAggressor {
        public final EntityLivingBase creature;
        public final IFactionEntity factionEntity;
        public int aggressionTime;

        private VillageAggressor(IFactionEntity factionEntity, int initialAggressionTime) {
            this.factionEntity = factionEntity;
            this.creature = factionEntity.getRepresentingEntity();
            this.aggressionTime = initialAggressionTime;
        }
    }

    private static class Storage
    implements Capability.IStorage<IVampirismVillage> {
        private Storage() {
        }

        public void readNBT(Capability<IVampirismVillage> capability, IVampirismVillage instance, EnumFacing side, NBTBase nbt) {
            ((VampirismVillage)instance).readFromNBT((NBTTagCompound)nbt);
        }

        public NBTBase writeNBT(Capability<IVampirismVillage> capability, IVampirismVillage instance, EnumFacing side) {
            NBTTagCompound nbt = new NBTTagCompound();
            ((VampirismVillage)instance).writeToNBT(nbt);
            return nbt;
        }
    }
}

