/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import de.teamlapen.vampirism.api.difficulty.IAdjustableLevel;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

public class SetMetaBasedOnLevel
extends LootFunction {
    private final int max;

    protected SetMetaBasedOnLevel(LootCondition[] conditionsIn, int max) {
        super(conditionsIn);
        this.max = max;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        Entity e = context.func_186493_a();
        if (e instanceof IAdjustableLevel) {
            int l = ((IAdjustableLevel)e).getLevel();
            if (this.max != -1) {
                l = Math.min(this.max, l);
            }
            stack.func_77964_b(l);
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetMetaBasedOnLevel> {
        protected Serializer() {
            super(new ResourceLocation("vampirism", "set_meta_from_level"), SetMetaBasedOnLevel.class);
        }

        public SetMetaBasedOnLevel deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            return new SetMetaBasedOnLevel(conditionsIn, object.has("max") ? JsonUtils.func_151203_m((JsonObject)object, (String)"max") : -1);
        }

        public void serialize(JsonObject object, SetMetaBasedOnLevel functionClazz, JsonSerializationContext serializationContext) {
            if (functionClazz.max != -1) {
                object.addProperty("max", (Number)functionClazz.max);
            }
        }
    }
}

