/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world.loot;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSyntaxException;
import de.teamlapen.vampirism.api.items.IBloodChargeable;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootContext;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;

class SetItemBloodCharge
extends LootFunction {
    private final int charge;
    private final int minCharge;
    private final int maxCharge;

    private SetItemBloodCharge(LootCondition[] conditionsIn, int charge, int minCharge, int maxCharge) {
        super(conditionsIn);
        this.charge = charge;
        this.minCharge = minCharge;
        this.maxCharge = maxCharge;
    }

    public ItemStack func_186553_a(ItemStack stack, Random rand, LootContext context) {
        if (this.charge > 0) {
            ((IBloodChargeable)stack.func_77973_b()).charge(stack, this.charge);
        } else {
            ((IBloodChargeable)stack.func_77973_b()).charge(stack, this.minCharge + rand.nextInt(this.maxCharge - this.minCharge));
        }
        return stack;
    }

    public static class Serializer
    extends LootFunction.Serializer<SetItemBloodCharge> {
        protected Serializer() {
            super(new ResourceLocation("vampirism", "set_item_blood_charge"), SetItemBloodCharge.class);
        }

        public SetItemBloodCharge deserialize(JsonObject object, JsonDeserializationContext deserializationContext, LootCondition[] conditionsIn) {
            if (object.has("charge")) {
                int value = JsonUtils.func_151203_m((JsonObject)object, (String)"charge");
                return new SetItemBloodCharge(conditionsIn, Math.max(0, value), -1, -1);
            }
            if (object.has("min_charge") && object.has("max_charge")) {
                int l = JsonUtils.func_151203_m((JsonObject)object, (String)"min_charge");
                int u = JsonUtils.func_151203_m((JsonObject)object, (String)"max_charge");
                return new SetItemBloodCharge(conditionsIn, -1, Math.max(0, l), Math.max(0, u));
            }
            throw new JsonSyntaxException("Need charge property for vampirism:set_item_blood_charge");
        }

        public void serialize(JsonObject object, SetItemBloodCharge functionClazz, JsonSerializationContext serializationContext) {
            if (functionClazz.charge != -1) {
                object.addProperty("charge", (Number)functionClazz.charge);
            } else {
                object.addProperty("min_charge", (Number)functionClazz.minCharge);
                object.addProperty("max_charge", (Number)functionClazz.maxCharge);
            }
        }
    }
}

