/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.world;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;
import net.minecraft.world.storage.WorldSavedData;

public class VampirismWorldData
extends WorldSavedData {
    private static final String IDENTIFIER = "vampirism";
    private final List<BlockPos> vampireDungeons = Lists.newLinkedList();
    private World world;

    @Nonnull
    public static VampirismWorldData get(@Nonnull World world) {
        String s = VampirismWorldData.fileNameForProvider(world.field_73011_w);
        VampirismWorldData data = (VampirismWorldData)world.getPerWorldStorage().func_75742_a(VampirismWorldData.class, s);
        if (data == null) {
            data = new VampirismWorldData(world);
            world.getPerWorldStorage().func_75745_a(s, (WorldSavedData)data);
        } else {
            data.world = world;
        }
        return data;
    }

    private static String fileNameForProvider(WorldProvider provider) {
        return IDENTIFIER + provider.func_186058_p().func_186067_c();
    }

    public VampirismWorldData(String name) {
        super(name);
    }

    private VampirismWorldData(World world) {
        this(VampirismWorldData.fileNameForProvider(world.field_73011_w));
        this.world = world;
        this.func_76185_a();
    }

    public void addNewVampireDungeon(@Nonnull BlockPos pos) {
        this.vampireDungeons.add(pos);
        this.func_76185_a();
    }

    @Nullable
    public BlockPos getRandomVampireDungeon(Random rng) {
        return this.vampireDungeons.size() == 0 ? null : this.vampireDungeons.get(rng.nextInt(this.vampireDungeons.size()));
    }

    public void onAltarInspirationDestroyed(BlockPos pos) {
        if (this.vampireDungeons.remove(pos)) {
            this.func_76185_a();
        }
    }

    public void func_76184_a(NBTTagCompound nbt) {
        if (nbt.func_74764_b("vampire_dungeons")) {
            this.vampireDungeons.clear();
            NBTTagList dungeons = nbt.func_150295_c("vampire_dungeons", 10);
            for (int i = 0; i < dungeons.func_74745_c(); ++i) {
                NBTTagCompound tag = dungeons.func_150305_b(i);
                this.vampireDungeons.add(NBTUtil.func_186861_c((NBTTagCompound)tag));
            }
        }
    }

    public NBTTagCompound func_189551_b(NBTTagCompound compound) {
        NBTTagList dungeons = new NBTTagList();
        for (BlockPos pos : this.vampireDungeons) {
            dungeons.func_74742_a((NBTBase)NBTUtil.func_186859_a((BlockPos)pos));
        }
        compound.func_74782_a("vampire_dungeons", (NBTBase)dungeons);
        return compound;
    }
}

