/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.util;

import de.teamlapen.lib.VampLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModParticles;
import de.teamlapen.vampirism.entity.special.EntityDraculaHalloween;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class HalloweenSpecial {
    private static boolean enabled = false;
    private static int render_overlay;
    private List<UUID> blacklist = new ArrayList<UUID>();
    private int tickTimer = 0;

    public static boolean isEnabled() {
        return enabled;
    }

    public static boolean shouldEnable() {
        if (Configs.disable_halloween_special) {
            return false;
        }
        int day = Calendar.getInstance().get(5);
        int month = Calendar.getInstance().get(2);
        return day == 31 && month == 9;
    }

    public static void enable() {
        enabled = true;
        VampirismMod.log.i("Halloween", "It's Halloween", new Object[0]);
    }

    public static boolean shouldRenderOverlay() {
        return render_overlay > 0;
    }

    public static void triggerOverlay(EntityPlayer target) {
        render_overlay = 150;
        VampLib.proxy.getParticleHandler().spawnParticle(target.func_130014_f_(), ModParticles.HALLOWEEN, target.field_70165_t, target.field_70163_u, target.field_70161_v, new Object[0]);
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        int time;
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (render_overlay > 0) {
            --render_overlay;
        } else if (Minecraft.func_71410_x().field_71441_e != null && (time = (int)Minecraft.func_71410_x().field_71441_e.func_72820_D()) > 13000 && time < 13100) {
            HalloweenSpecial.triggerOverlay((EntityPlayer)Minecraft.func_71410_x().field_71439_g);
        }
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        if (enabled) {
            ++this.tickTimer;
            if (this.tickTimer % 200 == 99) {
                for (EntityPlayerMP p : FMLCommonHandler.instance().getMinecraftServerInstance().func_184102_h().func_184103_al().func_181057_v()) {
                    UUID u = p.func_110124_au();
                    if (this.blacklist.contains(u)) continue;
                    EntityDraculaHalloween draculaHalloween = new EntityDraculaHalloween(p.func_130014_f_());
                    draculaHalloween.setOwnerId(u);
                    draculaHalloween.makeHide(200 + p.func_70681_au().nextInt(1000));
                    p.func_130014_f_().func_72838_d((Entity)draculaHalloween);
                    this.blacklist.add(u);
                }
                this.tickTimer = 0;
            }
        }
    }

    @SubscribeEvent
    public void onSleepInBed(PlayerSleepInBedEvent event) {
        if (enabled) {
            event.setResult(EntityPlayer.SleepResult.NOT_POSSIBLE_NOW);
            event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentString("You cannot sleep on Halloween!"), false);
        }
    }

    @SubscribeEvent
    public void onWorldUnload(WorldEvent.Unload event) {
        this.blacklist.clear();
    }
}

