/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.page.PageBrewingRecipe;
import amerifrance.guideapi.page.PageFurnaceRecipe;
import amerifrance.guideapi.page.PageIRecipe;
import amerifrance.guideapi.page.PageItemStack;
import amerifrance.guideapi.page.PageText;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IAlchemicalCauldronRecipe;
import de.teamlapen.vampirism.api.items.IHunterWeaponRecipe;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.inventory.AlchemicalCauldronCraftingManager;
import de.teamlapen.vampirism.inventory.HunterWeaponCraftingManager;
import de.teamlapen.vampirism.inventory.ShapedHunterWeaponRecipe;
import de.teamlapen.vampirism.inventory.ShapelessHunterWeaponRecipe;
import de.teamlapen.vampirism.modcompat.guide.ItemInfoBuilder;
import de.teamlapen.vampirism.modcompat.guide.pages.AlchemicalCauldronRecipePage;
import de.teamlapen.vampirism.modcompat.guide.pages.BasicWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.pages.PageHolderWithLinks;
import de.teamlapen.vampirism.modcompat.guide.pages.PageRecipe;
import de.teamlapen.vampirism.modcompat.guide.pages.ShapedWeaponTableRecipeRenderer;
import de.teamlapen.vampirism.modcompat.guide.pages.ShapelessWeaponTableRecipeRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import org.apache.commons.lang3.StringUtils;

public class GuideHelper {
    public static String append(String ... unlocalized) {
        StringBuilder s = new StringBuilder();
        for (String u : unlocalized) {
            s.append(UtilLib.translate(u)).append("\n\n");
        }
        return s.toString();
    }

    public static List<IPage> addLinks(List<IPage> pages, Object ... links) {
        ArrayList linkPages = Lists.newArrayList();
        for (IPage p : pages) {
            linkPages.add(new PageHolderWithLinks(p));
        }
        for (Object l : links) {
            if (l instanceof ResourceLocation) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((ResourceLocation)l);
                }
                continue;
            }
            if (l instanceof EntryAbstract) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((EntryAbstract)l);
                }
                continue;
            }
            if (l instanceof PageHolderWithLinks.URLLink) {
                for (PageHolderWithLinks p : linkPages) {
                    p.addLink((PageHolderWithLinks.URLLink)l);
                }
                continue;
            }
            VampirismMod.log.w("GuideHelper", "Given link object cannot be linked %s", l);
        }
        pages.clear();
        pages.addAll(linkPages);
        return pages;
    }

    public static IRecipe getRecipeForOutput(ItemStack stack) {
        for (IRecipe recipe : ForgeRegistries.RECIPES) {
            if (!GuideHelper.checkRecipeOutput(recipe, stack, true)) continue;
            return recipe;
        }
        return null;
    }

    public static IAlchemicalCauldronRecipe getAlchemicalCauldronRecipeForOutput(ItemStack stack) {
        for (IAlchemicalCauldronRecipe recipe : AlchemicalCauldronCraftingManager.getInstance().getRecipes()) {
            if (!GuideHelper.checkOutput(recipe.getOutput(), stack, true)) continue;
            return recipe;
        }
        return null;
    }

    public static IHunterWeaponRecipe getWeaponTableRecipeForOutput(ItemStack stack) {
        for (IHunterWeaponRecipe recipe : HunterWeaponCraftingManager.getInstance().getRecipes()) {
            if (!GuideHelper.checkRecipeOutput(recipe, stack, true)) continue;
            return recipe;
        }
        return null;
    }

    public static ItemStack getFurnaceRecipe(ItemStack stack) {
        for (Map.Entry e : FurnaceRecipes.func_77602_a().func_77599_b().entrySet()) {
            if (!stack.func_77969_a((ItemStack)e.getValue())) continue;
            return (ItemStack)e.getKey();
        }
        return null;
    }

    public static BrewingRecipe getBrewingRecipe(ItemStack stack) {
        return BrewingRecipeRegistry.getRecipes().stream().filter(iBrewingRecipe -> iBrewingRecipe instanceof BrewingRecipe && ItemStack.func_77989_b((ItemStack)((BrewingRecipe)iBrewingRecipe).getOutput(), (ItemStack)stack)).findFirst().orElse(null);
    }

    private static boolean checkRecipeOutput(IRecipe recipe, ItemStack stack, boolean checkNBT) {
        if (recipe != null) {
            ItemStack resultStack = recipe.func_77571_b();
            return GuideHelper.checkOutput(resultStack, stack, checkNBT);
        }
        return false;
    }

    private static boolean checkRecipeOutput(IHunterWeaponRecipe recipe, ItemStack stack, boolean checkNBT) {
        if (recipe != null) {
            ItemStack resultStack = recipe.getRecipeOutput();
            return GuideHelper.checkOutput(resultStack, stack, checkNBT);
        }
        return false;
    }

    private static boolean checkOutput(ItemStack resultStack, ItemStack stack, boolean checkNBT) {
        return !stack.func_190926_b() && !resultStack.func_190926_b() && resultStack.func_77973_b() == stack.func_77973_b() && resultStack.func_77952_i() == stack.func_77952_i() && (!checkNBT || resultStack.func_77978_p() == null && stack.func_77978_p() == null || resultStack.func_77978_p() != null && resultStack.func_77978_p().equals((Object)stack.func_77978_p()));
    }

    @Nullable
    public static IPage getRecipePage(ItemStack stack, RECIPE_TYPE type) {
        try {
            switch (type) {
                case WORKBENCH: {
                    IRecipe r = (IRecipe)Preconditions.checkNotNull((Object)GuideHelper.getRecipeForOutput(stack));
                    return new PageIRecipe(r);
                }
                case FURNACE: {
                    ItemStack s = (ItemStack)Preconditions.checkNotNull((Object)GuideHelper.getFurnaceRecipe(stack));
                    return new PageFurnaceRecipe(s);
                }
                case BREWING_STAND: {
                    BrewingRecipe b = (BrewingRecipe)Preconditions.checkNotNull((Object)GuideHelper.getBrewingRecipe(stack));
                    return new PageBrewingRecipe(b);
                }
                case WEAPON_TABLE: {
                    IHunterWeaponRecipe r2 = (IHunterWeaponRecipe)Preconditions.checkNotNull((Object)GuideHelper.getWeaponTableRecipeForOutput(stack));
                    BasicWeaponTableRecipeRenderer renderer = null;
                    if (r2 instanceof ShapedHunterWeaponRecipe) {
                        renderer = new ShapedWeaponTableRecipeRenderer((ShapedHunterWeaponRecipe)r2);
                    } else if (r2 instanceof ShapelessHunterWeaponRecipe) {
                        renderer = new ShapelessWeaponTableRecipeRenderer((ShapelessHunterWeaponRecipe)r2);
                    }
                    Preconditions.checkNotNull(renderer);
                    return new PageRecipe<IHunterWeaponRecipe>(r2, renderer);
                }
                case ALCHEMICAL_CAULDRON: {
                    IAlchemicalCauldronRecipe r3 = (IAlchemicalCauldronRecipe)Preconditions.checkNotNull((Object)GuideHelper.getAlchemicalCauldronRecipeForOutput(stack));
                    return new AlchemicalCauldronRecipePage(r3);
                }
            }
            throw new IllegalArgumentException("Type unknown " + (Object)((Object)type));
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public static void addArmorWithTier(Map<ResourceLocation, EntryAbstract> entries, String name, IItemWithTier helmet, IItemWithTier chest, IItemWithTier legs, IItemWithTier boots, RECIPE_TYPE recipeType) {
        ArrayList<Object> craftable = new ArrayList<Object>();
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            craftable.add(ModItems.createStack(helmet, t));
            craftable.add((Object)RECIPE_TYPE.WEAPON_TABLE);
            craftable.add(ModItems.createStack(chest, t));
            craftable.add((Object)RECIPE_TYPE.WEAPON_TABLE);
            craftable.add(ModItems.createStack(legs, t));
            craftable.add((Object)RECIPE_TYPE.WEAPON_TABLE);
            craftable.add(ModItems.createStack(boots, t));
            craftable.add((Object)RECIPE_TYPE.WEAPON_TABLE);
        }
        ItemInfoBuilder builder = new ItemInfoBuilder(ModItems.createStack(helmet, IItemWithTier.TIER.NORMAL), false);
        builder.setName(name).ignoreMissingRecipes().craftableStacks(craftable).customName();
        builder.build(entries);
    }

    public static ItemInfoBuilder addItemWithTier(IItemWithTier item, RECIPE_TYPE recipeType) {
        ArrayList<Object> craftable = new ArrayList<Object>();
        for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
            craftable.add(ModItems.createStack(item, t));
            craftable.add((Object)recipeType);
        }
        ItemInfoBuilder builder = new ItemInfoBuilder(ModItems.createStack(item, IItemWithTier.TIER.NORMAL), false);
        builder.craftableStacks(craftable).ignoreMissingRecipes();
        return builder;
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack, int pageLength) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        ArrayList<String> lines = new ArrayList<String>(VampLib.proxy.listFormattedStringToWidth(locText, 115));
        ArrayList<String> page1 = lines.size() > pageLength ? lines.subList(0, pageLength) : lines;
        pageList.add((IPage)new PageItemStack(StringUtils.join(page1, (String)"\n"), stack));
        page1.clear();
        pageLength += 5;
        while (lines.size() > 0) {
            ArrayList<String> page = lines.size() > pageLength ? lines.subList(0, pageLength) : lines;
            pageList.add((IPage)new PageText(StringUtils.join(page, (String)"\n")));
            page.clear();
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String locText, ItemStack stack) {
        return GuideHelper.pagesForLongText(locText, stack, 8);
    }

    public static List<IPage> pagesForLongText(String s, int pageLength) {
        ArrayList<IPage> pageList = new ArrayList<IPage>();
        ArrayList<String> lines = new ArrayList<String>(VampLib.proxy.listFormattedStringToWidth(s, 115));
        while (lines.size() > 0) {
            ArrayList<String> page = lines.size() > pageLength ? lines.subList(0, pageLength) : lines;
            pageList.add((IPage)new PageText(StringUtils.join(page, (String)"\n")));
            page.clear();
        }
        return pageList;
    }

    public static List<IPage> pagesForLongText(String s) {
        return GuideHelper.pagesForLongText(s, 13);
    }

    public static enum RECIPE_TYPE {
        WORKBENCH,
        FURNACE,
        WEAPON_TABLE,
        ALCHEMICAL_CAULDRON,
        BREWING_STAND;

    }
}

