/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.modcompat.guide;

import amerifrance.guideapi.api.GuideAPI;
import amerifrance.guideapi.api.IGuideBook;
import amerifrance.guideapi.api.IPage;
import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import amerifrance.guideapi.page.PageImage;
import amerifrance.guideapi.page.PageText;
import amerifrance.guideapi.page.PageTextImage;
import com.google.common.collect.Maps;
import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.blocks.BlockAltarPillar;
import de.teamlapen.vampirism.blocks.BlockGarlicBeacon;
import de.teamlapen.vampirism.client.core.ModKeys;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.items.ItemCrossbowArrow;
import de.teamlapen.vampirism.modcompat.guide.EntryText;
import de.teamlapen.vampirism.modcompat.guide.GuideHelper;
import de.teamlapen.vampirism.modcompat.guide.ItemInfoBuilder;
import de.teamlapen.vampirism.modcompat.guide.pages.PageHolderWithLinks;
import de.teamlapen.vampirism.modcompat.guide.pages.PageTable;
import de.teamlapen.vampirism.player.hunter.HunterLevelingConf;
import de.teamlapen.vampirism.player.hunter.actions.HunterActions;
import de.teamlapen.vampirism.player.vampire.VampireLevelingConf;
import java.awt.Color;
import java.net.URI;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@amerifrance.guideapi.api.GuideBook
public class GuideBook
implements IGuideBook {
    public static final String TAG = "GuideBook";
    private static final String IMAGE_BASE = "vampirismguide:textures/images/";
    private static Book guideBook;
    private static Map<ResourceLocation, EntryAbstract> links;

    static void buildCategories() {
        VampirismMod.log.d(TAG, "Building categories", new Object[0]);
        long start = System.currentTimeMillis();
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildOverview(), "guide.vampirism.overview.title", new ItemStack((Item)ModItems.vampire_fang)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildVampire(), "guide.vampirism.vampire.title", new ItemStack((Item)ModItems.blood_bottle, 1, 9)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildHunter(), "guide.vampirism.hunter.title", new ItemStack((Item)ModItems.human_heart)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildCreatures(), "guide.vampirism.entity.title", new ItemStack(Items.field_151144_bL)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildWorld(), "guide.vampirism.world.title", new ItemStack((Block)ModBlocks.cursed_earth)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildItems(), "guide.vampirism.items.title", new ItemStack(Items.field_151034_e)));
        guideBook.addCategory((CategoryAbstract)new CategoryItemStack(GuideBook.buildBlocks(), "guide.vampirism.blocks.title", new ItemStack((Block)ModBlocks.castle_block)));
        VampirismMod.log.d(TAG, "Finished building categories after %d ms", System.currentTimeMillis() - start);
    }

    @Nullable
    public static EntryAbstract getLinkedEntry(ResourceLocation location) {
        return links.get(location);
    }

    private static Map<ResourceLocation, EntryAbstract> buildOverview() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.overview.";
        ArrayList<IPage> introPages = new ArrayList<IPage>();
        introPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "intro.text")));
        PageHelper.setPagesToUnicode(introPages);
        entries.put(new ResourceLocation(base + "intro"), (EntryAbstract)new EntryText(introPages, UtilLib.translate(base + "intro")));
        ArrayList<IPage> gettingStartedPages = new ArrayList<IPage>();
        Object p = new PageText(UtilLib.translate(base + "getting_started.text"));
        p = new PageHolderWithLinks((IPage)p).addLink("guide.vampirism.vampire.getting_started").addLink("guide.vampirism.hunter.getting_started");
        gettingStartedPages.add((IPage)p);
        PageHelper.setPagesToUnicode(gettingStartedPages);
        entries.put(new ResourceLocation(base + "gettingStarted"), (EntryAbstract)new EntryText(gettingStartedPages, UtilLib.translate(base + "getting_started")));
        ArrayList<IPage> configPages = new ArrayList<IPage>();
        configPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "config.text")));
        configPages.addAll(GuideHelper.pagesForLongText(GuideHelper.append(base + "config.general.text", base + "config.general.examples")));
        configPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "config.balance.text")));
        PageHelper.setPagesToUnicode(configPages);
        entries.put(new ResourceLocation(base + "config"), (EntryAbstract)new EntryText(configPages, UtilLib.translate(base + "config")));
        ArrayList<IPage> troublePages = new ArrayList<IPage>();
        troublePages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "trouble.text")));
        PageHelper.setPagesToUnicode(troublePages);
        GuideHelper.addLinks(troublePages, new PageHolderWithLinks.URLLink(UtilLib.translate(base + "trouble"), URI.create("https://github.com/TeamLapen/Vampirism/wiki/Troubleshooting")));
        entries.put(new ResourceLocation(base + "trouble"), (EntryAbstract)new EntryText(troublePages, UtilLib.translate(base + "trouble")));
        ArrayList<IPage> devPages = new ArrayList<IPage>();
        PageHolderWithLinks.URLLink helpLink = new PageHolderWithLinks.URLLink("How to help", URI.create("https://github.com/TeamLapen/Vampirism/wiki#how-you-can-help"));
        devPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(UtilLib.translate(base + "dev.text")), helpLink));
        PageHelper.setPagesToUnicode(devPages);
        entries.put(new ResourceLocation(base + "dev"), (EntryAbstract)new EntryText(devPages, UtilLib.translate(base + "dev")));
        ArrayList<IPage> supportPages = new ArrayList<IPage>();
        supportPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "support.text")));
        PageHolderWithLinks.URLLink linkPatreon = new PageHolderWithLinks.URLLink("Patreon", URI.create("https://www.patreon.com/maxanier"));
        PageHolderWithLinks.URLLink linkCurseForge = new PageHolderWithLinks.URLLink("CurseForge", URI.create("https://minecraft.curseforge.com/projects/vampirism-become-a-vampire"));
        GuideHelper.addLinks(supportPages, linkPatreon, linkCurseForge, new ResourceLocation(base + "dev"));
        PageHelper.setPagesToUnicode(supportPages);
        entries.put(new ResourceLocation(base + "support"), (EntryAbstract)new EntryText(supportPages, UtilLib.translate(base + "support")));
        ArrayList<IPage> creditsPages = new ArrayList<IPage>();
        String lang = VampLib.proxy.getActiveLanguage();
        String credits = "\u00a7lDeveloper:\u00a7r\nMaxanier\n\n\u00a7lInactive Developer:\u00a7r\nMistadon\nwildbill22\n\n\u00a7lTranslators:\u00a7r\n\u00a7b" + lang + "\u00a7r\n" + UtilLib.translate("text.vampirism.translators");
        creditsPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(credits)));
        entries.put(new ResourceLocation(base + "credits"), (EntryAbstract)new EntryText(creditsPages, UtilLib.translate(base + "credits")));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildVampire() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.vampire.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "getting_started.become")));
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "getting_started.as_vampire")));
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "getting_started.zombie")));
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "getting_started.blood", ModKeys.getKeyBinding(ModKeys.KEY.SUCK).getDisplayName())));
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "getting_started.level") + "\n" + UtilLib.translate(base + "getting_started.level2")));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, UtilLib.translate(base + "getting_started")));
        ArrayList<IPage> bloodPages = new ArrayList<IPage>();
        bloodPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "blood.text", UtilLib.translate(ModItems.blood_bottle.func_77658_a() + ".name"), UtilLib.translate(Items.field_151069_bo.func_77658_a() + ".name"))));
        bloodPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "blood.storage", ModBlocks.blood_container.func_149732_F())), new ResourceLocation("guide.vampirism.blocks.blood_container")));
        bloodPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(UtilLib.translate(base + "blood.biteable_creatures")), new PageHolderWithLinks.URLLink("Biteable Creatures", URI.create("https://github.com/TeamLapen/Vampirism/wiki/Biteable-Creatures"))));
        entries.put(new ResourceLocation(base + "blood"), (EntryAbstract)new EntryText(bloodPages, UtilLib.translate(base + "blood")));
        VampireLevelingConf levelingConf = VampireLevelingConf.getInstance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "leveling.intro")));
        String altarOfInspiration = "\u00a7l" + ModBlocks.altar_inspiration.func_149732_F() + "\u00a7r\n\u00a7o" + UtilLib.translate(base + "leveling.inspiration.reach") + "\u00a7r\n";
        altarOfInspiration = altarOfInspiration + UtilLib.translate(base + "leveling.inspiration.text") + "\n";
        altarOfInspiration = altarOfInspiration + UtilLib.translateFormatted(base + "leveling.inspiration.requirements", levelingConf.getRequiredBloodForAltarInspiration(2), levelingConf.getRequiredBloodForAltarInspiration(3), levelingConf.getRequiredBloodForAltarInspiration(4));
        levelingPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(altarOfInspiration), new ResourceLocation("guide.vampirism.blocks.altar_inspiration")));
        String altarOfInfusion = "\u00a7l" + ModBlocks.altar_infusion.func_149732_F() + "\u00a7r\n\u00a7o" + UtilLib.translate(base + "leveling.infusion.reach") + "\u00a7r\n";
        altarOfInfusion = altarOfInfusion + UtilLib.translateFormatted(base + "leveling.infusion.intro", ModBlocks.altar_infusion.func_149732_F(), ModBlocks.altar_pillar.func_149732_F(), ModBlocks.altar_tip.func_149732_F());
        levelingPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(altarOfInfusion), new ResourceLocation("guide.vampirism.blocks.altar_infusion")));
        StringBuilder blocks = new StringBuilder();
        for (BlockAltarPillar.EnumPillarType t : BlockAltarPillar.EnumPillarType.values()) {
            if (t == BlockAltarPillar.EnumPillarType.NONE) continue;
            blocks.append(t.fillerBlock.func_149732_F()).append("(").append(t.getValue()).append("),");
        }
        levelingPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "leveling.infusion.structure", blocks.toString())));
        String items = UtilLib.translate(ModItems.human_heart.func_77658_a() + ".name") + ", " + UtilLib.translate(ModItems.pure_blood.func_77658_a() + ".name") + ", " + UtilLib.translate(ModItems.vampire_book.func_77658_a() + ".name");
        levelingPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "leveling.infusion.items", items)), new ResourceLocation("guide.vampirism.items.human_heart"), new ResourceLocation("guide.vampirism.items.pure_blood"), new ResourceLocation("guide.vampirism.items.vampire_book")));
        PageTable.Builder requirementsBuilder = new PageTable.Builder(5);
        requirementsBuilder.addUnlocLine("text.vampirism.level", base + "leveling.infusion.req.structure_points", ModItems.pure_blood.func_77658_a() + ".name", base + "leveling.infusion.req.heart", base + "leveling.infusion.req.book");
        requirementsBuilder.addLine("5", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(5), "0", "5", "1");
        requirementsBuilder.addLine("6", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(6), "1 Purity(1)", "5", "1");
        requirementsBuilder.addLine("7", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(7), "1 Purity(1)", "10", "1");
        requirementsBuilder.addLine("8", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(8), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("9", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(9), "1 Purity(2)", "10", "1");
        requirementsBuilder.addLine("10", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(10), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("11", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(11), "1 Purity(3)", "15", "1");
        requirementsBuilder.addLine("12", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(12), "1 Purity(4)", "20", "1");
        requirementsBuilder.addLine("13", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(13), "2 Purity(4)", "20", "1");
        requirementsBuilder.addLine("14", VampireLevelingConf.getInstance().getRequiredStructureLevelAltarInfusion(14), "2 Purity(5)", "25", "1");
        requirementsBuilder.setHeadline(UtilLib.translate(base + "leveling.infusion.req"));
        PageHolderWithLinks requirementTable = new PageHolderWithLinks((IPage)requirementsBuilder.build());
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.human_heart"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        requirementTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood"));
        levelingPages.add(requirementTable);
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image1"), new ResourceLocation("vampirismguide:textures/images/infusion1.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image2"), new ResourceLocation("vampirismguide:textures/images/infusion2.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image3"), new ResourceLocation("vampirismguide:textures/images/infusion3.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image4"), new ResourceLocation("vampirismguide:textures/images/infusion4.png"), false));
        levelingPages.add((IPage)new PageTextImage(UtilLib.translate(base + "leveling.infusion.image5"), new ResourceLocation("vampirismguide:textures/images/infusion5.png"), false));
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, base + "leveling"));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "skills.text", ModKeys.getKeyBinding(ModKeys.KEY.SKILL).getDisplayName())));
        skillPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "skills.actions", ModKeys.getKeyBinding(ModKeys.KEY.ACTION).getDisplayName())));
        skillPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate("guide.vampirism.skills.bind_action")));
        skillPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "skills.actions2")));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, base + "skills"));
        ArrayList<IPage> unvampirePages = new ArrayList<IPage>();
        unvampirePages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "unvampire.text", ModBlocks.church_altar.func_149732_F())));
        entries.put(new ResourceLocation(base + "unvampire"), (EntryAbstract)new EntryText(unvampirePages, base + "unvampire"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildHunter() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.hunter.";
        ArrayList<IPage> gettingStarted = new ArrayList<IPage>();
        String become = UtilLib.translateFormatted(base + "getting_started.become", UtilLib.translate("entity.hunter_trainer.name"), new ItemStack((Item)ModItems.injection, 1, 1).func_82833_r());
        gettingStarted.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(become), new ResourceLocation("guide.vampirism.items.injection")));
        gettingStarted.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter_trainer.png")));
        gettingStarted.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "getting_started.as_hunter")));
        entries.put(new ResourceLocation(base + "getting_started"), (EntryAbstract)new EntryText(gettingStarted, base + "getting_started"));
        HunterLevelingConf levelingConf = HunterLevelingConf.instance();
        ArrayList<IPage> levelingPages = new ArrayList<IPage>();
        levelingPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "leveling.intro")));
        String train1 = "\u00a7l" + UtilLib.translateFormatted(base + "leveling.to_reach", "2-4") + "\u00a7r\n";
        train1 = train1 + UtilLib.translateFormatted(base + "leveling.train1.text", levelingConf.getVampireBloodCountForBasicHunter(2), levelingConf.getVampireBloodCountForBasicHunter(3), levelingConf.getVampireBloodCountForBasicHunter(4));
        levelingPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(train1), new ResourceLocation("guide.vampirism.items.stake"), new ResourceLocation("guide.vampirism.items.vampire_blood_bottle")));
        String train2 = "\u00a7l" + UtilLib.translateFormatted(base + "leveling.to_reach", "5+") + "\u00a7r\n";
        train2 = train2 + UtilLib.translateFormatted(base + "leveling.train2.text", ModBlocks.hunter_table.func_149732_F());
        levelingPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(train2), new ResourceLocation("guide.vampirism.blocks.hunter_table")));
        PageTable.Builder builder = new PageTable.Builder(4);
        builder.addUnlocLine("text.vampirism.level", base + "leveling.train2.fang", ModItems.pure_blood.getLocalizedName(), ModItems.vampire_book.getLocalizedName());
        for (int i = levelingConf.TABLE_MIN_LEVEL; i <= levelingConf.TABLE_MAX_LEVEL - 1; ++i) {
            int[] req = levelingConf.getItemRequirementsForTable(i);
            String pure = "";
            if (req[1] > 0) {
                pure = "" + req[1] + " Purity(" + (req[2] + 1) + ")";
            }
            builder.addLine(i, req[0], pure, req[3]);
        }
        builder.setHeadline(UtilLib.translate(base + "leveling.train2.req"));
        PageHolderWithLinks requirementsTable = new PageHolderWithLinks((IPage)builder.build());
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_fang"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.pure_blood"));
        requirementsTable.addLink(new ResourceLocation("guide.vampirism.items.vampire_book"));
        levelingPages.add(requirementsTable);
        entries.put(new ResourceLocation(base + "leveling"), (EntryAbstract)new EntryText(levelingPages, base + "leveling"));
        ArrayList<IPage> skillPages = new ArrayList<IPage>();
        skillPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "skills.intro", ModKeys.getKeyBinding(ModKeys.KEY.SKILL).getDisplayName())));
        String disguise = String.format("\u00a7l%s\u00a7r\n", UtilLib.translate(HunterActions.disguise_hunter.getUnlocalizedName()));
        disguise = disguise + UtilLib.translateFormatted(base + "skills.disguise.text", ModKeys.getKeyBinding(ModKeys.KEY.ACTION).getDisplayName());
        skillPages.addAll(GuideHelper.pagesForLongText(disguise));
        String bloodPotion = String.format("\u00a7l%s\u00a7r\n", ModBlocks.blood_potion_table.func_149732_F());
        bloodPotion = bloodPotion + UtilLib.translateFormatted(base + "skills.blood_potion.text", ModKeys.getKeyBinding(ModKeys.KEY.BLOOD_POTION).getDisplayName());
        skillPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(bloodPotion), new ResourceLocation("guide.vampirism.blocks.blood_potion_table")));
        String weaponTable = String.format("\u00a7l%s\u00a7r\n", ModBlocks.weapon_table.func_149732_F());
        weaponTable = weaponTable + UtilLib.translate(base + "skills.weapon_table.text");
        skillPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(weaponTable), new ResourceLocation("guide.vampirism.blocks.weapon_table")));
        entries.put(new ResourceLocation(base + "skills"), (EntryAbstract)new EntryText(skillPages, base + "skills"));
        ArrayList<IPage> vampSlayerPages = new ArrayList<IPage>();
        vampSlayerPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "vamp_slayer.intro")));
        String garlic = String.format("\u00a7l%s\u00a7r\n", ModItems.item_garlic.getLocalizedName());
        garlic = garlic + UtilLib.translate(base + "vamp_slayer.garlic") + "\n" + UtilLib.translate(base + "vamp_slayer.garlic2") + "\n" + UtilLib.translate(base + "vamp_slayer.garlic.diffusor");
        vampSlayerPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(garlic), new ResourceLocation("guide.vampirism.blocks.garlic_beacon")));
        String holyWater = String.format("\u00a7l%s\u00a7r\n", ModItems.holy_water_bottle.getLocalizedName());
        holyWater = holyWater + UtilLib.translate(base + "vamp_slayer.holy_water");
        vampSlayerPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(holyWater), new ResourceLocation("guide.vampirism.items.holy_water_bottle")));
        String fire = String.format("\u00a7l%s\u00a7r\n", Blocks.field_150480_ab.func_149732_F());
        fire = fire + UtilLib.translate(base + "vamp_slayer.fire");
        vampSlayerPages.addAll(GuideHelper.addLinks(GuideHelper.pagesForLongText(fire), new ResourceLocation("guide.vampirism.items.item_alchemical_fire"), new ResourceLocation("guide.vampirism.items.crossbow_arrow")));
        entries.put(new ResourceLocation(base + "vamp_slayer"), (EntryAbstract)new EntryText(vampSlayerPages, base + "vamp_slayer"));
        ArrayList<IPage> unHunterPages = new ArrayList<IPage>();
        unHunterPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "unhunter.text", new ItemStack((Item)ModItems.injection, 1, 2).func_82833_r())));
        entries.put(new ResourceLocation(base + "unhunter"), (EntryAbstract)new EntryText(unHunterPages, base + "unhunter"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildCreatures() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.entity.";
        ArrayList<IPage> generalPages = new ArrayList<IPage>(GuideHelper.pagesForLongText(UtilLib.translate(base + "general.text") + "\n" + UtilLib.translate(base + "general.text2")));
        entries.put(new ResourceLocation(base + "general"), (EntryAbstract)new EntryText(generalPages, base + "general"));
        ArrayList<IPage> hunterPages = new ArrayList<IPage>();
        hunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/hunter.png")));
        hunterPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "hunter.text", ModItems.human_heart.getLocalizedName())));
        entries.put(new ResourceLocation(base + "hunter"), (EntryAbstract)new EntryText(hunterPages, "entity.vampirism.vampire_hunter.name"));
        ArrayList<IPage> vampirePages = new ArrayList<IPage>();
        vampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampire.png")));
        vampirePages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "vampire.text", ModItems.vampire_fang.getLocalizedName(), ModItems.vampire_blood_bottle.getLocalizedName(), ModItems.stake.getLocalizedName())));
        entries.put(new ResourceLocation(base + "vampire"), (EntryAbstract)new EntryText(vampirePages, "entity.vampirism.vampire.name"));
        ArrayList<IPage> advancedHunterPages = new ArrayList<IPage>();
        advancedHunterPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advanced_hunter.png")));
        advancedHunterPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "advanced_hunter.text")));
        entries.put(new ResourceLocation(base + "advanced_hunter"), (EntryAbstract)new EntryText(advancedHunterPages, "entity.vampirism.advanced_hunter.name"));
        ArrayList<IPage> advancedVampirePages = new ArrayList<IPage>();
        advancedVampirePages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/advanced_vampire.png")));
        advancedVampirePages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "advancedVampire.text", ModItems.blood_bottle.getLocalizedName(), ModItems.vampire_blood_bottle.getLocalizedName())));
        entries.put(new ResourceLocation(base + "advanced_vampire"), (EntryAbstract)new EntryText(advancedVampirePages, "entity.vampirism.advanced_vampire.name"));
        ArrayList<IPage> vampireBaronPages = new ArrayList<IPage>();
        vampireBaronPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/vampire_baron.png")));
        vampireBaronPages.addAll(GuideHelper.pagesForLongText(UtilLib.translateFormatted(base + "vampire_baron.text", ModItems.pure_blood.getLocalizedName())));
        GuideHelper.addLinks(vampireBaronPages, new ResourceLocation("guide.vampirism.world.vampire_forest"));
        entries.put(new ResourceLocation(base + "vampireBaron"), (EntryAbstract)new EntryText(vampireBaronPages, "entity.vampirism.vampire_baron.name"));
        ArrayList<IPage> minionPages = new ArrayList<IPage>();
        minionPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/minion.png")));
        minionPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "minion.text")));
        entries.put(new ResourceLocation(base + "minion"), (EntryAbstract)new EntryText(minionPages, "entity.vampirism.vampire_minion_s.name"));
        ArrayList<IPage> ghostPages = new ArrayList<IPage>();
        ghostPages.add((IPage)new PageImage(new ResourceLocation("vampirismguide:textures/images/ghost.png")));
        ghostPages.addAll(GuideHelper.pagesForLongText(UtilLib.translate(base + "ghost.text")));
        entries.put(new ResourceLocation(base + "ghost"), (EntryAbstract)new EntryText(ghostPages, "entity.vampirism.ghost.name"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildWorld() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.world.";
        ArrayList<IPage> vampireForestPages = new ArrayList<IPage>(GuideHelper.pagesForLongText(UtilLib.translate(base + "vampire_forest.text")));
        entries.put(new ResourceLocation(base + "vampire_forest"), (EntryAbstract)new EntryText(vampireForestPages, base + "vampire_forest"));
        ArrayList<IPage> villagePages = new ArrayList<IPage>(GuideHelper.addLinks(GuideHelper.pagesForLongText(UtilLib.translate(base + "villages.text")), new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.blocks.totem_top")));
        entries.put(new ResourceLocation(base + "villages"), (EntryAbstract)new EntryText(villagePages, base + "villages"));
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildItems() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.items.";
        new ItemInfoBuilder(ModItems.vampire_fang).build(entries);
        new ItemInfoBuilder((Item)ModItems.human_heart).build(entries);
        new ItemInfoBuilder(ModItems.pure_blood).setFormats(UtilLib.translate("entity.vampirism.vampire_baron.name")).build(entries);
        new ItemInfoBuilder(ModItems.vampire_blood_bottle).setFormats(UtilLib.translate("entity.vampirism.vampire.name"), ModItems.stake.getLocalizedName(), UtilLib.translate("entity.vampirism.advanced_vampire.name")).build(entries);
        new ItemInfoBuilder(ModItems.vampire_book).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.blood_bottle, 1, 9), false).build(entries);
        new ItemInfoBuilder(ModItems.blood_infused_iron_ingot).craftableStacks(new Object[]{ModItems.blood_infused_iron_ingot, GuideHelper.RECIPE_TYPE.WORKBENCH, ModItems.blood_infused_enhanced_iron_ingot, GuideHelper.RECIPE_TYPE.WORKBENCH}).build(entries);
        GuideHelper.addItemWithTier(ModItems.heart_seeker, GuideHelper.RECIPE_TYPE.WORKBENCH).setLinks(new ResourceLocation("guide.vampirism.blocks.blood_pedestal"), new ResourceLocation("guide.vampirism.items.blood_infused_iron_ingot")).build(entries);
        GuideHelper.addItemWithTier(ModItems.heart_striker, GuideHelper.RECIPE_TYPE.WORKBENCH).setLinks(new ResourceLocation("guide.vampirism.blocks.blood_pedestal"), new ResourceLocation("guide.vampirism.items.blood_infused_iron_ingot")).build(entries);
        new ItemInfoBuilder((Item)ModItems.vampire_cloak).craftableStacks(new Object[]{new ItemStack((Item)ModItems.vampire_cloak, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.vampire_cloak, 1, 1), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.vampire_cloak, 1, 2), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.vampire_cloak, 1, 3), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.vampire_cloak, 1, 4), GuideHelper.RECIPE_TYPE.WORKBENCH}).build(entries);
        new ItemInfoBuilder(ModItems.injection).craftableStacks(new Object[]{new ItemStack((Item)ModItems.injection, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.injection, 1, 1), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Item)ModItems.injection, 1, 2), GuideHelper.RECIPE_TYPE.WORKBENCH}).build(entries);
        new ItemInfoBuilder(ModItems.hunter_intel).setLinks(new ResourceLocation("guide.vampirism.blocks.hunter_table")).setFormats(ModBlocks.hunter_table.func_149732_F()).build(entries);
        new ItemInfoBuilder(ModItems.item_garlic).build(entries);
        new ItemInfoBuilder(ModItems.purified_garlic).setFormats(ModBlocks.garlic_beacon.func_149732_F()).setLinks(new ResourceLocation("guide.vampirism.blocks.garlic_beacon")).craftable(GuideHelper.RECIPE_TYPE.ALCHEMICAL_CAULDRON).build(entries);
        new ItemInfoBuilder(ModItems.pitchfork).craftable(GuideHelper.RECIPE_TYPE.WEAPON_TABLE).build(entries);
        new ItemInfoBuilder(ModItems.stake).setFormats((int)(Balance.hps.INSTANT_KILL_SKILL_1_MAX_HEALTH_PERC * 100.0) + "%").craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModItems.basic_crossbow).setFormats(ModItems.crossbow_arrow.getLocalizedName(), ModItems.tech_crossbow_ammo_package.getLocalizedName()).setLinks(new ResourceLocation("guide.vampirism.items.crossbow_arrow")).craftableStacks(new Object[]{ModItems.basic_crossbow, GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.basic_double_crossbow, GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.enhanced_crossbow, GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.enhanced_double_crossbow, GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.basic_tech_crossbow, GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.tech_crossbow_ammo_package, GuideHelper.RECIPE_TYPE.WEAPON_TABLE}).setName("crossbows").customName().build(entries);
        new ItemInfoBuilder(ModItems.crossbow_arrow).craftableStacks(new Object[]{ModItems.crossbow_arrow.getStack(ItemCrossbowArrow.EnumArrowType.NORMAL), GuideHelper.RECIPE_TYPE.WORKBENCH, ModItems.crossbow_arrow.getStack(ItemCrossbowArrow.EnumArrowType.VAMPIRE_KILLER), GuideHelper.RECIPE_TYPE.WEAPON_TABLE, ModItems.crossbow_arrow.getStack(ItemCrossbowArrow.EnumArrowType.SPITFIRE), GuideHelper.RECIPE_TYPE.WEAPON_TABLE}).build(entries);
        new ItemInfoBuilder(ModItems.holy_water_bottle).setLinks(new ResourceLocation("guide.vampirism.hunter.vamp_slayer"), new ResourceLocation("guide.vampirism.items.holy_salt")).setFormats(ModItems.holy_salt_water.getLocalizedName(), ModItems.holy_salt_water.getLocalizedName(), ModItems.holy_salt.getLocalizedName()).craftableStacks(new Object[]{ModItems.holy_salt_water, GuideHelper.RECIPE_TYPE.BREWING_STAND, ModItems.holy_water_bottle.setTier(new ItemStack((Item)ModItems.holy_water_splash_bottle), IItemWithTier.TIER.NORMAL), GuideHelper.RECIPE_TYPE.BREWING_STAND}).build(entries);
        new ItemInfoBuilder(ModItems.holy_salt).setLinks(new ResourceLocation("guide.vampirism.items.holy_water_bottle")).setFormats(ModItems.pure_salt.getLocalizedName(), ModItems.pure_salt.getLocalizedName(), ModBlocks.alchemical_cauldron.func_149732_F()).craftableStacks(new Object[]{ModItems.pure_salt, GuideHelper.RECIPE_TYPE.ALCHEMICAL_CAULDRON}).build(entries);
        new ItemInfoBuilder(ModItems.item_alchemical_fire).setLinks(new ResourceLocation("guide.vampirism.items.crossbow_arrow")).craftable(GuideHelper.RECIPE_TYPE.ALCHEMICAL_CAULDRON).build(entries);
        GuideHelper.addArmorWithTier(entries, "armor_of_swiftness", ModItems.armor_of_swiftness_head, ModItems.armor_of_swiftness_chest, ModItems.armor_of_swiftness_legs, ModItems.armor_of_swiftness_feet, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        GuideHelper.addArmorWithTier(entries, "hunter_coat", ModItems.hunter_coat_head, ModItems.hunter_coat_chest, ModItems.hunter_coat_legs, ModItems.hunter_coat_feet, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        GuideHelper.addArmorWithTier(entries, "obsidian_armor", ModItems.obsidian_armor_head, ModItems.obsidian_armor_chest, ModItems.obsidian_armor_legs, ModItems.obsidian_armor_feet, GuideHelper.RECIPE_TYPE.WEAPON_TABLE);
        GuideHelper.addItemWithTier(ModItems.hunter_axe, GuideHelper.RECIPE_TYPE.WEAPON_TABLE).build(entries);
        links.putAll(entries);
        return entries;
    }

    private static Map<ResourceLocation, EntryAbstract> buildBlocks() {
        LinkedHashMap<ResourceLocation, EntryAbstract> entries = new LinkedHashMap<ResourceLocation, EntryAbstract>();
        String base = "guide.vampirism.blocks.";
        new ItemInfoBuilder(ModBlocks.castle_block).craftableStacks(new Object[]{new ItemStack((Block)ModBlocks.castle_block, 1, 3), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_block, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_block, 1, 1), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_block, 1, 4), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_slab, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_slab, 1, 1), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_slab, 1, 2), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_stairs_dark, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_stairs_purple, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.castle_stairs_dark_stone, 1, 0), GuideHelper.RECIPE_TYPE.WORKBENCH}).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.vampirism_flower).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.blood_container).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.altar_inspiration).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.altar_infusion).setLinks(new ResourceLocation("guide.vampirism.vampire.leveling")).craftableStacks(new Object[]{new ItemStack((Block)ModBlocks.altar_infusion), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.altar_pillar), GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.altar_tip), GuideHelper.RECIPE_TYPE.WORKBENCH}).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.item_coffin), true).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.church_altar).build(entries);
        new ItemInfoBuilder(new ItemStack((Item)ModItems.item_med_chair), true).setFormats(new ItemStack((Item)ModItems.injection, 1, 1).func_82833_r(), new ItemStack((Item)ModItems.injection, 1, 2).func_82833_r()).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.hunter_table).setFormats(ModItems.hunter_intel.getLocalizedName()).setLinks(new ResourceLocation("guide.vampirism.hunter.leveling"), new ResourceLocation("guide.vampirism.items.hunter_intel")).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.weapon_table).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder(ModBlocks.blood_potion_table).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.alchemical_cauldron).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        int cn = Balance.hps.GARLIC_DIFFUSOR_NORMAL_DISTANCE * 2 + 1;
        int ce = Balance.hps.GARLIC_DIFFUSOR_ENHANCED_DISTANCE * 2 + 1;
        new ItemInfoBuilder((Block)ModBlocks.garlic_beacon).setFormats(cn, cn, ce, ce, ModItems.purified_garlic.getLocalizedName()).setLinks(new ResourceLocation("guide.vampirism.items.item_garlic"), new ResourceLocation("guide.vampirism.items.purified_garlic"), new ResourceLocation("guide.vampirism.items.holy_water_bottle")).craftableStacks(new Object[]{ModBlocks.garlic_beacon, GuideHelper.RECIPE_TYPE.WORKBENCH, new ItemStack((Block)ModBlocks.garlic_beacon, 1, BlockGarlicBeacon.Type.IMPROVED.getId()), GuideHelper.RECIPE_TYPE.WORKBENCH, ModItems.garlic_beacon_core, GuideHelper.RECIPE_TYPE.ALCHEMICAL_CAULDRON, ModItems.garlic_beacon_core_improved, GuideHelper.RECIPE_TYPE.ALCHEMICAL_CAULDRON}).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.blood_pedestal).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.blood_grinder).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).setFormats(ModItems.human_heart.getLocalizedName(), UtilLib.translate(Items.field_151082_bd.func_77658_a() + ".name"), ModBlocks.blood_sieve.func_149732_F()).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.blood_sieve).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).setFormats(UtilLib.translate(ModFluids.impure_blood.getUnlocalizedName()), ModBlocks.blood_grinder.func_149732_F()).setLinks(new ResourceLocation("guide.vampirism.blocks.blood_grinder")).build(entries);
        new ItemInfoBuilder((Block)ModBlocks.totem_top).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).setLinks(new ResourceLocation("guide.vampirism.blocks.totem_base"), new ResourceLocation("guide.vampirism.world.villages")).build(entries);
        new ItemInfoBuilder(ModBlocks.totem_base).craftable(GuideHelper.RECIPE_TYPE.WORKBENCH).setLinks(new ResourceLocation("guide.vampirism.blocks.totem_top"), new ResourceLocation("guide.vampirism.world.villages")).build(entries);
        links.putAll(entries);
        return entries;
    }

    @Nullable
    public Book buildBook() {
        guideBook = new Book();
        guideBook.setTitle("guide.vampirism.title");
        guideBook.setDisplayName("guide.vampirism.name");
        guideBook.setWelcomeMessage("guide.vampirism.welcome");
        guideBook.setAuthor("Maxanier");
        guideBook.setColor(Color.getHSBColor(0.5f, 0.2f, 0.5f));
        guideBook.setRegistryName(new ResourceLocation("vampirism", "guide"));
        guideBook.setOutlineTexture(new ResourceLocation("vampirismguide", "textures/gui/book_violet_border.png"));
        guideBook.setSpawnWithBook(true);
        VampirismMod.log.i(TAG, "Finished Building Guide Book", new Object[0]);
        return guideBook;
    }

    @SideOnly(value=Side.CLIENT)
    public void handleModel(ItemStack bookStack) {
        GuideAPI.setModel((Book)guideBook);
    }

    public void handlePost(ItemStack bookStack) {
        GameRegistry.addShapelessRecipe((ResourceLocation)new ResourceLocation("vampirism", "guide_book"), null, (ItemStack)bookStack, (Ingredient[])new Ingredient[]{Ingredient.func_193367_a((Item)Items.field_151122_aG), Ingredient.func_193368_a((Item[])new Item[]{ModItems.vampire_fang, ModItems.human_heart})});
        if (FMLCommonHandler.instance().getSide() == Side.CLIENT) {
            GuideBook.buildCategories();
        }
    }

    static {
        links = Maps.newHashMap();
    }
}

