/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.client.model.ModelCloak;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.util.Helper;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemVampireCloak
extends ItemArmor {
    private final String registeredName = "vampire_cloak";

    public ItemVampireCloak() {
        super(ItemArmor.ArmorMaterial.LEATHER, 0, EntityEquipmentSlot.CHEST);
        this.field_77787_bX = true;
        this.func_77656_e(0);
        this.func_77637_a(VampirismMod.creativeTab);
        this.setRegistryName("vampirism", "vampire_cloak");
        this.func_77655_b("vampirism.vampire_cloak");
    }

    @SideOnly(value=Side.CLIENT)
    public ModelBiped getArmorModel(EntityLivingBase entityLiving, ItemStack itemStack, EntityEquipmentSlot armorSlot, ModelBiped _default) {
        return new ModelCloak();
    }

    public String getArmorTexture(ItemStack stack, Entity entity, EntityEquipmentSlot slot, String type) {
        return String.format("vampirism:textures/models/armor/%s/%s_%s", "vampire_cloak", "vampire_cloak", EnumCloakColor.byMetadata(stack.func_77960_j()).getDyeColorName() + ".png");
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (this.func_194125_a(tab)) {
            subItems.add((Object)new ItemStack((Item)this, 1, 0));
        }
        if (tab.equals(CreativeTabs.field_78027_g)) {
            for (EnumCloakColor s : EnumCloakColor.values()) {
                if (s.getMetadata() == 0) continue;
                subItems.add((Object)new ItemStack((Item)this, 1, s.getMetadata()));
            }
        }
    }

    public String getUnlocalizedName(ItemStack stack) {
        int i = stack.func_77960_j();
        return super.func_77658_a() + "." + EnumCloakColor.byMetadata(i).getUnlocalizedName();
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        super.onArmorTick(world, player, itemStack);
        if (player.field_70173_aa % 16 == 8 && Helper.isHunter((Entity)player)) {
            player.func_70690_d(new PotionEffect(ModPotions.poison, 20, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        if (Helper.isHunter((Entity)Minecraft.func_71410_x().field_71439_g)) {
            tooltip.add(TextFormatting.RED + UtilLib.translate("text.vampirism.poisonous_to_hunters"));
        }
    }

    public static enum EnumCloakColor implements IStringSerializable
    {
        REDBLACK(0, "red_black"),
        BLACKRED(1, "black_red"),
        BLACKWHITE(2, "black_white"),
        WHITEBLACK(3, "white_black"),
        BLACKBLUE(4, "black_blue");

        private static final EnumCloakColor[] META_LOOKUP;
        private final int meta;
        private final String name;

        public static EnumCloakColor byMetadata(int meta) {
            if (meta < 0 || meta >= META_LOOKUP.length) {
                meta = 0;
            }
            return META_LOOKUP[meta];
        }

        private EnumCloakColor(int metaIn, String nameIn) {
            this.meta = metaIn;
            this.name = nameIn;
        }

        public String getDyeColorName() {
            return this.name;
        }

        public int getMetadata() {
            return this.meta;
        }

        public String func_176610_l() {
            return this.name;
        }

        public String getUnlocalizedName() {
            return this.name;
        }

        static {
            META_LOOKUP = new EnumCloakColor[EnumCloakColor.values().length];
            EnumCloakColor[] enumCloakColorArray = EnumCloakColor.values();
            int n = enumCloakColorArray.length;
            for (int i = 0; i < n; ++i) {
                EnumCloakColor enumdyecolor;
                EnumCloakColor.META_LOOKUP[enumdyecolor.getMetadata()] = enumdyecolor = enumCloakColorArray[i];
            }
        }
    }
}

