/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.items;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.VampirismMod;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.items.VampirismHunterWeapon;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.init.Enchantments;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemHunterAxe
extends VampirismHunterWeapon
implements IItemWithTier {
    private static final String regName = "hunter_axe";

    public ItemHunterAxe() {
        super(regName, Item.ToolMaterial.IRON, 0.37f);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        super.func_77624_a(stack, worldIn, tooltip, flagIn);
        IItemWithTier.TIER tier = this.getTier(stack);
        if (tier != IItemWithTier.TIER.NORMAL) {
            tooltip.add(TextFormatting.AQUA + UtilLib.translate("text.vampirism.item_tier." + tier.name().toLowerCase()));
        }
        tooltip.add(UtilLib.translateFormatted("text.vampirism.deals_more_damage_to", Math.round((this.getVampireMult(tier) - 1.0f) * 100.0f)) + " " + UtilLib.translate(VReference.VAMPIRE_FACTION.getUnlocalizedNamePlural()));
    }

    @Override
    public float getDamageMultiplierForFaction(@Nonnull ItemStack stack) {
        return this.getVampireMult(this.getTier(stack));
    }

    @Override
    public int getMinLevel(@Nonnull ItemStack stack) {
        return this.getMinLevel(this.getTier(stack));
    }

    public void func_150895_a(CreativeTabs tab, NonNullList<ItemStack> items) {
        if (this.func_194125_a(tab)) {
            for (IItemWithTier.TIER t : IItemWithTier.TIER.values()) {
                items.add((Object)this.setTier(new ItemStack((Item)this), t));
            }
        }
    }

    @Override
    public IItemWithTier.TIER getTier(@Nonnull ItemStack stack) {
        NBTTagCompound nbt = UtilLib.checkNBT(stack);
        if (nbt.func_74764_b("tier")) {
            try {
                return IItemWithTier.TIER.valueOf(nbt.func_74779_i("tier"));
            }
            catch (IllegalArgumentException e) {
                VampirismMod.log.e("HunterAxe", e, "Cannot find tier %s", nbt.func_74779_i("tier"));
            }
        }
        return IItemWithTier.TIER.NORMAL;
    }

    public boolean func_77636_d(ItemStack stack) {
        return false;
    }

    @Override
    @Nonnull
    public ItemStack setTier(@Nonnull ItemStack stack, IItemWithTier.TIER tier) {
        NBTTagCompound nbt = UtilLib.checkNBT(stack);
        nbt.func_74778_a("tier", tier.name());
        HashMap<Enchantment, Integer> map = new HashMap<Enchantment, Integer>();
        map.put(Enchantments.field_180313_o, this.getKnockback(tier));
        EnchantmentHelper.func_82782_a(map, (ItemStack)stack);
        return stack;
    }

    private int getKnockback(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 4;
            }
            case ENHANCED: {
                return 3;
            }
        }
        return 2;
    }

    private int getMinLevel(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 8;
            }
            case ENHANCED: {
                return 6;
            }
        }
        return 4;
    }

    private float getVampireMult(IItemWithTier.TIER tier) {
        switch (tier) {
            case ULTIMATE: {
                return 1.4f;
            }
            case ENHANCED: {
                return 1.3f;
            }
        }
        return 1.1f;
    }
}

