/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity.vampire;

import de.teamlapen.lib.lib.util.UtilLib;
import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.VReference;
import de.teamlapen.vampirism.api.entity.vampire.IVampireMob;
import de.teamlapen.vampirism.api.items.IItemWithTier;
import de.teamlapen.vampirism.api.items.IVampireFinisher;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModBiomes;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.DamageHandler;
import de.teamlapen.vampirism.entity.EntityCrossbowArrow;
import de.teamlapen.vampirism.entity.EntitySoulOrb;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.items.ItemHunterCoat;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public abstract class EntityVampireBase
extends EntityVampirism
implements IVampireMob {
    protected SpawnRestriction spawnRestriction = SpawnRestriction.NORMAL;
    private final boolean countAsMonsterForSpawn;
    protected EnumStrength garlicResist = EnumStrength.NONE;
    protected boolean canSuckBloodFromPlayer = false;
    protected boolean vulnerableToFire = true;
    private boolean sundamageCache;
    private EnumStrength garlicCache = EnumStrength.NONE;
    private boolean dropSoul = false;

    @Override
    public boolean func_70601_bi() {
        if (this.spawnRestriction.level >= SpawnRestriction.SIMPLE.level) {
            if (this.isGettingSundamage(true) || this.isGettingGarlicDamage(true) != EnumStrength.NONE) {
                return false;
            }
            if (this.spawnRestriction.level >= SpawnRestriction.NORMAL.level) {
                if (this.field_70170_p.func_72935_r() && this.field_70146_Z.nextInt(5) != 0) {
                    return false;
                }
                if (this.field_70170_p.func_175714_ae().func_176056_a(this.func_180425_c(), 1) != null && this.func_70681_au().nextInt(60) != 0) {
                    return false;
                }
                if (this.spawnRestriction.level >= SpawnRestriction.SPECIAL.level && !this.getCanSpawnHereRestricted()) {
                    return false;
                }
            }
        }
        return super.func_70601_bi();
    }

    public EntityVampireBase(World world, boolean countAsMonsterForSpawn) {
        super(world);
        this.countAsMonsterForSpawn = countAsMonsterForSpawn;
    }

    public void setSpawnRestriction(SpawnRestriction r) {
        this.spawnRestriction = r;
    }

    @Override
    public boolean func_70652_k(Entity entity) {
        if (this.canSuckBloodFromPlayer && !this.field_70170_p.field_72995_K && entity instanceof EntityPlayer && !UtilLib.canReallySee((EntityLivingBase)entity, (EntityLivingBase)this, true) && this.field_70146_Z.nextInt(Balance.mobProps.VAMPIRE_BITE_ATTACK_CHANCE) == 0) {
            int amt = VampirePlayer.get((EntityPlayer)entity).onBite(this);
            this.drinkBlood(amt, 0.7f);
            return true;
        }
        for (ItemStack e : entity.func_184193_aE()) {
            if (e == null || !(e.func_77973_b() instanceof ItemHunterCoat)) continue;
            int j = 1;
            if (((ItemHunterCoat)e.func_77973_b()).getTier(e).equals((Object)IItemWithTier.TIER.ENHANCED)) {
                j = 2;
            } else if (((ItemHunterCoat)e.func_77973_b()).getTier(e).equals((Object)IItemWithTier.TIER.ULTIMATE)) {
                j = 3;
            }
            if (this.func_70681_au().nextInt((4 - j) * 2) != 0) continue;
            this.func_70690_d(new PotionEffect(ModPotions.poison, (int)(20.0 * Math.sqrt(j)), j));
        }
        return super.func_70652_k(entity);
    }

    public boolean func_70097_a(DamageSource damageSource, float amount) {
        if (this.vulnerableToFire) {
            if (DamageSource.field_76372_a.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_IN_FIRE, this.calculateFireDamage(amount));
            }
            if (DamageSource.field_76370_b.equals(damageSource)) {
                return this.func_70097_a(VReference.VAMPIRE_ON_FIRE, this.calculateFireDamage(amount));
            }
        }
        return super.func_70097_a(damageSource, amount);
    }

    @Override
    public boolean doesResistGarlic(EnumStrength strength) {
        return !strength.isStrongerThan(this.garlicResist);
    }

    @Override
    public void drinkBlood(int amt, float saturationMod, boolean useRemaining) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76428_l, amt * 20));
    }

    public EnumCreatureAttribute func_70668_bt() {
        return VReference.VAMPIRE_CREATURE_ATTRIBUTE;
    }

    public float func_70047_e() {
        return this.field_70131_O * 0.875f;
    }

    @Override
    public EntityLivingBase getRepresentingEntity() {
        return this;
    }

    public boolean isCreatureType(EnumCreatureType type, boolean forSpawnCount) {
        if (forSpawnCount && this.countAsMonsterForSpawn && type == EnumCreatureType.MONSTER) {
            return true;
        }
        return super.isCreatureType(type, forSpawnCount);
    }

    @Override
    @Nonnull
    public EnumStrength isGettingGarlicDamage(boolean forcerefresh) {
        if (forcerefresh) {
            this.garlicCache = Helper.getGarlicStrength((Entity)this);
        }
        return this.garlicCache;
    }

    @Override
    public boolean isGettingSundamage(boolean forceRefresh) {
        if (!forceRefresh) {
            return this.sundamageCache;
        }
        this.sundamageCache = Helper.gettingSundamge((EntityLivingBase)this);
        return this.sundamageCache;
    }

    @Override
    public boolean isIgnoringSundamage() {
        return this.func_70644_a(ModPotions.sunscreen);
    }

    public void func_70645_a(DamageSource cause) {
        super.func_70645_a(cause);
        if (cause.func_76364_f() instanceof EntityCrossbowArrow && Helper.isHunter(cause.func_76346_g())) {
            this.dropSoul = true;
        } else if (cause.func_76364_f() instanceof EntityPlayer && Helper.isHunter(cause.func_76364_f())) {
            ItemStack weapon = ((EntityPlayer)cause.func_76364_f()).func_184614_ca();
            if (!weapon.func_190926_b() && weapon.func_77973_b() instanceof IVampireFinisher) {
                this.dropSoul = true;
            }
        } else {
            this.dropSoul = false;
        }
    }

    @Override
    public void func_70636_d() {
        if (this.field_70173_aa % 40 == 3) {
            this.isGettingGarlicDamage(true);
        }
        if (this.field_70173_aa % 8 == 2) {
            this.isGettingSundamage(true);
        }
        if (!this.field_70170_p.field_72995_K) {
            double dmg;
            if (this.isGettingSundamage() && this.field_70173_aa % 40 == 11 && (dmg = this.func_110148_a(VReference.sunDamage).func_111126_e()) > 0.0) {
                this.func_70097_a(VReference.SUNDAMAGE, (float)dmg);
            }
            if (this.isGettingGarlicDamage() != EnumStrength.NONE) {
                DamageHandler.affectVampireGarlicAmbient(this, this.isGettingGarlicDamage(), this.field_70173_aa);
            }
        }
        if (!this.field_70170_p.field_72995_K && this.func_70089_S() && this.func_70090_H()) {
            this.func_70050_g(300);
            if (this.field_70173_aa % 16 == 4) {
                this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, 80, 0));
            }
        }
        super.func_70636_d();
    }

    @Override
    public boolean useBlood(int amt, boolean allowPartial) {
        this.func_70690_d(new PotionEffect(MobEffects.field_76437_t, amt * 20));
        return true;
    }

    @Override
    public boolean wantsBlood() {
        return false;
    }

    @Override
    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110140_aT().func_111150_b(VReference.sunDamage).func_111128_a(Balance.mobProps.VAMPIRE_MOB_SUN_DAMAGE);
    }

    protected float calculateFireDamage(float amount) {
        return amount;
    }

    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
    }

    protected void func_70609_aI() {
        if (this.field_70725_aQ == 19 && !this.field_70170_p.field_72995_K && this.dropSoul && this.field_70170_p.func_82736_K().func_82766_b("doMobLoot")) {
            this.field_70170_p.func_72838_d((Entity)new EntitySoulOrb(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, EntitySoulOrb.TYPE.VAMPIRE));
        }
        super.func_70609_aI();
    }

    private boolean getCanSpawnHereRestricted() {
        boolean vampireBiome = ((Object)((Object)ModBiomes.vampireForest)).equals(this.field_70170_p.func_180494_b(this.func_180425_c()));
        if (!vampireBiome) {
            return this.isLowLightLevel();
        }
        IBlockState iblockstate = this.field_70170_p.func_180495_p(new BlockPos((Entity)this).func_177977_b());
        return ((Object)((Object)ModBlocks.cursed_earth)).equals(iblockstate.func_177230_c());
    }

    public static enum SpawnRestriction {
        NONE(0),
        SIMPLE(1),
        NORMAL(2),
        SPECIAL(3);

        int level;

        private SpawnRestriction(int level) {
            this.level = level;
        }
    }
}

