/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntitySelectors;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntitySoulOrb
extends Entity {
    public static final DataParameter<String> TYPE_PARAMETER = EntityDataManager.func_187226_a(EntitySoulOrb.class, (DataSerializer)DataSerializers.field_187194_d);
    private int delayBeforePickup;
    private EntityPlayer player;
    private int age;
    @Nullable
    private ItemStack soulItemStack;

    public EntitySoulOrb(World worldIn, double x, double y, double z, TYPE type) {
        super(worldIn);
        this.setType(type);
        this.field_70178_ae = true;
        this.delayBeforePickup = 10;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70107_b(x, y, z);
        this.field_70177_z = (float)(Math.random() * 360.0);
        this.field_70159_w = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
        this.field_70181_x = (float)(Math.random() * 0.2) * 2.0f;
        this.field_70179_y = (float)(Math.random() * (double)0.2f - (double)0.1f) * 2.0f;
    }

    public EntitySoulOrb(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        return false;
    }

    public boolean func_70075_an() {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        float f = 0.5f;
        f = MathHelper.func_76131_a((float)f, (float)0.0f, (float)1.0f);
        int i = super.func_70070_b();
        int j = i & 0xFF;
        int k = i >> 16 & 0xFF;
        if ((j += (int)(f * 15.0f * 16.0f)) > 240) {
            j = 240;
        }
        return j | k << 16;
    }

    @Nonnull
    public ItemStack getSoulItemStack() {
        if (this.soulItemStack == null) {
            this.soulItemStack = this.createSoulItemStack();
        }
        return this.soulItemStack;
    }

    public boolean func_70072_I() {
        return this.field_70170_p.func_72918_a(this.func_174813_aQ(), Material.field_151586_h, (Entity)this);
    }

    public boolean func_98034_c(@Nonnull EntityPlayer player) {
        switch (this.getType()) {
            case VAMPIRE: {
                return !Helper.isHunter((Entity)player) || player.func_175149_v();
            }
        }
        return true;
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.delayBeforePickup == 0 && Helper.isHunter((Entity)entityIn) && entityIn.field_71071_by.func_70441_a(this.getSoulItemStack())) {
            entityIn.func_71001_a((Entity)this, 1);
            this.func_70106_y();
        }
    }

    public void func_70071_h_() {
        double relDiffZ;
        double relDiffY;
        double relDiffX;
        double relDist;
        double d5;
        super.func_70071_h_();
        if (this.delayBeforePickup > 0) {
            --this.delayBeforePickup;
        }
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.func_189652_ae()) {
            this.field_70181_x -= 0.03;
        }
        if (this.field_70170_p.func_180495_p(new BlockPos((Entity)this)).func_185904_a() == Material.field_151587_i) {
            this.field_70181_x = 0.2;
            this.field_70159_w = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
            this.field_70179_y = (this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.2f;
        }
        this.func_145771_j(this.field_70165_t, (this.func_174813_aQ().field_72338_b + this.func_174813_aQ().field_72337_e) / 2.0, this.field_70161_v);
        if (this.age % 10 == 5 & (this.player == null || this.player.field_70128_L || this.player.func_70068_e((Entity)this) > 64.0)) {
            this.player = this.field_70170_p.func_190525_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, 8.0, Predicates.and((Predicate)EntitySelectors.field_180132_d, Helper::isHunter));
        }
        if (this.player != null && (d5 = 1.0 - (relDist = Math.sqrt((relDiffX = (this.player.field_70165_t - this.field_70165_t) / 8.0) * relDiffX + (relDiffY = (this.player.field_70163_u + (double)this.player.func_70047_e() / 2.0 - this.field_70163_u) / 8.0) * relDiffY + (relDiffZ = (this.player.field_70161_v - this.field_70161_v) / 8.0) * relDiffZ))) > 0.0) {
            d5 *= d5;
            this.field_70159_w += relDiffX / relDist * d5 * 0.08;
            this.field_70181_x += relDiffY / relDist * d5 * 0.08;
            this.field_70179_y += relDiffZ / relDist * d5 * 0.08;
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        float f = 0.98f;
        if (this.field_70122_E) {
            BlockPos underPos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.func_174813_aQ().field_72338_b) - 1, MathHelper.func_76128_c((double)this.field_70161_v));
            IBlockState underState = this.field_70170_p.func_180495_p(underPos);
            f = underState.func_177230_c().getSlipperiness(underState, (IBlockAccess)this.field_70170_p, underPos, (Entity)this) * 0.98f;
        }
        this.field_70159_w *= (double)f;
        this.field_70181_x *= (double)0.98f;
        this.field_70179_y *= (double)f;
        if (this.field_70122_E) {
            this.field_70181_x *= (double)-0.9f;
        }
        ++this.age;
        if (this.age >= 6000) {
            this.func_70106_y();
        }
    }

    protected boolean func_70041_e_() {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(TYPE_PARAMETER, (Object)TYPE.NONE.name());
    }

    protected void func_70037_a(NBTTagCompound compound) {
        this.setType(TYPE.valueOf(compound.func_74779_i("type")));
        this.age = compound.func_74762_e("age");
        this.soulItemStack = null;
    }

    protected void func_70014_b(NBTTagCompound compound) {
        compound.func_74778_a("type", this.getType().name());
        compound.func_74768_a("age", this.age);
    }

    private ItemStack createSoulItemStack() {
        switch (this.getType()) {
            case VAMPIRE: {
                return new ItemStack((Item)ModItems.soul_orb_vampire);
            }
        }
        return new ItemStack((Item)ModItems.soul_orb_vampire);
    }

    private TYPE getType() {
        return TYPE.valueOf((String)this.func_184212_Q().func_187225_a(TYPE_PARAMETER));
    }

    private void setType(TYPE type) {
        this.func_184212_Q().func_187227_b(TYPE_PARAMETER, (Object)type.name());
    }

    public static enum TYPE {
        NONE,
        VAMPIRE;

    }
}

