/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.entity;

import de.teamlapen.vampirism.api.EnumStrength;
import de.teamlapen.vampirism.api.entity.player.actions.IActionHandler;
import de.teamlapen.vampirism.api.entity.player.vampire.IVampirePlayer;
import de.teamlapen.vampirism.api.entity.vampire.IVampire;
import de.teamlapen.vampirism.config.Balance;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.EntityVampirism;
import de.teamlapen.vampirism.entity.action.EntityActionHandler;
import de.teamlapen.vampirism.entity.action.EntityActions;
import de.teamlapen.vampirism.entity.vampire.EntityVampireBaron;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.Helper;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.EntityDamageSourceIndirect;

public class DamageHandler {
    public static void affectVampireGarlicSplash(IVampire vampire, EnumStrength strength, double distSq, boolean directHit) {
        if (vampire.doesResistGarlic(strength)) {
            return;
        }
        if (distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            DamageHandler.affectVampireGarlic(vampire, strength, (float)(10.0 * affect), false);
        }
    }

    public static void affectVampireGarlicDirect(IVampire vampire, EnumStrength strength) {
        DamageHandler.affectVampireGarlic(vampire, strength, 20.0f, false);
    }

    private static void affectVampireGarlic(IVampire vampire, EnumStrength strength, float multiplier, boolean ambient) {
        IActionHandler<IVampirePlayer> actionHandler;
        if (strength == EnumStrength.NONE) {
            return;
        }
        EntityLivingBase entity = vampire.getRepresentingEntity();
        entity.func_70690_d(new PotionEffect(ModPotions.garlic, (int)(multiplier * 20.0f), strength.getStrength() - 1, ambient, true));
        if (entity instanceof EntityPlayer && ((EntityPlayer)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        entity.func_70690_d(new PotionEffect(MobEffects.field_76437_t, (int)(multiplier * 20.0f), 1, ambient, false));
        if (strength == EnumStrength.MEDIUM || strength == EnumStrength.STRONG) {
            entity.func_70690_d(new PotionEffect(MobEffects.field_76421_d, (int)(multiplier * 20.0f), 1, ambient, false));
            if (strength == EnumStrength.STRONG) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, (int)(multiplier / 2.0f * 20.0f), 0, ambient, false));
            }
        }
        if (vampire instanceof IVampirePlayer && (actionHandler = ((IVampirePlayer)vampire).getActionHandler()).isActionActive(VampireActions.disguise_vampire)) {
            actionHandler.toggleAction(VampireActions.disguise_vampire);
        }
    }

    public static void affectVampireGarlicAmbient(IVampire vampire, EnumStrength strength, int ticks) {
        if (ticks % 37 == 7) {
            DamageHandler.affectVampireGarlic(vampire, strength, 5.0f, true);
        }
    }

    public static void affectEntityHolyWaterSplash(EntityLivingBase entity, EnumStrength strength, double distSq, boolean directHit) {
        DamageHandler.affectEntityHolyWaterSplash(entity, strength, distSq, directHit, null);
    }

    public static void affectEntityHolyWaterSplash(EntityLivingBase entity, EnumStrength strength, double distSq, boolean directHit, @Nullable EntityLivingBase source) {
        EntityActionHandler h;
        boolean vampire = Helper.isVampire((Entity)entity);
        if (entity.func_184603_cC() && (vampire || EnumCreatureAttribute.UNDEAD.equals((Object)entity.func_70668_bt())) && distSq < 16.0) {
            double affect = 1.0 - Math.sqrt(distSq) / 4.0;
            if (directHit) {
                affect = 1.0;
            }
            if (!vampire) {
                affect *= 0.5;
            }
            double amount = affect * ((double)Balance.general.HOLY_WATER_SPLASH_DAMAGE * (strength == EnumStrength.WEAK ? 1.0 : (strength == EnumStrength.MEDIUM ? Balance.general.HOLY_WATER_TIER_DAMAGE_INC : Balance.general.HOLY_WATER_TIER_DAMAGE_INC * Balance.general.HOLY_WATER_TIER_DAMAGE_INC))) + 0.5;
            if (entity instanceof EntityPlayer) {
                int l = VampirePlayer.get((EntityPlayer)entity).getLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 15, amount * 0.8, amount * 1.3);
            } else if (entity instanceof EntityVampireBaron) {
                int l = ((EntityVampireBaron)entity).getLevel();
                amount = DamageHandler.scaleDamageWithLevel(l, 5, amount * 0.8, amount * 2.0);
            }
            entity.func_70097_a(new EntityDamageSourceIndirect("holy_water", (Entity)entity, (Entity)source).func_82726_p(), (float)amount);
        }
        if (vampire && entity instanceof EntityPlayer) {
            IActionHandler<IVampirePlayer> actionHandler = VampirePlayer.get((EntityPlayer)entity).getActionHandler();
            if (actionHandler.isActionActive(VampireActions.disguise_vampire)) {
                actionHandler.toggleAction(VampireActions.disguise_vampire);
            }
            if (actionHandler.isActionActive(VampireActions.vampire_invisibility)) {
                actionHandler.toggleAction(VampireActions.vampire_invisibility);
            }
        } else if (vampire && entity instanceof EntityVampirism && (h = ((EntityVampirism)entity).getActionHandler()) != null && h.isActionActive(EntityActions.entity_invisible)) {
            h.deactivateAction();
        }
        if (vampire) {
            if (strength.isStrongerThan(EnumStrength.WEAK)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76431_k, Balance.general.HOLY_WATER_NAUSEA_DURATION, 2));
            }
            if (strength.isStrongerThan(EnumStrength.MEDIUM)) {
                entity.func_70690_d(new PotionEffect(MobEffects.field_76440_q, Balance.general.HOLY_WATER_BLINDNESS_DURATION, 1));
            }
        }
    }

    private static double scaleDamageWithLevel(int level, int maxLevel, double minDamage, double maxDamage) {
        return minDamage + (double)level / (double)maxLevel * (maxDamage - minDamage);
    }
}

