/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism.client.gui;

import de.teamlapen.lib.lib.client.gui.ExtendedGui;
import de.teamlapen.lib.lib.util.FluidLib;
import de.teamlapen.vampirism.api.entity.IBiteableEntity;
import de.teamlapen.vampirism.api.entity.factions.IPlayableFaction;
import de.teamlapen.vampirism.api.entity.player.IFactionPlayer;
import de.teamlapen.vampirism.api.entity.player.vampire.IBloodStats;
import de.teamlapen.vampirism.config.Configs;
import de.teamlapen.vampirism.core.ModBlocks;
import de.teamlapen.vampirism.core.ModFluids;
import de.teamlapen.vampirism.core.ModPotions;
import de.teamlapen.vampirism.entity.ExtendedCreature;
import de.teamlapen.vampirism.entity.factions.FactionPlayerHandler;
import de.teamlapen.vampirism.entity.hunter.EntityHunterBase;
import de.teamlapen.vampirism.player.hunter.HunterPlayer;
import de.teamlapen.vampirism.player.vampire.VampirePlayer;
import de.teamlapen.vampirism.player.vampire.actions.VampireActions;
import de.teamlapen.vampirism.util.HalloweenSpecial;
import de.teamlapen.vampirism.util.Helper;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.PotionEffect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.GuiIngameForge;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.lwjgl.opengl.GL11;

@SideOnly(value=Side.CLIENT)
public class VampirismHUDOverlay
extends ExtendedGui {
    private final Minecraft mc;
    private final ResourceLocation icons = new ResourceLocation("vampirism:textures/gui/icons.png");
    private final ResourceLocation icons_poison = new ResourceLocation("vampirism", "textures/gui/icons_poison.png");
    private int screenColor = 0;
    private int screenPercentage = 0;
    private boolean fullScreen = false;
    private int renderFullTick = 0;
    private int rederFullOn;
    private int renderFullOff;
    private int renderFullColor;
    private int screenBottomColor = 0;
    private int screenBottomPercentage = 0;

    public VampirismHUDOverlay(Minecraft mc) {
        this.mc = mc;
    }

    public void makeRenderFullColor(int on, int off, int color) {
        this.rederFullOn = on;
        this.renderFullOff = off;
        this.renderFullTick = on + off;
        if ((color >> 24 & 0xFF) == 0) {
            color |= 0xFF000000;
        }
        this.renderFullColor = color;
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (this.mc.field_71439_g == null) {
            return;
        }
        if (event.phase == TickEvent.Phase.END) {
            return;
        }
        IFactionPlayer player = FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentFactionPlayer();
        if (player instanceof VampirePlayer) {
            this.handleScreenColorVampire((VampirePlayer)player);
        } else if (player instanceof HunterPlayer) {
            this.handleScreenColorHunter((HunterPlayer)player);
        } else {
            this.screenPercentage = 0;
            this.screenBottomPercentage = 0;
        }
        if (this.renderFullTick > 0) {
            this.screenColor = this.renderFullColor;
            this.fullScreen = true;
            this.screenPercentage = this.renderFullTick > this.renderFullOff ? (int)(100.0f * (1.0f - (float)(this.renderFullTick - this.renderFullOff) / (float)this.rederFullOn)) : (int)((float)(100 * this.renderFullTick) / (float)this.renderFullOff);
            --this.renderFullTick;
        }
    }

    @SubscribeEvent
    public void onRenderCrosshair(RenderGameOverlayEvent.Pre event) {
        TileEntity tile;
        VampirePlayer player;
        IBlockState block;
        if (event.getType() != RenderGameOverlayEvent.ElementType.CROSSHAIRS) {
            return;
        }
        RayTraceResult p = Minecraft.func_71410_x().field_71476_x;
        if (p != null && p.field_72313_a == RayTraceResult.Type.ENTITY && p.field_72308_g != null) {
            VampirePlayer player2 = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g);
            if (player2.getLevel() > 0 && !this.mc.field_71439_g.func_175149_v() && !player2.getActionHandler().isActionActive(VampireActions.bat)) {
                Entity entity = p.field_72308_g;
                IBiteableEntity biteable = null;
                if (entity instanceof IBiteableEntity) {
                    biteable = (IBiteableEntity)entity;
                } else if (entity instanceof EntityCreature) {
                    biteable = ExtendedCreature.get((EntityCreature)entity);
                } else if (entity instanceof EntityPlayer) {
                    biteable = VampirePlayer.get((EntityPlayer)entity);
                }
                if (biteable != null && biteable.canBeBitten(player2)) {
                    int color = 0xFF0000;
                    if (entity instanceof EntityHunterBase || entity instanceof EntityCreature && ExtendedCreature.get((EntityCreature)entity).hasPoisonousBlood()) {
                        color = 626722;
                    }
                    this.renderBloodFangs(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), MathHelper.func_76131_a((float)biteable.getBloodLevelRelative(), (float)0.2f, (float)1.0f), color);
                    event.setCanceled(true);
                }
            }
        } else if (p != null && p.field_72313_a == RayTraceResult.Type.BLOCK && ((Object)((Object)ModBlocks.blood_container)).equals((block = Minecraft.func_71410_x().field_71441_e.func_180495_p(p.func_178782_a())).func_177230_c()) && (player = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g)).wantsBlood() && (tile = Minecraft.func_71410_x().field_71441_e.func_175625_s(p.func_178782_a())) != null && tile.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null) && FluidLib.getFluidAmount((IFluidHandler)tile.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, null), ModFluids.blood) > 0) {
            this.renderBloodFangs(event.getResolution().func_78326_a(), event.getResolution().func_78328_b(), 1.0f, 0xFF0000);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onRenderExperienceBar(RenderGameOverlayEvent.Post event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.EXPERIENCE) {
            return;
        }
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        IPlayableFaction faction = FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentFaction();
        if (this.mc.field_71442_b.func_78763_f() && faction != null && faction.renderLevel()) {
            int color = faction.getColor();
            String text = "" + FactionPlayerHandler.get((EntityPlayer)this.mc.field_71439_g).getCurrentLevel();
            int x = (event.getResolution().func_78326_a() - this.mc.field_71466_p.func_78256_a(text)) / 2 + Configs.gui_level_offset_x;
            int y = event.getResolution().func_78328_b() - Configs.gui_level_offset_y;
            this.mc.field_71466_p.func_78276_b(text, x + 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x - 1, y, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y + 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y - 1, 0);
            this.mc.field_71466_p.func_78276_b(text, x, y, color);
        }
    }

    @SubscribeEvent
    public void onRenderHealthBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.HEALTH) {
            return;
        }
        if (this.mc.field_71439_g.func_70644_a(ModPotions.poison)) {
            this.mc.func_110434_K().func_110577_a(this.icons_poison);
        }
    }

    @SubscribeEvent
    public void onRenderFoodBar(RenderGameOverlayEvent.Pre event) {
        if (event.getType() != RenderGameOverlayEvent.ElementType.FOOD) {
            return;
        }
        if (Helper.isVampire((Entity)this.mc.field_71439_g)) {
            event.setCanceled(true);
            if (this.mc.field_71442_b.func_78763_f()) {
                IBloodStats stats = VampirePlayer.get((EntityPlayer)this.mc.field_71439_g).getBloodStats();
                GlStateManager.func_179147_l();
                this.mc.func_110434_K().func_110577_a(this.icons);
                int left = event.getResolution().func_78326_a() / 2 + 91;
                int top = event.getResolution().func_78328_b() - GuiIngameForge.right_height;
                GuiIngameForge.right_height += 10;
                int blood = stats.getBloodLevel();
                int maxBlood = stats.getMaxBlood();
                int blood2 = blood - 20;
                int maxBlood2 = maxBlood - 20;
                for (int i = 0; i < 10; ++i) {
                    int idx = i * 2 + 1;
                    int x = left - i * 8 - 9;
                    this.func_73729_b(x, top, 0, idx <= maxBlood2 ? 9 : 0, 9, 9);
                    if (idx < blood) {
                        this.func_73729_b(x, top, 9, idx < blood2 ? 9 : 0, 9, 9);
                        if (idx != blood2) continue;
                        this.func_73729_b(x, top, 18, 9, 9, 9);
                        continue;
                    }
                    if (idx != blood) continue;
                    this.func_73729_b(x, top, 18, 0, 9, 9);
                }
                this.mc.func_110434_K().func_110577_a(Gui.field_110324_m);
                GlStateManager.func_179084_k();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public void onRenderWorldLast(RenderWorldLastEvent event) {
        if (!(this.screenPercentage <= 0 && this.screenBottomPercentage <= 0 || Configs.disable_screen_overlay)) {
            ScaledResolution scaledresolution = new ScaledResolution(this.mc);
            GlStateManager.func_179086_m((int)256);
            GlStateManager.func_179128_n((int)5889);
            GlStateManager.func_179096_D();
            GlStateManager.func_179130_a((double)0.0, (double)scaledresolution.func_78327_c(), (double)scaledresolution.func_78324_d(), (double)0.0, (double)1.0, (double)-1.0);
            GlStateManager.func_179128_n((int)5888);
            GlStateManager.func_179096_D();
            GlStateManager.func_179094_E();
            GL11.glDisable((int)2929);
            int w = scaledresolution.func_78326_a();
            int h = scaledresolution.func_78328_b();
            if (this.fullScreen) {
                float r = (float)(this.screenColor >> 16 & 0xFF) / 255.0f;
                float g = (float)(this.screenColor >> 8 & 0xFF) / 255.0f;
                float b = (float)(this.screenColor & 0xFF) / 255.0f;
                float a = (float)this.screenPercentage / 100.0f * (float)(this.screenColor >> 24 & 0xFF) / 255.0f;
                GlStateManager.func_179090_x();
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
                GlStateManager.func_179103_j((int)7425);
                Tessellator tessellator = Tessellator.func_178181_a();
                BufferBuilder worldrenderer = tessellator.func_178180_c();
                worldrenderer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
                worldrenderer.func_181662_b(0.0, (double)h, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b((double)w, (double)h, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b((double)w, 0.0, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                worldrenderer.func_181662_b(0.0, 0.0, (double)this.field_73735_i).func_181666_a(r, g, b, a).func_181675_d();
                tessellator.func_78381_a();
                GlStateManager.func_179103_j((int)7424);
                GlStateManager.func_179084_k();
                GlStateManager.func_179141_d();
                GlStateManager.func_179098_w();
            } else if (this.screenPercentage > 0) {
                int bw = 0;
                int bh = 0;
                bh = Math.round((float)h / 4.0f * (float)this.screenPercentage / 100.0f);
                bw = Math.round((float)w / 8.0f * (float)this.screenPercentage / 100.0f);
                this.func_73733_a(0, 0, w, bh, this.screenColor, 0);
                this.func_73733_a(0, h - bh, w, h, 0, this.screenColor);
                this.drawGradientRect2(0, 0, bw, h, 0, this.screenColor);
                this.drawGradientRect2(w - bw, 0, w, h, this.screenColor, 0);
            } else {
                int hh = 0;
                hh = Math.round((float)h / 4.0f * (float)this.screenBottomPercentage / 100.0f);
                this.func_73733_a(0, h - hh, w, h, 0, this.screenBottomColor);
            }
            GL11.glEnable((int)2929);
            GlStateManager.func_179121_F();
        }
        if (HalloweenSpecial.shouldRenderOverlay()) {
            this.renderHalloweenOverlay();
        }
    }

    private void handleScreenColorHunter(HunterPlayer hunter) {
        if (hunter.getSpecialAttributes().isDisguised()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getDisguiseProgress());
            this.screenColor = -15658735;
            this.fullScreen = false;
        } else if (hunter.getSpecialAttributes().isVampireNearby()) {
            this.screenPercentage = (int)(100.0f * hunter.getSpecialAttributes().getVampireNearbyProgress());
            this.screenColor = -2135287754;
            this.fullScreen = false;
        } else {
            this.screenPercentage = (int)Math.max(0.0f, (float)this.screenPercentage / 20.0f * 19.0f);
        }
    }

    private void handleScreenColorVampire(VampirePlayer vampire) {
        if (vampire.getActionHandler().isActionActive(VampireActions.vampire_rage)) {
            this.screenPercentage = 100;
            this.screenColor = -1048576;
            this.fullScreen = false;
        } else {
            this.screenPercentage = vampire.getTicksInSun() / 2;
            if (this.screenPercentage > 0) {
                PotionEffect effect = this.mc.field_71439_g.func_70660_b(ModPotions.sunscreen);
                if (effect == null || effect.func_76458_c() < 5) {
                    this.screenColor = -2219;
                    this.fullScreen = false;
                    if (vampire.getRepresentingPlayer().field_71075_bZ.field_75098_d || effect != null && effect.func_76458_c() >= 4) {
                        this.screenPercentage = Math.min(20, this.screenPercentage);
                    }
                } else {
                    this.screenPercentage = 0;
                }
            } else {
                this.screenPercentage = 0;
            }
        }
        if (vampire.getActionHandler().isActionActive(VampireActions.bat)) {
            float batPercentage = vampire.getActionHandler().getPercentageForAction(VampireActions.bat);
            if (batPercentage < 0.2f && batPercentage > 0.0f) {
                this.screenBottomColor = -865048583;
                this.screenBottomPercentage = (int)((0.2f - batPercentage) * 1000.0f);
                this.fullScreen = false;
            } else {
                this.screenBottomPercentage = 0;
            }
        } else {
            this.screenBottomPercentage = 0;
        }
    }

    private void renderBloodFangs(int width, int height, float perc, int color) {
        float r = (float)((color & 0xFF0000) >> 16) / 256.0f;
        float g = (float)((color & 0xFF00) >> 8) / 256.0f;
        float b = (float)(color & 0xFF) / 256.0f;
        this.mc.func_110434_K().func_110577_a(this.icons);
        int left = width / 2 - 8;
        int top = height / 2 - 4;
        GL11.glEnable((int)3042);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.7f);
        this.func_73729_b(left, top, 27, 0, 16, 10);
        GL11.glColor4f((float)r, (float)g, (float)b, (float)0.8f);
        int percHeight = (int)(10.0f * perc);
        this.func_73729_b(left, top + (10 - percHeight), 27, 10 - percHeight, 16, percHeight);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)3042);
    }

    private void renderHalloweenOverlay() {
        GlStateManager.func_179094_E();
        ScaledResolution scaledresolution = new ScaledResolution(this.mc);
        int w = scaledresolution.func_78326_a();
        int h = scaledresolution.func_78328_b();
        Minecraft.func_71410_x().field_71460_t.func_78478_c();
        Minecraft.func_71410_x().field_71446_o.func_110577_a(new ResourceLocation("vampirism", "textures/gui/special_halloween.png"));
        int width = 507;
        int height = 102;
        int x = (w - width) / 2;
        int y = (h - height) / 2;
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        VampirismHUDOverlay.func_146110_a((int)x, (int)y, (float)0.0f, (float)0.0f, (int)width, (int)height, (float)width, (float)height);
        GlStateManager.func_179084_k();
        GlStateManager.func_179121_F();
    }
}

