/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.util;

import de.teamlapen.lib.VampLib;
import de.teamlapen.lib.util.ParticleHandler;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.Particle;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleHandlerClient
extends ParticleHandler {
    @Override
    public void spawnParticle(World world, ResourceLocation particle, double posX, double posY, double posZ, Object ... param) {
        ParticleHandler.ICustomParticleFactory factory = (ParticleHandler.ICustomParticleFactory)factories.get(particle);
        if (factory == null) {
            VampLib.log.w("ParticleHandler", "Particle %s is not registered", particle);
            return;
        }
        Particle fx = factory.createParticle(world, posX, posY, posZ, param);
        this.addParticleToWorld(fx);
    }

    @Override
    public void spawnParticle(World world, ResourceLocation particle, double posX, double posY, double posZ, NBTTagCompound nbt) {
        Object[] data = this.getParticleParam(particle, nbt);
        if (data != null) {
            this.spawnParticle(world, particle, posX, posY, posZ, data);
        }
    }

    @Override
    public void spawnParticles(World world, ResourceLocation particle, double posX, double posY, double posZ, int count, double maxDist, Random random, Object ... param) {
        for (int i = 0; i < count; ++i) {
            this.spawnParticle(world, particle, posX + maxDist * (2.0 * random.nextDouble() - 1.0), posY + (2.0 * random.nextDouble() - 1.0) * maxDist, posZ + (2.0 * random.nextDouble() - 1.0) * maxDist, param);
        }
    }

    @Override
    public void spawnParticles(World world, ResourceLocation particle, double posX, double posY, double posZ, int count, double maxDist, Random random, NBTTagCompound nbt) {
        Object[] data = this.getParticleParam(particle, nbt);
        if (data != null) {
            this.spawnParticles(world, particle, posX, posY, posZ, count, maxDist, random, data);
        }
    }

    private void addParticleToWorld(Particle particle) {
        Minecraft.func_71410_x().field_71452_i.func_78873_a(particle);
    }

    @Nullable
    private Object[] getParticleParam(ResourceLocation particle, NBTTagCompound data) {
        ParticleHandler.ICustomParticleFactory factory = (ParticleHandler.ICustomParticleFactory)factories.get(particle);
        if (factory == null) {
            VampLib.log.w("ParticleHandler", "Particle %s is not registered", particle);
            return null;
        }
        return factory.readParticleInfo(data);
    }
}

