/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.lib.lib.entity;

import net.minecraft.entity.Entity;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class BasicEntityAreaParticleCloud
extends Entity {
    private static final DataParameter<Float> RADIUS = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Float> HEIGHT = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> PARTICLE = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> SPAWN_RATE = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187193_c);
    private static final DataParameter<Integer> PARTICLE_ARGUMENT_ONE = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> PARTICLE_ARGUMENT_TWO = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR = EntityDataManager.func_187226_a(BasicEntityAreaParticleCloud.class, (DataSerializer)DataSerializers.field_187192_b);
    private int duration = 60;
    private int waitTime = 0;
    private float radiusPerTick = 0.0f;

    public BasicEntityAreaParticleCloud(World worldIn) {
        super(worldIn);
        this.field_70145_X = true;
        this.field_70178_ae = true;
        this.setRadius(3.0f);
    }

    public int getColor() {
        return (Integer)this.func_184212_Q().func_187225_a(COLOR);
    }

    public void setColor(int colorIn) {
        this.func_184212_Q().func_187227_b(COLOR, (Object)colorIn);
    }

    public int getDuration() {
        return this.duration;
    }

    public void setDuration(int duration) {
        this.duration = duration;
    }

    public float getHeight() {
        return ((Float)this.func_184212_Q().func_187225_a(HEIGHT)).floatValue();
    }

    public void setHeight(float height) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.func_70105_a(this.getRadius() * 2.0f, height);
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(HEIGHT, (Object)Float.valueOf(height));
        }
    }

    public EnumParticleTypes getParticle() {
        return EnumParticleTypes.func_179342_a((int)((Integer)this.func_184212_Q().func_187225_a(PARTICLE)));
    }

    public void setParticle(EnumParticleTypes particleIn) {
        this.func_184212_Q().func_187227_b(PARTICLE, (Object)particleIn.func_179348_c());
    }

    public int getParticleArgumentOne() {
        return (Integer)this.func_184212_Q().func_187225_a(PARTICLE_ARGUMENT_ONE);
    }

    public void setParticleArgumentOne(int value) {
        this.func_184212_Q().func_187227_b(PARTICLE_ARGUMENT_ONE, (Object)value);
    }

    public int getParticleArgumentTwo() {
        return (Integer)this.func_184212_Q().func_187225_a(PARTICLE_ARGUMENT_TWO);
    }

    public float getRadius() {
        return ((Float)this.func_184212_Q().func_187225_a(RADIUS)).floatValue();
    }

    public void setRadius(float radius) {
        double d0 = this.field_70165_t;
        double d1 = this.field_70163_u;
        double d2 = this.field_70161_v;
        this.func_70105_a(radius * 2.0f, this.getHeight());
        this.func_70107_b(d0, d1, d2);
        if (!this.field_70170_p.field_72995_K) {
            this.func_184212_Q().func_187227_b(RADIUS, (Object)Float.valueOf(radius));
        }
    }

    public float getSpawnRate() {
        return ((Float)this.func_184212_Q().func_187225_a(SPAWN_RATE)).floatValue();
    }

    public void setSpawnRate(float rate) {
        this.func_184212_Q().func_187227_b(SPAWN_RATE, (Object)Float.valueOf(rate));
    }

    public int getWaitTime() {
        return this.waitTime;
    }

    public void setWaitTime(int waitTime) {
        this.waitTime = waitTime;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        float radius = this.getRadius();
        if (this.field_70170_p.field_72995_K) {
            EnumParticleTypes enumParticleTypes = this.getParticle();
            int[] aint = new int[enumParticleTypes.func_179345_d()];
            if (aint.length > 0) {
                aint[0] = this.getParticleArgumentOne();
            }
            if (aint.length > 1) {
                aint[1] = this.getParticleArgumentTwo();
            }
            float amount = (float)(Math.PI * (double)radius * (double)radius) * this.getSpawnRate();
            int i = 0;
            while ((float)i < amount) {
                float phi = this.field_70146_Z.nextFloat() * (float)Math.PI * 2.0f;
                float r = MathHelper.func_76129_c((float)this.field_70146_Z.nextFloat()) * radius;
                float dx = MathHelper.func_76134_b((float)phi) * r;
                float dz = MathHelper.func_76126_a((float)phi) * r;
                float dy = this.field_70146_Z.nextFloat() * this.getHeight();
                if (enumParticleTypes == EnumParticleTypes.SPELL_MOB) {
                    int rgb = this.getColor();
                    int cr = rgb >> 16 & 0xFF;
                    int cg = rgb >> 8 & 0xFF;
                    int cb = rgb & 0xFF;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.SPELL_MOB, this.field_70165_t + (double)dx, this.field_70163_u + (double)dy, this.field_70161_v + (double)dz, (double)((float)cr / 255.0f), (double)((float)cg / 255.0f), (double)((float)cb / 255.0f), new int[0]);
                } else {
                    this.field_70170_p.func_175688_a(enumParticleTypes, this.field_70165_t + (double)dx, this.field_70163_u + (double)dy, this.field_70161_v + (double)dz, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, (double)0.01f, (0.5 - this.field_70146_Z.nextDouble()) * 0.15, aint);
                }
                ++i;
            }
        } else {
            if (this.field_70173_aa >= this.waitTime + this.duration) {
                this.func_70106_y();
                return;
            }
            if (this.field_70173_aa < this.waitTime) {
                return;
            }
            if (this.radiusPerTick != 0.0f) {
                if ((radius += this.radiusPerTick) < 0.3f) {
                    this.func_70106_y();
                    return;
                }
                this.setRadius(radius);
            }
        }
    }

    public void setGetParticleArgumentTwo(int value) {
        this.func_184212_Q().func_187227_b(PARTICLE_ARGUMENT_TWO, (Object)value);
    }

    public void setRadiusPerTick(float radiusPerTick) {
        this.radiusPerTick = radiusPerTick;
    }

    public boolean func_184198_c(NBTTagCompound compound) {
        return false;
    }

    public boolean func_70039_c(NBTTagCompound compound) {
        return false;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(COLOR, (Object)0);
        this.func_184212_Q().func_187214_a(RADIUS, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(HEIGHT, (Object)Float.valueOf(0.5f));
        this.func_184212_Q().func_187214_a(PARTICLE, (Object)EnumParticleTypes.SPELL_MOB.func_179348_c());
        this.func_184212_Q().func_187214_a(PARTICLE_ARGUMENT_ONE, (Object)0);
        this.func_184212_Q().func_187214_a(PARTICLE_ARGUMENT_TWO, (Object)0);
        this.func_184212_Q().func_187214_a(SPAWN_RATE, (Object)Float.valueOf(1.0f));
    }

    protected void func_70037_a(NBTTagCompound compound) {
    }

    protected void func_70014_b(NBTTagCompound compound) {
    }
}

