/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.common.internal;

import com.google.common.base.Predicates;
import com.google.common.collect.MultimapBuilder;
import com.google.common.collect.SetMultimap;
import java.util.Collection;
import java.util.Iterator;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.WorldServer;
import net.minecraftforge.common.DimensionManager;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import thecodex6824.thaumicaugmentation.api.impetus.node.IImpetusNode;
import thecodex6824.thaumicaugmentation.api.internal.IInternalMethodProvider;
import thecodex6824.thaumicaugmentation.api.util.DimensionalBlockPos;
import thecodex6824.thaumicaugmentation.common.TAConfigHolder;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterEffectProvider;
import thecodex6824.thaumicaugmentation.common.item.ItemCustomCasterStrengthProvider;
import thecodex6824.thaumicaugmentation.common.network.PacketFullImpetusNodeSync;
import thecodex6824.thaumicaugmentation.common.network.PacketImpetusNodeUpdate;
import thecodex6824.thaumicaugmentation.common.network.PacketImpetusTransaction;
import thecodex6824.thaumicaugmentation.common.network.TANetwork;

public class InternalMethodProvider
implements IInternalMethodProvider {
    @Override
    public void addConfigListener(Runnable listener) {
        TAConfigHolder.addListener(listener);
    }

    @Override
    public boolean removeConfigListener(Runnable listener) {
        return TAConfigHolder.removeListener(listener);
    }

    @Override
    public ItemStack createCasterStrengthProviderStack(ResourceLocation id) {
        return ItemCustomCasterStrengthProvider.create(id);
    }

    @Override
    public String getCasterStrengthProviderID(ItemStack stack) {
        return ItemCustomCasterStrengthProvider.getProviderIDString(stack);
    }

    @Override
    public ItemStack createCasterEffectProviderStack(ResourceLocation id) {
        return ItemCustomCasterEffectProvider.create(id);
    }

    @Override
    public String getCasterEffectProviderID(ItemStack stack) {
        return ItemCustomCasterEffectProvider.getProviderIDString(stack);
    }

    @Override
    public void syncImpetusTransaction(Collection<IImpetusNode> path) {
        DimensionalBlockPos[] positions = new DimensionalBlockPos[path.size()];
        SetMultimap chunks = MultimapBuilder.hashKeys().hashSetValues().build();
        int i = 0;
        for (IImpetusNode node : path) {
            DimensionalBlockPos newPos;
            positions[i] = newPos = new DimensionalBlockPos(node.getLocation().getPos().func_185334_h(), node.getLocation().getDimension());
            ++i;
            chunks.put((Object)newPos.getDimension(), (Object)new ChunkPos(newPos.getPos()));
        }
        PacketImpetusTransaction packet = new PacketImpetusTransaction(positions);
        Iterator iterator = chunks.keySet().iterator();
        while (iterator.hasNext()) {
            int dim = (Integer)iterator.next();
            WorldServer world = DimensionManager.getWorld((int)dim);
            if (world == null) continue;
            block2: for (EntityPlayerMP player : world.func_175661_b(EntityPlayerMP.class, Predicates.alwaysTrue())) {
                for (ChunkPos pos : chunks.get((Object)dim)) {
                    if (!world.func_184164_w().func_72694_a(player, pos.field_77276_a, pos.field_77275_b)) continue;
                    TANetwork.INSTANCE.sendTo((IMessage)packet, player);
                    continue block2;
                }
            }
        }
    }

    @Override
    public void fullySyncImpetusNode(IImpetusNode node) {
        DimensionalBlockPos pos = node.getLocation();
        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketFullImpetusNodeSync(pos.getPos(), node.getSyncNBT()), new NetworkRegistry.TargetPoint(pos.getDimension(), (double)pos.getPos().func_177958_n() + 0.5, (double)pos.getPos().func_177956_o() + 0.5, (double)pos.getPos().func_177952_p() + 0.5, 64.0));
    }

    @Override
    public void updateImpetusNode(IImpetusNode node, DimensionalBlockPos connection, boolean output, boolean remove) {
        DimensionalBlockPos pos = node.getLocation();
        TANetwork.INSTANCE.sendToAllTracking((IMessage)new PacketImpetusNodeUpdate(pos.getPos(), connection, output, remove), new NetworkRegistry.TargetPoint(pos.getDimension(), (double)pos.getPos().func_177958_n() + 0.5, (double)pos.getPos().func_177956_o() + 0.5, (double)pos.getPos().func_177952_p() + 0.5, 64.0));
    }
}

