/*
 * Decompiled with CFR 0.152.
 */
package thecodex6824.thaumicaugmentation.api.event;

import java.util.UUID;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Cancelable;
import thecodex6824.thaumicaugmentation.api.ward.storage.CapabilityWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.ClientWardStorageValue;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorage;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageClient;
import thecodex6824.thaumicaugmentation.api.ward.storage.IWardStorageServer;

public abstract class BlockWardEvent<T extends IWardStorage>
extends BlockEvent {
    protected T storage;

    public BlockWardEvent(World world, BlockPos pos) {
        super(world, pos, world.func_180495_p(pos));
        this.storage = (IWardStorage)world.func_175726_f(pos).getCapability(CapabilityWardStorage.WARD_STORAGE, null);
    }

    public T getChunkWardStorage() {
        return this.storage;
    }

    public static abstract class DewardedServer
    extends BlockWardEvent<IWardStorageServer> {
        public DewardedServer(World world, BlockPos pos) {
            super(world, pos);
        }

        public static class Post
        extends DewardedServer {
            public Post(World world, BlockPos pos) {
                super(world, pos);
            }
        }

        @Cancelable
        public static class Pre
        extends DewardedServer {
            public Pre(World world, BlockPos pos) {
                super(world, pos);
            }
        }
    }

    public static abstract class DewardedClient
    extends BlockWardEvent<IWardStorageClient> {
        public DewardedClient(World world, BlockPos pos) {
            super(world, pos);
        }

        public static class Post
        extends DewardedClient {
            public Post(World world, BlockPos pos) {
                super(world, pos);
            }
        }

        @Cancelable
        public static class Pre
        extends DewardedClient {
            public Pre(World world, BlockPos pos) {
                super(world, pos);
            }
        }
    }

    public static abstract class WardedServer
    extends BlockWardEvent<IWardStorageServer> {
        protected UUID val;

        public WardedServer(World world, BlockPos pos, UUID newVal) {
            super(world, pos);
            this.val = newVal;
        }

        public UUID getNewOwner() {
            return this.val;
        }

        public static class Post
        extends WardedServer {
            public Post(World world, BlockPos pos, UUID newVal) {
                super(world, pos, newVal);
            }
        }

        @Cancelable
        public static class Pre
        extends WardedServer {
            public Pre(World world, BlockPos pos, UUID newVal) {
                super(world, pos, newVal);
            }
        }
    }

    public static abstract class WardedClient
    extends BlockWardEvent<IWardStorageClient> {
        protected ClientWardStorageValue val;

        public WardedClient(World world, BlockPos pos, ClientWardStorageValue newVal) {
            super(world, pos);
            this.val = newVal;
        }

        public ClientWardStorageValue getNewOwner() {
            return this.val;
        }

        public static class Post
        extends WardedClient {
            public Post(World world, BlockPos pos, ClientWardStorageValue newVal) {
                super(world, pos, newVal);
            }
        }

        @Cancelable
        public static class Pre
        extends WardedClient {
            public Pre(World world, BlockPos pos, ClientWardStorageValue newVal) {
                super(world, pos, newVal);
            }
        }
    }
}

