/*
 * Decompiled with CFR 0.152.
 */
package vswe.superfactory.components;

import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import vswe.superfactory.Localization;
import vswe.superfactory.components.CheckBox;
import vswe.superfactory.components.CheckBoxList;
import vswe.superfactory.components.ComponentMenu;
import vswe.superfactory.components.ComponentMenuItem;
import vswe.superfactory.components.FlowComponent;
import vswe.superfactory.components.TextBoxNumber;
import vswe.superfactory.components.TextBoxNumberList;
import vswe.superfactory.components.internal.ConnectionSet;
import vswe.superfactory.components.internal.ItemSetting;
import vswe.superfactory.interfaces.ContainerManager;
import vswe.superfactory.interfaces.GuiManager;
import vswe.superfactory.network.packets.DataBitHelper;
import vswe.superfactory.network.packets.DataReader;
import vswe.superfactory.network.packets.DataWriter;
import vswe.superfactory.network.packets.PacketHandler;

public class ComponentMenuUpdateBlock
extends ComponentMenuItem {
    private static final int CHECKBOX_OFFSET = 2;
    private static final int ID_START_X = 1;
    private static final int ID_START_Y = 1;
    private static final int ID_TEXT_BOX = 48;
    private static final int META_BITS = 4;
    private static final int META_INVERTED_OFFSET = 83;
    private static final int META_SETTINGS = 3;
    private static final int META_SPACING = 17;
    private static final int META_START_X = 1;
    private static final int META_START_Y = 21;
    private static final int META_TEXT_BOX_OFFSET_1 = 37;
    private static final int META_TEXT_BOX_OFFSET_2 = 58;
    private static final int META_TEXT_X = 3;
    private static final int META_TEXT_Y = 17;
    private static final String NBT_BITS = "Bits";
    private static final String NBT_HIGH = "High";
    private static final String NBT_ID = "BlockId";
    private static final String NBT_INVERTED = "Inverted";
    private static final String NBT_LOW = "Low";
    private static final String NBT_SETTINGS = "Meta";
    private static final String NBT_USE_ID = "UseId";
    private CheckBoxList checkBoxes;
    private boolean idInverted;
    private MetaSetting[] settings = new MetaSetting[3];
    private TextBoxNumberList textBoxes = new TextBoxNumberList();
    private boolean useId;

    public ComponentMenuUpdateBlock(FlowComponent parent) {
        super(parent);
        this.checkBoxes = new CheckBoxList();
        this.scrollControllerSelected.setItemsPerRow(1);
        this.scrollControllerSelected.setVisibleRows(1);
        this.scrollControllerSelected.setItemUpperLimit(-2);
        this.scrollControllerSelected.setX(59);
        this.checkBoxes.addCheckBox(new CheckBox(Localization.USE_ID, 1, 3){

            @Override
            public boolean getValue() {
                return ComponentMenuUpdateBlock.this.useId;
            }

            @Override
            public void setValue(boolean val) {
                ComponentMenuUpdateBlock.this.useId = val;
            }

            @Override
            public void onUpdate() {
                ComponentMenuUpdateBlock.this.sendServerData(0, 0);
            }
        });
        this.checkBoxes.addCheckBox(new CheckBox(Localization.INVERT, 84, 3){

            @Override
            public void setValue(boolean val) {
                ComponentMenuUpdateBlock.this.idInverted = val;
            }

            @Override
            public boolean getValue() {
                return ComponentMenuUpdateBlock.this.idInverted;
            }

            @Override
            public void onUpdate() {
                ComponentMenuUpdateBlock.this.sendServerData(0, 2);
            }

            @Override
            public boolean isVisible() {
                return ComponentMenuUpdateBlock.this.useId;
            }
        });
        for (int i = 0; i < 3; ++i) {
            final int setting = i;
            this.settings[setting] = new MetaSetting();
            for (int j = 0; j < this.settings[setting].bits.length; ++j) {
                final int bit = j;
                this.checkBoxes.addCheckBox(new CheckBox(null, 1 + (this.settings[setting].bits.length - (bit + 1)) * 8, 23 + setting * 17){

                    @Override
                    public void setValue(boolean val) {
                        ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].bits[bit] = val;
                        if (!val) {
                            ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].lowerTextBox.setNumber(((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].lowerTextBox.getNumber());
                            ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].higherTextBox.setNumber(((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].higherTextBox.getNumber());
                        }
                    }

                    @Override
                    public boolean getValue() {
                        return ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].bits[bit];
                    }

                    @Override
                    public void onUpdate() {
                        ComponentMenuUpdateBlock.this.sendServerData(setting + 1, bit);
                    }
                });
                this.settings[setting].bits[bit] = setting == 0;
            }
            this.settings[setting].lowerTextBox = new TextBoxNumber(38, 21 + setting * 17, 2, false){

                @Override
                public int getMaxNumber() {
                    return ComponentMenuUpdateBlock.this.settings[setting].getMaxNumber();
                }

                @Override
                public void onNumberChanged() {
                    ComponentMenuUpdateBlock.this.sendServerData(setting + 1, 4);
                }

                @Override
                public boolean isVisible() {
                    return ComponentMenuUpdateBlock.this.settings[setting].inUse();
                }
            };
            this.textBoxes.addTextBox(this.settings[setting].lowerTextBox);
            this.settings[setting].higherTextBox = new TextBoxNumber(59, 21 + setting * 17, 2, false){

                @Override
                public int getMaxNumber() {
                    return ComponentMenuUpdateBlock.this.settings[setting].getMaxNumber();
                }

                @Override
                public void onNumberChanged() {
                    ComponentMenuUpdateBlock.this.sendServerData(setting + 1, 5);
                }

                @Override
                public boolean isVisible() {
                    return ComponentMenuUpdateBlock.this.settings[setting].inUse();
                }
            };
            this.textBoxes.addTextBox(this.settings[setting].higherTextBox);
            this.checkBoxes.addCheckBox(new CheckBox(Localization.INVERT, 84, 23 + setting * 17){

                @Override
                public void setValue(boolean val) {
                    ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].inverted = val;
                }

                @Override
                public boolean getValue() {
                    return ((ComponentMenuUpdateBlock)ComponentMenuUpdateBlock.this).settings[setting].inverted;
                }

                @Override
                public void onUpdate() {
                    ComponentMenuUpdateBlock.this.sendServerData(setting + 1, 6);
                }

                @Override
                public boolean isVisible() {
                    return ComponentMenuUpdateBlock.this.settings[setting].inUse();
                }
            });
            this.settings[setting].higherTextBox.setNumber(15);
        }
    }

    private void sendServerData(int id, int subId) {
        DataWriter dw = this.getWriterForServerComponentPacket();
        this.writeData(dw, id, subId);
        PacketHandler.sendDataToServer(dw);
    }

    private void writeData(DataWriter dw, int id, int subId) {
        dw.writeBoolean(false);
        dw.writeBoolean(true);
        dw.writeData(id, DataBitHelper.BUD_SYNC_TYPE);
        dw.writeData(subId, id == 0 ? DataBitHelper.BUD_SYNC_SUB_TYPE_SHORT : DataBitHelper.BUD_SYNC_SUB_TYPE_LONG);
        if (id == 0) {
            if (subId == 0) {
                dw.writeBoolean(this.useId);
            } else if (subId == 2) {
                dw.writeBoolean(this.idInverted);
            }
        } else {
            MetaSetting setting = this.settings[--id];
            if (subId < 4) {
                dw.writeBoolean(setting.bits[subId]);
            } else if (subId == 4) {
                dw.writeData(setting.lowerTextBox.getNumber(), DataBitHelper.BLOCK_META);
            } else if (subId == 5) {
                dw.writeData(setting.higherTextBox.getNumber(), DataBitHelper.BLOCK_META);
            } else if (subId == 6) {
                dw.writeBoolean(setting.inverted);
            }
        }
    }

    public boolean useId() {
        return this.useId;
    }

    public int getBlockId() {
        ItemSetting itemSetting = (ItemSetting)this.getSettings().get(0);
        return itemSetting.getItem().func_190926_b() ? 0 : Item.func_150891_b((Item)itemSetting.getItem().func_77973_b());
    }

    public boolean isIdInverted() {
        return this.idInverted;
    }

    public MetaSetting[] getMetaSettings() {
        return this.settings;
    }

    @Override
    public String getName() {
        return Localization.UPDATE_BLOCK_MENU.toString();
    }

    @Override
    public void onClick(int mX, int mY, int button) {
        if (!this.isEditing() && !this.isSearching()) {
            this.textBoxes.onClick(mX, mY, button);
            this.checkBoxes.onClick(mX, mY);
            if (this.useId) {
                super.onClick(mX, mY, button);
            }
        } else {
            super.onClick(mX, mY, button);
        }
    }

    @Override
    public void refreshData(ContainerManager container, ComponentMenu newData) {
        super.refreshData(container, newData);
        ComponentMenuUpdateBlock newDataUpdate = (ComponentMenuUpdateBlock)newData;
        if (this.useId != newDataUpdate.useId) {
            this.useId = newDataUpdate.useId;
            this.sendClientData(container, 0, 0);
        }
        if (this.idInverted != newDataUpdate.idInverted) {
            this.idInverted = newDataUpdate.idInverted;
            this.sendClientData(container, 0, 2);
        }
        for (int i = 0; i < this.settings.length; ++i) {
            int id = i + 1;
            MetaSetting setting = this.settings[i];
            MetaSetting newSetting = newDataUpdate.settings[i];
            for (int j = 0; j < setting.bits.length; ++j) {
                if (setting.bits[j] == newSetting.bits[j]) continue;
                setting.bits[j] = newSetting.bits[j];
                this.sendClientData(container, id, j);
            }
            if (setting.lowerTextBox.getNumber() != newSetting.lowerTextBox.getNumber()) {
                setting.lowerTextBox.setNumber(newSetting.lowerTextBox.getNumber());
                this.sendClientData(container, id, 4);
            }
            if (setting.higherTextBox.getNumber() != newSetting.higherTextBox.getNumber()) {
                setting.higherTextBox.setNumber(newSetting.higherTextBox.getNumber());
                this.sendClientData(container, id, 5);
            }
            if (setting.inverted == newSetting.inverted) continue;
            setting.inverted = newSetting.inverted;
            this.sendClientData(container, id, 6);
        }
    }

    private void sendClientData(ContainerManager container, int id, int subId) {
        DataWriter dw = this.getWriterForClientComponentPacket(container);
        this.writeData(dw, id, subId);
        PacketHandler.sendDataToListeningClients(container, dw);
    }

    @Override
    public boolean isVisible() {
        return this.getParent().getConnectionSet() == ConnectionSet.BUD;
    }

    @Override
    protected void initRadioButtons() {
    }

    @Override
    protected int getSettingCount() {
        return 1;
    }

    @Override
    protected void writeRadioButtonRefreshState(DataWriter dw, boolean value) {
        dw.writeBoolean(false);
        super.writeRadioButtonRefreshState(dw, value);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void draw(GuiManager gui, int mX, int mY) {
        if (!this.isEditing() && !this.isSearching()) {
            this.textBoxes.draw(gui, mX, mY);
            this.checkBoxes.draw(gui, mX, mY);
            gui.drawString(Localization.META.toString(), 3, 17, 0.7f, 0x404040);
            if (this.useId) {
                super.draw(gui, mX, mY);
            }
        } else {
            super.draw(gui, mX, mY);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void drawMouseOver(GuiManager gui, int mX, int mY) {
        if (this.isEditing() || this.isSearching() || this.useId) {
            super.drawMouseOver(gui, mX, mY);
        }
    }

    @Override
    public void onDrag(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    public void onRelease(int mX, int mY, boolean isMenuOpen) {
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean onKeyStroke(GuiManager gui, char c, int k) {
        if (!this.isEditing() && !this.isSearching()) {
            return this.textBoxes.onKeyStroke(gui, c, k);
        }
        return super.onKeyStroke(gui, c, k);
    }

    @Override
    public void writeData(DataWriter dw) {
        super.writeData(dw);
        dw.writeBoolean(this.useId);
        dw.writeBoolean(this.idInverted);
        for (MetaSetting setting : this.settings) {
            for (boolean bit : setting.bits) {
                dw.writeBoolean(bit);
            }
            dw.writeData(setting.lowerTextBox.getNumber(), DataBitHelper.BLOCK_META);
            dw.writeData(setting.higherTextBox.getNumber(), DataBitHelper.BLOCK_META);
            dw.writeBoolean(setting.inverted);
        }
    }

    @Override
    public void readData(DataReader dr) {
        super.readData(dr);
        this.useId = dr.readBoolean();
        this.idInverted = dr.readBoolean();
        for (MetaSetting setting : this.settings) {
            for (int i = 0; i < setting.bits.length; ++i) {
                setting.bits[i] = dr.readBoolean();
            }
            setting.lowerTextBox.setNumber(dr.readData(DataBitHelper.BLOCK_META));
            setting.higherTextBox.setNumber(dr.readData(DataBitHelper.BLOCK_META));
            setting.inverted = dr.readBoolean();
        }
    }

    @Override
    public void copyFrom(ComponentMenu menu) {
        super.copyFrom(menu);
        ComponentMenuUpdateBlock menuUpdate = (ComponentMenuUpdateBlock)menu;
        this.useId = menuUpdate.useId;
        this.idInverted = menuUpdate.idInverted;
        for (int i = 0; i < this.settings.length; ++i) {
            for (int j = 0; j < this.settings[i].bits.length; ++j) {
                this.settings[i].bits[j] = menuUpdate.settings[i].bits[j];
            }
            this.settings[i].lowerTextBox.setNumber(menuUpdate.settings[i].lowerTextBox.getNumber());
            this.settings[i].higherTextBox.setNumber(menuUpdate.settings[i].higherTextBox.getNumber());
            this.settings[i].inverted = menuUpdate.settings[i].inverted;
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nbtTagCompound, int version, boolean pickup) {
        if (version >= 11) {
            super.readFromNBT(nbtTagCompound, version, pickup);
        } else {
            ItemSetting setting = (ItemSetting)this.getSettings().get(0);
            setting.setItem(new ItemStack(Item.func_150899_d((int)nbtTagCompound.func_74765_d(NBT_ID))));
        }
        this.useId = nbtTagCompound.func_74767_n(NBT_USE_ID);
        this.idInverted = nbtTagCompound.func_74767_n(NBT_INVERTED);
        NBTTagList list = nbtTagCompound.func_150295_c(NBT_SETTINGS, 10);
        for (int i = 0; i < list.func_74745_c(); ++i) {
            MetaSetting setting = this.settings[i];
            NBTTagCompound settingTag = list.func_150305_b(i);
            byte bits = settingTag.func_74771_c(NBT_BITS);
            for (int j = 0; j < setting.bits.length; ++j) {
                setting.bits[j] = (bits >> j & 1) != 0;
            }
            setting.lowerTextBox.setNumber(settingTag.func_74771_c(NBT_LOW));
            setting.higherTextBox.setNumber(settingTag.func_74771_c(NBT_HIGH));
            setting.inverted = settingTag.func_74767_n(NBT_INVERTED);
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbtTagCompound, boolean pickup) {
        super.writeToNBT(nbtTagCompound, pickup);
        nbtTagCompound.func_74757_a(NBT_USE_ID, this.useId);
        nbtTagCompound.func_74757_a(NBT_INVERTED, this.idInverted);
        NBTTagList list = new NBTTagList();
        for (MetaSetting setting : this.settings) {
            NBTTagCompound settingTag = new NBTTagCompound();
            byte bits = 0;
            for (int i = 0; i < setting.bits.length; ++i) {
                if (!setting.bits[i]) continue;
                bits = (byte)(bits | 1 << i);
            }
            settingTag.func_74774_a(NBT_BITS, bits);
            settingTag.func_74774_a(NBT_LOW, (byte)setting.lowerTextBox.getNumber());
            settingTag.func_74774_a(NBT_HIGH, (byte)setting.higherTextBox.getNumber());
            settingTag.func_74757_a(NBT_INVERTED, setting.inverted);
            list.func_74742_a((NBTBase)settingTag);
        }
        nbtTagCompound.func_74782_a(NBT_SETTINGS, (NBTBase)list);
    }

    @Override
    public void addErrors(List<String> errors) {
        if (this.useId) {
            super.addErrors(errors);
        }
    }

    @Override
    protected void readNonSettingData(DataReader dr) {
        if (dr.readBoolean()) {
            int id = dr.readData(DataBitHelper.BUD_SYNC_TYPE);
            if (id == 0) {
                int subId = dr.readData(DataBitHelper.BUD_SYNC_SUB_TYPE_SHORT);
                if (subId == 0) {
                    this.useId = dr.readBoolean();
                } else if (subId == 2) {
                    this.idInverted = dr.readBoolean();
                }
            } else {
                MetaSetting setting = this.settings[--id];
                int subId = dr.readData(DataBitHelper.BUD_SYNC_SUB_TYPE_LONG);
                if (subId < 4) {
                    setting.bits[subId] = dr.readBoolean();
                    if (!setting.bits[subId]) {
                        setting.lowerTextBox.setNumber(setting.lowerTextBox.getNumber());
                        setting.higherTextBox.setNumber(setting.higherTextBox.getNumber());
                    }
                } else if (subId == 4) {
                    setting.lowerTextBox.setNumber(dr.readData(DataBitHelper.BLOCK_META));
                } else if (subId == 5) {
                    setting.higherTextBox.setNumber(dr.readData(DataBitHelper.BLOCK_META));
                } else if (subId == 6) {
                    setting.inverted = dr.readBoolean();
                }
            }
        } else {
            super.readNonSettingData(dr);
        }
    }

    public class MetaSetting {
        public boolean[] bits = new boolean[4];
        public TextBoxNumber higherTextBox;
        public boolean inverted;
        public TextBoxNumber lowerTextBox;

        public boolean inUse() {
            return this.selectedBits() > 0;
        }

        private int selectedBits() {
            int count = 0;
            for (boolean bit : this.bits) {
                if (!bit) continue;
                ++count;
            }
            return count;
        }

        public int getMaxNumber() {
            return (int)Math.pow(2.0, this.selectedBits()) - 1;
        }
    }
}

