/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.jaquadro.minecraft.storagedrawers.api.storage.attribute.IFrameable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ItemCustomTrim
extends ItemBlock
implements IFrameable {
    public ItemCustomTrim(Block block) {
        super(block);
    }

    public boolean placeBlockAt(@Nonnull ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, IBlockState newState) {
        if (!super.placeBlockAt(stack, player, world, pos, side, hitX, hitY, hitZ, newState)) {
            return false;
        }
        TileEntityTrim tile = (TileEntityTrim)world.func_175625_s(pos);
        if (tile != null && stack.func_77942_o() && !stack.func_77978_p().func_74764_b("tile")) {
            if (stack.func_77978_p().func_74764_b("MatS")) {
                tile.material().setSide(new ItemStack(stack.func_77978_p().func_74775_l("MatS")));
            }
            if (stack.func_77978_p().func_74764_b("MatT")) {
                tile.material().setTrim(new ItemStack(stack.func_77978_p().func_74775_l("MatT")));
            }
        }
        return true;
    }

    @Nonnull
    public static ItemStack makeItemStack(Block block, int count, @Nonnull ItemStack matSide, @Nonnull ItemStack matTrim) {
        Item item = Item.func_150898_a((Block)block);
        if (!(item instanceof ItemCustomTrim)) {
            return ItemStack.field_190927_a;
        }
        NBTTagCompound tag = new NBTTagCompound();
        if (!matSide.func_190926_b()) {
            tag.func_74782_a("MatS", (NBTBase)ItemCustomTrim.getMaterialTag(matSide));
        }
        if (!matTrim.func_190926_b()) {
            tag.func_74782_a("MatT", (NBTBase)ItemCustomTrim.getMaterialTag(matTrim));
        }
        ItemStack stack = new ItemStack(item, count, 0);
        if (!tag.func_82582_d()) {
            stack.func_77982_d(tag);
        }
        return stack;
    }

    private static NBTTagCompound getMaterialTag(@Nonnull ItemStack mat) {
        mat = mat.func_77946_l();
        mat.func_190920_e(1);
        NBTTagCompound itag = new NBTTagCompound();
        mat.func_77955_b(itag);
        return itag;
    }

    @Override
    public ItemStack decorate(ItemStack input, ItemStack matSide, ItemStack matTrim, ItemStack matFront) {
        return ItemCustomTrim.makeItemStack(Block.func_149634_a((Item)input.func_77973_b()), 1, matSide, matTrim);
    }
}

