/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.core;

import com.jaquadro.minecraft.chameleon.Chameleon;
import com.jaquadro.minecraft.chameleon.resources.ModelRegistry;
import com.jaquadro.minecraft.chameleon.resources.register.IUnifiedRegister;
import com.jaquadro.minecraft.storagedrawers.StorageDrawers;
import com.jaquadro.minecraft.storagedrawers.api.storage.EnumBasicDrawer;
import com.jaquadro.minecraft.storagedrawers.block.BlockCompDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockController;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawers;
import com.jaquadro.minecraft.storagedrawers.block.BlockDrawersCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.BlockKeyButton;
import com.jaquadro.minecraft.storagedrawers.block.BlockSlave;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrim;
import com.jaquadro.minecraft.storagedrawers.block.BlockTrimCustom;
import com.jaquadro.minecraft.storagedrawers.block.BlockVariantDrawers;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityController;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersComp;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityDrawersStandard;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityFramingTable;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityKeyButton;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntitySlave;
import com.jaquadro.minecraft.storagedrawers.block.tile.TileEntityTrim;
import com.jaquadro.minecraft.storagedrawers.client.model.BasicDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CompDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CustomDrawerModel;
import com.jaquadro.minecraft.storagedrawers.client.model.CustomTrimModel;
import com.jaquadro.minecraft.storagedrawers.client.model.FramingTableModel;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityDrawersRenderer;
import com.jaquadro.minecraft.storagedrawers.client.renderer.TileEntityFramingRenderer;
import com.jaquadro.minecraft.storagedrawers.config.ConfigManager;
import com.jaquadro.minecraft.storagedrawers.item.ItemBasicDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCompDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemController;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomDrawers;
import com.jaquadro.minecraft.storagedrawers.item.ItemCustomTrim;
import com.jaquadro.minecraft.storagedrawers.item.ItemFramingTable;
import com.jaquadro.minecraft.storagedrawers.item.ItemKeyButton;
import com.jaquadro.minecraft.storagedrawers.item.ItemTrim;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPlanks;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModBlocks {
    @GameRegistry.ObjectHolder(value="storagedrawers:basicdrawers")
    public static BlockDrawers basicDrawers;
    @GameRegistry.ObjectHolder(value="storagedrawers:compdrawers")
    public static BlockCompDrawers compDrawers;
    @GameRegistry.ObjectHolder(value="storagedrawers:controller")
    public static BlockController controller;
    @GameRegistry.ObjectHolder(value="storagedrawers:controllerslave")
    public static BlockSlave controllerSlave;
    @GameRegistry.ObjectHolder(value="storagedrawers:trim")
    public static BlockTrim trim;
    @GameRegistry.ObjectHolder(value="storagedrawers:framingtable")
    public static BlockFramingTable framingTable;
    @GameRegistry.ObjectHolder(value="storagedrawers:customdrawers")
    public static BlockDrawersCustom customDrawers;
    @GameRegistry.ObjectHolder(value="storagedrawers:customtrim")
    public static BlockTrimCustom customTrim;
    @GameRegistry.ObjectHolder(value="storagedrawers:keybutton")
    public static BlockKeyButton keyButton;

    @Mod.EventBusSubscriber(modid="storagedrawers")
    public static class Registration {
        private static final ResourceLocation EMPTY_GROUP = new ResourceLocation("", "");

        @SubscribeEvent
        public static void registerBlocks(RegistryEvent.Register<Block> event) {
            IForgeRegistry registry = event.getRegistry();
            ConfigManager config = StorageDrawers.config;
            registry.registerAll((IForgeRegistryEntry[])new Block[]{new BlockVariantDrawers("basicdrawers", "storagedrawers.basicDrawers"), new BlockKeyButton("keybutton", "storagedrawers.keyButton")});
            GameRegistry.registerTileEntity(TileEntityDrawersStandard.Legacy.class, (String)"storagedrawers:basicdrawers");
            GameRegistry.registerTileEntity(TileEntityDrawersStandard.Slot1.class, (String)"storagedrawers:basicdrawers.1");
            GameRegistry.registerTileEntity(TileEntityDrawersStandard.Slot2.class, (String)"storagedrawers:basicdrawers.2");
            GameRegistry.registerTileEntity(TileEntityDrawersStandard.Slot4.class, (String)"storagedrawers:basicdrawers.4");
            GameRegistry.registerTileEntity(TileEntityKeyButton.class, (String)"storagedrawers:keybutton");
            if (config.isBlockEnabled("compdrawers")) {
                registry.register((IForgeRegistryEntry)new BlockCompDrawers("compdrawers", "storagedrawers.compDrawers"));
                GameRegistry.registerTileEntity(TileEntityDrawersComp.class, (String)"storagedrawers:compdrawers");
            }
            if (config.isBlockEnabled("controller")) {
                registry.register((IForgeRegistryEntry)new BlockController("controller", "storagedrawers.controller"));
                GameRegistry.registerTileEntity(TileEntityController.class, (String)"storagedrawers:controller");
            }
            if (config.isBlockEnabled("controllerSlave")) {
                registry.register((IForgeRegistryEntry)new BlockSlave("controllerslave", "storagedrawers.controllerSlave"));
                GameRegistry.registerTileEntity(TileEntitySlave.class, (String)"storagedrawers:controllerslave");
            }
            if (config.isBlockEnabled("trim")) {
                registry.register((IForgeRegistryEntry)new BlockTrim("trim", "storagedrawers.trim"));
            }
            if (config.cache.enableFramedDrawers) {
                registry.register((IForgeRegistryEntry)new BlockDrawersCustom("customdrawers", "storagedrawers.customDrawers"));
            }
            if (config.cache.enableFramedTrims) {
                registry.register((IForgeRegistryEntry)new BlockTrimCustom("customtrim", "storagedrawers.customTrim"));
                GameRegistry.registerTileEntity(TileEntityTrim.class, (String)"storagedrawers:trim");
            }
            if (config.cache.enableFramingTable) {
                registry.register((IForgeRegistryEntry)new BlockFramingTable("framingtable", "storagedrawers.framingTable"));
                GameRegistry.registerTileEntity(TileEntityFramingTable.class, (String)"storagedrawers:framingtable");
            }
        }

        @SubscribeEvent
        public static void registerItems(RegistryEvent.Register<Item> event) {
            IForgeRegistry registry = event.getRegistry();
            ConfigManager config = StorageDrawers.config;
            registry.registerAll((IForgeRegistryEntry[])new Item[]{(Item)new ItemBasicDrawers((Block)basicDrawers).setRegistryName(basicDrawers.getRegistryName()), (Item)new ItemKeyButton(keyButton).setRegistryName(keyButton.getRegistryName())});
            if (config.isBlockEnabled("compdrawers")) {
                registry.register((IForgeRegistryEntry)((Item)new ItemCompDrawers((Block)compDrawers).setRegistryName(compDrawers.getRegistryName())));
            }
            if (config.isBlockEnabled("controller")) {
                registry.register((IForgeRegistryEntry)((Item)new ItemController((Block)controller).setRegistryName(controller.getRegistryName())));
            }
            if (config.isBlockEnabled("controllerSlave")) {
                registry.register((IForgeRegistryEntry)((Item)new ItemBlock((Block)controllerSlave).setRegistryName(controllerSlave.getRegistryName())));
            }
            if (config.isBlockEnabled("trim")) {
                registry.register((IForgeRegistryEntry)((Item)new ItemTrim(trim).setRegistryName(trim.getRegistryName())));
            }
            if (config.cache.enableFramedDrawers) {
                registry.register((IForgeRegistryEntry)((Item)new ItemCustomDrawers((Block)customDrawers).setRegistryName(customDrawers.getRegistryName())));
            }
            if (config.cache.enableFramedTrims) {
                registry.register((IForgeRegistryEntry)((Item)new ItemCustomTrim(customTrim).setRegistryName(customTrim.getRegistryName())));
            }
            if (config.cache.enableFramingTable) {
                registry.register((IForgeRegistryEntry)((Item)new ItemFramingTable((Block)framingTable).setRegistryName(framingTable.getRegistryName())));
            }
            for (String key : new String[]{"drawerBasic"}) {
                OreDictionary.registerOre((String)key, (ItemStack)new ItemStack((Block)basicDrawers, 1, Short.MAX_VALUE));
            }
            for (String key : new String[]{"drawerTrim"}) {
                OreDictionary.registerOre((String)key, (ItemStack)new ItemStack((Block)trim, 1, Short.MAX_VALUE));
            }
        }

        @Nonnull
        public static ItemStack makeBasicDrawerItemStack(EnumBasicDrawer info, String material, int count) {
            ItemStack stack = new ItemStack((Block)basicDrawers, count, info.getMetadata());
            NBTTagCompound data = new NBTTagCompound();
            data.func_74778_a("material", material);
            stack.func_77982_d(data);
            return stack;
        }

        @SubscribeEvent
        public static void registerRecipes(RegistryEvent.Register<IRecipe> event) {
            IForgeRegistry registry = event.getRegistry();
            ConfigManager config = StorageDrawers.config;
            for (BlockPlanks.EnumType material : BlockPlanks.EnumType.values()) {
                ItemStack result;
                ItemStack pl = new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a());
                ItemStack sl = new ItemStack((Block)Blocks.field_150376_bx, 1, material.func_176839_a());
                if (config.isBlockEnabled(EnumBasicDrawer.FULL1.getUnlocalizedName())) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL1, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL1.getUnlocalizedName()));
                    registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xxx", " y ", "xxx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL1.getUnlocalizedName() + "_" + material.toString())));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.FULL2.getUnlocalizedName())) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL2, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL2.getUnlocalizedName()));
                    registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL2.getUnlocalizedName() + "_" + material.toString())));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.FULL4.getUnlocalizedName())) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.FULL4, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.FULL4.getUnlocalizedName()));
                    registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.FULL4.getUnlocalizedName() + "_" + material.toString())));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.HALF2.getUnlocalizedName())) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.HALF2, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF2.getUnlocalizedName()));
                    registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "xxx", "xyx", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150376_bx, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF2.getUnlocalizedName() + "_" + material.toString())));
                }
                if (config.isBlockEnabled(EnumBasicDrawer.HALF4.getUnlocalizedName())) {
                    result = Registration.makeBasicDrawerItemStack(EnumBasicDrawer.HALF4, material.func_176610_l(), config.getBlockRecipeOutput(EnumBasicDrawer.HALF4.getUnlocalizedName()));
                    registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"yxy", "xxx", "yxy", Character.valueOf('x'), new ItemStack((Block)Blocks.field_150376_bx, 1, material.func_176839_a()), Character.valueOf('y'), "chestWood"}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + EnumBasicDrawer.HALF4.getUnlocalizedName() + "_" + material.toString())));
                }
                if (!config.isBlockEnabled("trim")) continue;
                result = new ItemStack((Block)trim, config.getBlockRecipeOutput("trim"), material.func_176839_a());
                registry.register((IForgeRegistryEntry)((IRecipe)new ShapedOreRecipe(EMPTY_GROUP, result, new Object[]{"xyx", "yyy", "xyx", Character.valueOf('x'), "stickWood", Character.valueOf('y'), new ItemStack(Blocks.field_150344_f, 1, material.func_176839_a())}).setRegistryName(result.func_77973_b().getRegistryName() + "_" + material.toString())));
            }
        }

        @SubscribeEvent
        @SideOnly(value=Side.CLIENT)
        public static void registerModels(ModelRegistryEvent event) {
            if (basicDrawers != null) {
                basicDrawers.initDynamic();
            }
            if (compDrawers != null) {
                compDrawers.initDynamic();
            }
            if (customDrawers != null) {
                customDrawers.initDynamic();
            }
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDrawersStandard.class, (TileEntitySpecialRenderer)new TileEntityDrawersRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityDrawersComp.class, (TileEntitySpecialRenderer)new TileEntityDrawersRenderer());
            ClientRegistry.bindTileEntitySpecialRenderer(TileEntityFramingTable.class, (TileEntitySpecialRenderer)new TileEntityFramingRenderer());
            ModelRegistry modelRegistry = Chameleon.instance.modelRegistry;
            if (basicDrawers != null) {
                modelRegistry.registerModel((IUnifiedRegister)new BasicDrawerModel.Register());
            }
            if (compDrawers != null) {
                modelRegistry.registerModel((IUnifiedRegister)new CompDrawerModel.Register());
            }
            if (customDrawers != null) {
                modelRegistry.registerModel((IUnifiedRegister)new FramingTableModel.Register());
                modelRegistry.registerModel((IUnifiedRegister)new CustomDrawerModel.Register());
                modelRegistry.registerModel((IUnifiedRegister)new CustomTrimModel.Register());
            }
            modelRegistry.registerItemVariants((Block)trim);
            modelRegistry.registerItemVariants((Block)controller);
            modelRegistry.registerItemVariants((Block)controllerSlave);
            modelRegistry.registerItemVariants((Block)keyButton);
        }
    }
}

