/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.network;

import edivad.solargeneration.Main;
import edivad.solargeneration.tools.inter.ISolarPanelStateContainer;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;

public class PacketSyncMachineState
implements IMessage {
    private int energy;
    private int energyProducing;

    public PacketSyncMachineState() {
    }

    public PacketSyncMachineState(int energy, int energyProducing) {
        this.energy = energy;
        this.energyProducing = energyProducing;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.energy);
        buf.writeInt(this.energyProducing);
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.energy = buf.readInt();
            this.energyProducing = buf.readInt();
        }
        catch (IndexOutOfBoundsException ioe) {
            Main.logger.debug(ioe.getMessage());
            return;
        }
    }

    public static class Handler
    implements IMessageHandler<PacketSyncMachineState, IMessage> {
        public IMessage onMessage(PacketSyncMachineState message, MessageContext ctx) {
            Main.proxy.addScheduledTaskClient(() -> this.handle(message, ctx));
            return null;
        }

        private void handle(PacketSyncMachineState message, MessageContext ctx) {
            EntityPlayer player = Main.proxy.getClientPlayer();
            if (player.field_71070_bA instanceof ISolarPanelStateContainer) {
                ((ISolarPanelStateContainer)player.field_71070_bA).sync(message.energy, message.energyProducing);
            }
        }
    }
}

