/*
 * Decompiled with CFR 0.152.
 */
package edivad.solargeneration.blocks;

import edivad.solargeneration.Main;
import edivad.solargeneration.tile.TileEntityAdvancedSolarPanel;
import edivad.solargeneration.tile.TileEntityHardenedSolarPanel;
import edivad.solargeneration.tile.TileEntityLeadstoneSolarPanel;
import edivad.solargeneration.tile.TileEntityRedstoneSolarPanel;
import edivad.solargeneration.tile.TileEntityResonantSolarPanel;
import edivad.solargeneration.tile.TileEntitySignalumSolarPanel;
import edivad.solargeneration.tile.TileEntitySolarPanel;
import edivad.solargeneration.tile.TileEntityUltimateSolarPanel;
import edivad.solargeneration.tools.Platform;
import edivad.solargeneration.tools.SolarPanelLevel;
import edivad.solargeneration.tools.Tooltip;
import edivad.solargeneration.tools.inter.IGuiTile;
import edivad.solargeneration.tools.inter.IRestorableTileEntity;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class SolarPanel
extends Block
implements ITileEntityProvider {
    private final SolarPanelLevel levelSolarPanel;
    private static final AxisAlignedBB AABB_TOP_HALF = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.75, 1.0);

    public SolarPanel(SolarPanelLevel levelSolarPanel) {
        super(Material.field_151573_f);
        this.func_149672_a(SoundType.field_185852_e);
        this.func_149711_c(5.0f);
        this.func_149752_b(30.0f);
        this.setHarvestLevel("pickaxe", 0);
        this.levelSolarPanel = levelSolarPanel;
        this.setRegistryName(levelSolarPanel.getBlockResourceLocation());
        this.func_149663_c("solargeneration." + levelSolarPanel.getBlockResourceLocation().func_110623_a());
        this.func_149647_a(Main.solarGenerationTab);
    }

    public SolarPanelLevel getLevelSolarPanel() {
        return this.levelSolarPanel;
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return Item.func_111206_d((String)("solargeneration:solar_panel_" + this.levelSolarPanel.name().toLowerCase()));
    }

    public ItemStack func_185473_a(World worldIn, BlockPos pos, IBlockState state) {
        return new ItemStack(this.func_180660_a(state, RANDOM, 0));
    }

    public int func_149745_a(Random random) {
        return 1;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean func_149730_j(IBlockState state) {
        return false;
    }

    public boolean func_149686_d(IBlockState state) {
        return false;
    }

    public boolean isSideSolid(IBlockState base_state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        return side == EnumFacing.DOWN;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB_TOP_HALF;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (worldIn.field_72995_K) {
            return true;
        }
        if (playerIn != null && Platform.isWrench(playerIn, playerIn.func_184614_ca(), pos) && playerIn.func_70093_af()) {
            this.dismantleBlock(worldIn, pos);
            return true;
        }
        TileEntity te = worldIn.func_175625_s(pos);
        if (!(te instanceof IGuiTile)) {
            return false;
        }
        playerIn.openGui((Object)Main.instance, 0, worldIn, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
        return true;
    }

    private void dismantleBlock(World worldIn, BlockPos pos) {
        ItemStack itemStack = new ItemStack((Block)this);
        TileEntitySolarPanel localTileEntity = (TileEntitySolarPanel)worldIn.func_175625_s(pos);
        int internalEnergy = localTileEntity.getEnergy();
        if (internalEnergy > 0) {
            if (itemStack.func_77978_p() == null) {
                itemStack.func_77982_d(new NBTTagCompound());
            }
            itemStack.func_77978_p().func_74768_a("energy", internalEnergy);
        }
        worldIn.func_175698_g(pos);
        EntityItem entityItem = new EntityItem(worldIn, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, itemStack);
        entityItem.field_70159_w = 0.0;
        entityItem.field_70179_y = 0.0;
        worldIn.func_72838_d((Entity)entityItem);
    }

    public void getDrops(NonNullList<ItemStack> result, IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        TileEntity tileEntity = world.func_175625_s(pos);
        if (tileEntity instanceof IRestorableTileEntity) {
            ItemStack stack = new ItemStack(Item.func_150898_a((Block)this));
            NBTTagCompound tagCompound = new NBTTagCompound();
            ((IRestorableTileEntity)tileEntity).writeRestorableToNBT(tagCompound);
            stack.func_77982_d(tagCompound);
            result.add((Object)stack);
        } else {
            super.getDrops(result, world, pos, state, fortune);
        }
    }

    public boolean removedByPlayer(IBlockState state, World world, BlockPos pos, EntityPlayer player, boolean willHarvest) {
        if (willHarvest) {
            return true;
        }
        return super.removedByPlayer(state, world, pos, player, willHarvest);
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, TileEntity te, ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        worldIn.func_175698_g(pos);
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        NBTTagCompound tagCompound;
        super.func_180633_a(worldIn, pos, state, placer, stack);
        TileEntity tileEntity = worldIn.func_175625_s(pos);
        if (tileEntity instanceof IRestorableTileEntity && (tagCompound = stack.func_77978_p()) != null) {
            ((IRestorableTileEntity)tileEntity).readRestorableFromNBT(tagCompound);
        }
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        switch (this.levelSolarPanel) {
            case Leadstone: {
                return new TileEntityLeadstoneSolarPanel();
            }
            case Hardened: {
                return new TileEntityHardenedSolarPanel();
            }
            case Redstone: {
                return new TileEntityRedstoneSolarPanel();
            }
            case Signalum: {
                return new TileEntitySignalumSolarPanel();
            }
            case Resonant: {
                return new TileEntityResonantSolarPanel();
            }
            case Advanced: {
                return new TileEntityAdvancedSolarPanel();
            }
            case Ultimate: {
                return new TileEntityUltimateSolarPanel();
            }
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World player, List<String> tooltip, ITooltipFlag advanced) {
        NBTTagCompound tagCompound = stack.func_77978_p();
        int energy = 0;
        if (tagCompound != null) {
            energy = tagCompound.func_74762_e("energy");
        }
        Tooltip.showInfoCtrl(energy, tooltip);
        Tooltip.showInfoShift(this.levelSolarPanel, tooltip);
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        ModelLoader.setCustomModelResourceLocation((Item)Item.func_150898_a((Block)this), (int)0, (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
    }
}

