/*
 * Decompiled with CFR 0.152.
 */
package com.github.lunatrius.schematica.handler.client;

import com.github.lunatrius.schematica.client.renderer.RenderSchematic;
import com.github.lunatrius.schematica.client.world.SchematicWorld;
import com.github.lunatrius.schematica.proxy.ClientProxy;
import com.github.lunatrius.schematica.reference.Reference;
import net.minecraft.world.IWorldEventListener;
import net.minecraft.world.World;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

public class WorldHandler {
    @SubscribeEvent
    public void onLoad(WorldEvent.Load event) {
        World world = event.getWorld();
        if (world.field_72995_K && !(world instanceof SchematicWorld)) {
            RenderSchematic.INSTANCE.setWorldAndLoadRenderers(ClientProxy.schematic);
            WorldHandler.addWorldAccess(world, (IWorldEventListener)RenderSchematic.INSTANCE);
        }
    }

    @SubscribeEvent
    public void onUnload(WorldEvent.Unload event) {
        World world = event.getWorld();
        if (world.field_72995_K) {
            WorldHandler.removeWorldAccess(world, (IWorldEventListener)RenderSchematic.INSTANCE);
        }
    }

    public static void addWorldAccess(World world, IWorldEventListener schematic) {
        if (world != null && schematic != null) {
            Reference.logger.debug("Adding world access to {}", (Object)world);
            world.func_72954_a(schematic);
        }
    }

    public static void removeWorldAccess(World world, IWorldEventListener schematic) {
        if (world != null && schematic != null) {
            Reference.logger.debug("Removing world access from {}", (Object)world);
            world.func_72848_b(schematic);
        }
    }
}

