/*
 * Decompiled with CFR 0.152.
 */
package technicianlp.reauth.mojangfix;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.Socket;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedTrustManager;
import javax.net.ssl.X509TrustManager;
import technicianlp.reauth.ReAuth;

public final class CertWorkaround {
    private static final String MICROSOFT2017 = "microsoftrsarootcertificateauthority2017";
    private static final String AMAZON1 = "amazonrootca1";
    private static final String DIGICERT2 = "digicertglobalrootg2";
    private static SSLSocketFactory socketFactory = null;

    public static SSLSocketFactory getSocketFactory() {
        return socketFactory;
    }

    static void checkCertificates() {
        try {
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            X509Certificate microsoft2017 = CertWorkaround.loadCertificate(cf, MICROSOFT2017);
            X509Certificate amazon1 = CertWorkaround.loadCertificate(cf, AMAZON1);
            X509Certificate digicert2 = CertWorkaround.loadCertificate(cf, DIGICERT2);
            TrustManagerFactory defaultTrust = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            defaultTrust.init((KeyStore)null);
            List<X509Certificate> trustedCerts = CertWorkaround.getTrustedCerts(defaultTrust);
            HashMap<String, X509Certificate> missingCerts = new HashMap<String, X509Certificate>();
            if (!trustedCerts.contains(microsoft2017)) {
                missingCerts.put(MICROSOFT2017, microsoft2017);
            }
            if (!trustedCerts.contains(amazon1)) {
                missingCerts.put(AMAZON1, amazon1);
            }
            if (!trustedCerts.contains(digicert2)) {
                missingCerts.put(DIGICERT2, digicert2);
            }
            if (missingCerts.isEmpty()) {
                return;
            }
            ReAuth.log.warn("Some Certificates required for authentication are untrusted by default");
            X509ExtendedTrustManager defaultTrustManager = CertWorkaround.findX509ExtendedTrustManager(defaultTrust);
            X509ExtendedTrustManager missingTrustManager = CertWorkaround.findX509ExtendedTrustManager(CertWorkaround.createTrustFactory(missingCerts));
            CombinedX509ExtendedTrustManager combinedTrustManager = new CombinedX509ExtendedTrustManager(new X509ExtendedTrustManager[]{defaultTrustManager, missingTrustManager});
            SSLContext context = SSLContext.getInstance("TLS");
            context.init(null, new X509ExtendedTrustManager[]{combinedTrustManager}, null);
            socketFactory = context.getSocketFactory();
            ReAuth.log.info("Successfully built SSLSocketFactory with required Certificates");
        }
        catch (IOException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    private static X509Certificate loadCertificate(CertificateFactory certFactory, String name) throws CertificateException, IOException {
        Throwable throwable = null;
        try (InputStream is = CertWorkaround.class.getResourceAsStream("/resources/reauth/certs/" + name + ".pem");){
            if (is != null) {
                X509Certificate x509Certificate = (X509Certificate)certFactory.generateCertificate(is);
                return x509Certificate;
            }
            try {
                throw new FileNotFoundException("Certificate " + name + " is unavailable");
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
    }

    private static List<X509Certificate> getTrustedCerts(TrustManagerFactory trustManagerFactory) {
        X509ExtendedTrustManager trustManager = CertWorkaround.findX509ExtendedTrustManager(trustManagerFactory);
        if (trustManager != null) {
            return new ArrayList<X509Certificate>(Arrays.asList(trustManager.getAcceptedIssuers()));
        }
        return new ArrayList<X509Certificate>();
    }

    private static TrustManagerFactory createTrustFactory(Map<String, X509Certificate> certificates) throws KeyStoreException, CertificateException, IOException, NoSuchAlgorithmException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null);
        for (Map.Entry<String, X509Certificate> certificate : certificates.entrySet()) {
            ReAuth.log.info("Adding Certificate {} to trust", (Object)certificate.getKey());
            ks.setCertificateEntry(certificate.getKey(), certificate.getValue());
        }
        TrustManagerFactory trustFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustFactory.init(ks);
        return trustFactory;
    }

    private static X509ExtendedTrustManager findX509ExtendedTrustManager(TrustManagerFactory trustManagerFactory) {
        return Arrays.stream(trustManagerFactory.getTrustManagers()).filter(X509ExtendedTrustManager.class::isInstance).map(X509ExtendedTrustManager.class::cast).findFirst().orElse(null);
    }

    @FunctionalInterface
    private static interface CertificateCheckConsumer {
        public void check(X509ExtendedTrustManager var1) throws CertificateException;
    }

    private static final class CombinedX509ExtendedTrustManager
    extends X509ExtendedTrustManager {
        private final List<X509ExtendedTrustManager> trustManagers;

        private CombinedX509ExtendedTrustManager(X509ExtendedTrustManager ... trustManagers) {
            this.trustManagers = new ArrayList<X509ExtendedTrustManager>(Arrays.asList(trustManagers));
            if (this.trustManagers.isEmpty()) {
                throw new IllegalArgumentException("At least one X509ExtendedTrustManager is required");
            }
            if (this.trustManagers.contains(null)) {
                throw new IllegalArgumentException("X509ExtendedTrustManager cannot be null");
            }
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.check(tm -> tm.checkClientTrusted(chain, authType, socket));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
            this.check(tm -> tm.checkServerTrusted(chain, authType, socket));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.check(tm -> tm.checkClientTrusted(chain, authType, engine));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
            this.check(tm -> tm.checkServerTrusted(chain, authType, engine));
        }

        @Override
        public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.check(tm -> tm.checkClientTrusted(chain, authType));
        }

        @Override
        public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
            this.check(tm -> tm.checkServerTrusted(chain, authType));
        }

        @Override
        public X509Certificate[] getAcceptedIssuers() {
            return (X509Certificate[])this.trustManagers.stream().map(X509TrustManager::getAcceptedIssuers).flatMap(Arrays::stream).toArray(X509Certificate[]::new);
        }

        private void check(CertificateCheckConsumer checkFunction) throws CertificateException {
            LinkedList<CertificateException> exceptions = new LinkedList<CertificateException>();
            for (X509ExtendedTrustManager trustManager : this.trustManagers) {
                try {
                    checkFunction.check(trustManager);
                    return;
                }
                catch (CertificateException e) {
                    exceptions.add(e);
                }
            }
            CertificateException last = (CertificateException)exceptions.removeLast();
            exceptions.forEach(last::addSuppressed);
            throw last;
        }
    }
}

